/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class HorizontalLayout
implements LayoutManager {
    int hgap;

    public HorizontalLayout(int hgap) {
        this.hgap = hgap;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Insets insets = parent.getInsets();
        int n = parent.getComponentCount();
        int height = 0;
        int width = n > 1 ? (n - 1) * this.hgap : 0;
        for (int i = 0; i < n; ++i) {
            Component c = parent.getComponent(i);
            Dimension d = c.getPreferredSize();
            width += d.width;
            height = Math.max(height, d.height);
        }
        return new Dimension(width + insets.left + insets.right, height + insets.top + insets.bottom);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    @Override
    public void layoutContainer(Container parent) {
        int n = parent.getComponentCount();
        Dimension d = parent.getSize();
        Insets insets = parent.getInsets();
        int height = d.height - insets.top - insets.bottom;
        int x = insets.left;
        int y = insets.top;
        for (int i = 0; i < n; ++i) {
            Component c = parent.getComponent(i);
            d = c.getPreferredSize();
            c.setBounds(x, y, d.width, height);
            x += d.width + this.hgap;
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exc) {
            System.out.println("Error loading L&F: " + exc);
        }
        JFrame frame = new JFrame("Test");
        JPanel panel = new JPanel(new HorizontalLayout(10));
        panel.add(new JLabel("One", 2));
        panel.add(new JLabel("Two", 4));
        panel.add(new JLabel("Three", 0));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        frame.getContentPane().add(panel);
        frame.pack();
        frame.setVisible(true);
    }
}

