/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class ColumnLayout
implements LayoutManager {
    private int vgap;
    private int hgap;
    private int compWidth;
    private int compHeight;
    private int preferredNumCols;

    public ColumnLayout(int hgap, int vgap, int preferredNumCols) {
        this.hgap = hgap;
        this.vgap = vgap;
        this.preferredNumCols = preferredNumCols;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Insets insets = parent.getInsets();
        int n = parent.getComponentCount();
        this.computeComponentSize(parent);
        int numRows = (n + this.preferredNumCols - 1) / this.preferredNumCols;
        int numCols = (n + numRows - 1) / numRows;
        int height = numRows * this.compHeight + (numRows - 1) * this.vgap;
        int width = numCols * this.compWidth + (numCols - 1) * this.hgap;
        Dimension d = new Dimension(width + insets.left + insets.right + 2, height + insets.top + insets.bottom + 2);
        return d;
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Insets insets = parent.getInsets();
        return new Dimension(this.compWidth + insets.left + insets.right, this.compHeight + insets.top + insets.bottom);
    }

    @Override
    public void layoutContainer(Container parent) {
        int n = parent.getComponentCount();
        if (n == 0) {
            return;
        }
        this.computeComponentSize(parent);
        Dimension d = parent.getSize();
        Insets insets = parent.getInsets();
        int parentWidth = d.width - insets.left - insets.right;
        int parentHeight = d.height - insets.top - insets.bottom;
        int maxRows = (parentHeight + this.vgap) / this.compHeight + this.vgap;
        if (maxRows == 0) {
            return;
        }
        int numCols = (n + maxRows - 1) / maxRows;
        int numRows = (n + numCols - 1) / numCols;
        int left = insets.left + (parentWidth - numCols * this.compWidth - (numCols - 1) * this.hgap) / 2;
        int top = insets.top;
        for (int i = 0; i < numRows; ++i) {
            for (int j = 0; j < numCols; ++j) {
                int x = left + j * (this.compWidth + this.hgap);
                int y = top + i * (this.compHeight + this.vgap);
                int k = j * numRows + i;
                if (k >= n) continue;
                Component c = parent.getComponent(k);
                c.setBounds(x, y, this.compWidth, this.compHeight);
            }
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exc) {
            System.out.println("Error loading L&F: " + exc);
        }
        JFrame frame = new JFrame("Test");
        JPanel panel = new JPanel(new ColumnLayout(0, 0, 2));
        panel.add(new JLabel("One ", 2));
        panel.add(new JLabel("Two ", 2));
        panel.add(new JLabel("Three ", 2));
        panel.add(new JLabel("Four ", 2));
        panel.add(new JLabel("This is a test of the ", 2));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        frame.getContentPane().add(panel);
        frame.pack();
        frame.setVisible(true);
    }

    private void computeComponentSize(Container parent) {
        int n = parent.getComponentCount();
        this.compWidth = 0;
        this.compHeight = 0;
        for (int i = 0; i < n; ++i) {
            Component c = parent.getComponent(i);
            Dimension d = c.getPreferredSize();
            this.compWidth = Math.max(this.compWidth, d.width);
            this.compHeight = Math.max(this.compHeight, d.height);
        }
    }
}

