/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.datastruct.Range;
import ghidra.util.datastruct.SortedRangeList;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

public class AdjacentSortedRangeList
extends SortedRangeList {
    public AdjacentSortedRangeList() {
    }

    public AdjacentSortedRangeList(AdjacentSortedRangeList list) {
        this.set = new TreeSet();
        for (Range r : list.set) {
            this.addRange(r.min, r.max);
        }
    }

    @Override
    public void addRange(int min, int max) {
        SortedSet<Range> ss;
        Range key = new Range(min, min);
        SortedSet<Range> headSet = this.set.headSet(key);
        if (!headSet.isEmpty()) {
            Range last = headSet.last();
            if (min <= last.max) {
                last.max = Math.max(last.max, max);
                this.coalesce(last, this.set.tailSet(key).iterator());
                return;
            }
        }
        if ((ss = this.set.tailSet(key)).isEmpty()) {
            this.set.add(new Range(min, max));
            return;
        }
        Iterator<Range> it = ss.iterator();
        Range first = (Range)it.next();
        if (max < first.min) {
            this.set.add(new Range(min, max));
            return;
        }
        first.min = Math.min(first.min, min);
        first.max = Math.max(first.max, max);
        this.coalesce(first, it);
    }

    public AdjacentSortedRangeList intersect(AdjacentSortedRangeList other) {
        AdjacentSortedRangeList srl = new AdjacentSortedRangeList(this);
        srl.remove(other);
        AdjacentSortedRangeList srl2 = new AdjacentSortedRangeList(this);
        srl2.remove(srl);
        int num = other.getNumRanges();
        for (int otherIndex = 0; otherIndex < num - 1; ++otherIndex) {
            int myIndex;
            Range r = other.getRange(otherIndex);
            Range rNext = other.getRange(otherIndex + 1);
            if (r.max + 1 != rNext.min || (myIndex = srl2.getRangeIndex(r.max)) < 0) continue;
            Range myRange = srl2.getRange(myIndex);
            int min = myRange.min;
            int max = myRange.max;
            if (max < rNext.min) continue;
            srl2.removeRange(min, max);
            srl2.addRange(min, r.max);
            srl2.addRange(rNext.min, max);
        }
        return srl2;
    }
}

