/*
 * Decompiled with CFR 0.152.
 */
package ghidra.server.stream;

import db.buffers.BlockStream;
import db.buffers.BlockStreamHandle;
import db.buffers.BufferFileBlock;
import db.buffers.OutputBlockStream;
import ghidra.server.stream.BlockStreamServer;
import ghidra.server.stream.RemoteBlockStreamHandle;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public class RemoteOutputBlockStreamHandle
extends RemoteBlockStreamHandle<OutputBlockStream>
implements BlockStreamHandle<OutputBlockStream> {
    public static final long serialVersionUID = 1L;

    public RemoteOutputBlockStreamHandle(BlockStreamServer server, int blockCount, int blockSize) throws IOException {
        super(server, blockCount, blockSize);
    }

    public OutputBlockStream openBlockStream() throws IOException {
        Socket socket = this.connect();
        socket.setSendBufferSize(this.getPreferredBufferSize());
        return new ClientOutputBlockStream(socket);
    }

    @Override
    void serveBlockStream(Socket socket, BlockStream blockStream) throws IOException {
        if (!(blockStream instanceof OutputBlockStream)) {
            throw new IllegalArgumentException("expected OutputBlockStream");
        }
        socket.setReceiveBufferSize(this.getPreferredBufferSize());
        OutputBlockStream outputBlockStream = (OutputBlockStream)blockStream;
        try (InputStream in = socket.getInputStream();){
            this.copyBlockData(outputBlockStream, in);
            this.readStreamEnd(socket, true);
            outputBlockStream.close();
            this.writeStreamEnd(socket);
        }
        catch (SocketException e) {
            if (e.getMessage().startsWith("Broken pipe")) {
                throw new EOFException("unexpected end of stream");
            }
            throw e;
        }
    }

    private void copyBlockData(OutputBlockStream outputBlockStream, InputStream in) throws IOException, EOFException {
        if (this.compressed) {
            in = new InflaterInputStream(in);
        }
        byte[] bytes = new byte[this.getBlockSize() + 4];
        for (int blocksRemaining = this.getBlockCount(); blocksRemaining > 0; --blocksRemaining) {
            int readlen;
            for (int total = 0; total < bytes.length; total += readlen) {
                readlen = in.read(bytes, total, bytes.length - total);
                if (readlen >= 0) continue;
                throw new EOFException("unexpected end of stream");
            }
            BufferFileBlock block = new BufferFileBlock(bytes);
            outputBlockStream.writeBlock(block);
        }
        if (this.compressed && in.read() != -1) {
            throw new IOException("expected end of compressed stream");
        }
    }

    private class ClientOutputBlockStream
    implements OutputBlockStream {
        private final Socket socket;
        private final OutputStream out;
        private int blocksRemaining = this.getBlockCount();

        ClientOutputBlockStream(Socket socket) throws IOException {
            this.socket = socket;
            this.out = RemoteOutputBlockStreamHandle.this.compressed ? new DeflaterOutputStream(socket.getOutputStream(), new Deflater(1)) : socket.getOutputStream();
        }

        public int getBlockCount() {
            return RemoteOutputBlockStreamHandle.this.getBlockCount();
        }

        public int getBlockSize() {
            return RemoteOutputBlockStreamHandle.this.getBlockSize();
        }

        public void close() throws IOException {
            this.socket.getOutputStream().close();
        }

        public void writeBlock(BufferFileBlock block) throws IOException {
            if (this.blocksRemaining == 0) {
                throw new EOFException("unexpected data in stream");
            }
            this.out.write(block.toBytes());
            if (--this.blocksRemaining == 0) {
                if (this.out instanceof DeflaterOutputStream) {
                    ((DeflaterOutputStream)this.out).finish();
                }
                RemoteOutputBlockStreamHandle.this.writeStreamEnd(this.socket);
                RemoteOutputBlockStreamHandle.this.readStreamEnd(this.socket, false);
            }
        }
    }
}

