/*
 * Decompiled with CFR 0.152.
 */
package ghidra.server.remote;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class GhidraSSLServerSocket
extends ServerSocket {
    private static ThreadLocal<Principal> pricipalContext = new ThreadLocal();
    private final SSLSocketFactory sslSocketFactory;
    private final String[] enabledCipherSuites;
    private final String[] enabledProtocols;
    private final boolean needClientAuth;

    public static Principal getThreadClientPrincipal() {
        return pricipalContext.get();
    }

    GhidraSSLServerSocket(int port, String[] enabledCipherSuites, String[] enabledProtocols, boolean needClientAuth) throws IOException {
        super(port);
        this.enabledCipherSuites = enabledCipherSuites;
        this.enabledProtocols = enabledProtocols;
        this.needClientAuth = needClientAuth;
        try {
            this.sslSocketFactory = SSLContext.getDefault().getSocketFactory();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Socket accept() throws IOException {
        Socket socket = super.accept();
        SSLSocket sslSocket = (SSLSocket)this.sslSocketFactory.createSocket(socket, socket.getInetAddress().getHostAddress(), socket.getPort(), true);
        sslSocket.setUseClientMode(false);
        if (this.enabledCipherSuites != null) {
            sslSocket.setEnabledCipherSuites(this.enabledCipherSuites);
        }
        if (this.enabledProtocols != null) {
            sslSocket.setEnabledProtocols(this.enabledProtocols);
        }
        sslSocket.setNeedClientAuth(this.needClientAuth);
        return sslSocket;
    }
}

