/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import java.util.Set;
import util.CollectionUtils;

public final class NamingUtilities {
    public static final int MAX_NAME_LENGTH = 60;
    private static final char MANGLE_CHAR = '_';
    private static final Set<Character> VALID_NAME_SET = CollectionUtils.asSet((Object[])new Character[]{Character.valueOf('.'), Character.valueOf('-'), Character.valueOf(' '), Character.valueOf('_')});

    private NamingUtilities() {
    }

    public static boolean isValidName(String name) {
        if (name == null) {
            return false;
        }
        if (name.indexOf(47) >= 0) {
            return false;
        }
        if (name.length() < 1 || name.length() > 60) {
            return false;
        }
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isLetterOrDigit(c) || VALID_NAME_SET.contains(Character.valueOf(c))) continue;
            return false;
        }
        return true;
    }

    public static char findInvalidChar(String name) {
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isLetterOrDigit(c) || VALID_NAME_SET.contains(Character.valueOf(c))) continue;
            return c;
        }
        return '\u0000';
    }

    public static String mangle(String name) {
        int len = name.length();
        StringBuffer buf = new StringBuffer(2 * len);
        for (int i = 0; i < len; ++i) {
            char c = name.charAt(i);
            if (c == '_') {
                buf.append('_');
                buf.append('_');
                continue;
            }
            if (Character.isUpperCase(c)) {
                buf.append('_');
                buf.append(Character.toLowerCase(c));
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public static String demangle(String name) {
        int len = name.length();
        StringBuffer buf = new StringBuffer(len);
        boolean foundMangle = false;
        for (int i = 0; i < len; ++i) {
            char c = name.charAt(i);
            if (foundMangle) {
                foundMangle = false;
                if (c == '_') {
                    buf.append(c);
                    continue;
                }
                buf.append(Character.toUpperCase(c));
                continue;
            }
            if (c == '_') {
                foundMangle = true;
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public static boolean isValidMangledName(String name) {
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            char c = name.charAt(i);
            if (!Character.isUpperCase(c)) continue;
            return false;
        }
        return true;
    }
}

