/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.component.DecompilerController;
import ghidra.app.decompiler.component.DecompilerPanel;
import ghidra.app.decompiler.component.DecompilerUtils;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.program.model.pcode.Varnode;
import ghidra.util.Msg;
import java.awt.Component;
import java.util.HashSet;

public class HighlightDefinedUseAction
extends DockingAction {
    private final DecompilerController controller;

    public HighlightDefinedUseAction(String owner, DecompilerController controller) {
        super("Highlight Defined Use", owner);
        this.controller = controller;
        this.setPopupMenuData(new MenuData(new String[]{"Highlight Def-use"}, "Decompile"));
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (!(context instanceof DecompilerActionContext)) {
            return false;
        }
        DecompilerActionContext decompilerActionContext = (DecompilerActionContext)context;
        if (decompilerActionContext.isDecompiling()) {
            return true;
        }
        DecompilerPanel decompilerPanel = this.controller.getDecompilerPanel();
        ClangToken tokenAtCursor = decompilerPanel.getTokenAtCursor();
        Varnode varnode = DecompilerUtils.getVarnodeRef(tokenAtCursor);
        return varnode != null;
    }

    public void actionPerformed(ActionContext context) {
        DecompilerActionContext decompilerActionContext = (DecompilerActionContext)context;
        if (decompilerActionContext.isDecompiling()) {
            Msg.showInfo(((Object)((Object)this)).getClass(), (Component)context.getComponentProvider().getComponent(), (String)"Decompiler Action Blocked", (Object)"You cannot perform Decompiler actions while the Decompiler is busy");
            return;
        }
        DecompilerPanel decompilerPanel = this.controller.getDecompilerPanel();
        ClangToken tokenAtCursor = decompilerPanel.getTokenAtCursor();
        Varnode varnode = DecompilerUtils.getVarnodeRef(tokenAtCursor);
        if (varnode != null) {
            HashSet<Varnode> varnodes = new HashSet<Varnode>();
            varnodes.add(varnode);
            decompilerPanel.clearHighlights();
            decompilerPanel.addVarnodeHighlights(varnodes, decompilerPanel.getDefaultHighlightColor(), varnode, varnode.getDef(), decompilerPanel.getDefaultSpecialColor());
            decompilerPanel.repaint();
        }
    }
}

