/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import ghidra.app.cmd.label.RenameLabelCmd;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.DecompInterface;
import ghidra.app.decompiler.DecompileOptions;
import ghidra.app.decompiler.DecompileResults;
import ghidra.app.decompiler.DecompilerLocation;
import ghidra.app.plugin.core.decompile.actions.CreateStructureVariableAction;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.model.DomainObject;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.OptionsService;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.lang.PrototypeModel;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.GhidraClass;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.listing.VariableUtilities;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighFunctionDBUtil;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.pcode.HighVariable;
import ghidra.program.model.pcode.PcodeException;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.util.FunctionParameterFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.VariableLocation;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class FillOutStructureCmd
extends BackgroundCommand {
    private static final String DEFAULT_BASENAME = "astruct";
    private static final String DEFAULT_CATEGORY = "/auto_structs";
    private long maxOffset = 0L;
    private int currentCallDepth = 0;
    private int maxCallDepth = 1;
    private HashMap<Long, DataType> offsetToDataTypeMap = new HashMap();
    private HashMap<Address, Integer> addressToCallInputMap = new HashMap();
    private Program currentProgram;
    private ProgramLocation currentLocation;
    private Function rootFunction;
    private TaskMonitor monitor;
    private PluginTool tool;

    public FillOutStructureCmd(Program program, ProgramLocation location, PluginTool tool) {
        super("Fill Out Structure", true, false, true);
        this.tool = tool;
        this.currentProgram = program;
        this.currentLocation = location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean applyTo(DomainObject obj, TaskMonitor taskMonitor) {
        this.monitor = taskMonitor;
        this.rootFunction = this.currentProgram.getFunctionManager().getFunctionContaining(this.currentLocation.getAddress());
        if (this.rootFunction == null) {
            return false;
        }
        int transaction = this.currentProgram.startTransaction("Fill Out Structure Variable");
        try {
            HighVariable var = null;
            if (!(this.currentLocation instanceof DecompilerLocation)) {
                Address storageAddr = this.computeStorageAddress(this.currentLocation, this.rootFunction);
                var = this.computeHighVariable(storageAddr, this.rootFunction);
            } else {
                DecompilerLocation dloc = (DecompilerLocation)this.currentLocation;
                ClangToken token = dloc.getToken();
                if (token == null) {
                    boolean bl = false;
                    return bl;
                }
                var = token.getHighVariable();
                Varnode exactSpot = token.getVarnode();
                if (var != null && exactSpot != null) {
                    HighFunction hfunc = var.getHighFunction();
                    try {
                        var = hfunc.splitOutMergeGroup(var, exactSpot);
                    }
                    catch (PcodeException ex) {
                        boolean bl = false;
                        this.currentProgram.endTransaction(transaction, true);
                        return bl;
                    }
                }
            }
            if (var == null) {
                boolean dloc = false;
                return dloc;
            }
            boolean isThisParam = CreateStructureVariableAction.testForAutoParameterThis(var, this.rootFunction);
            this.fillOutStructureDef(var);
            Structure structDT = this.createStructure(var, this.rootFunction, isThisParam);
            this.populateStructure(structDT);
            this.pushIntoCalls(structDT);
            PointerDataType pointerDT = new PointerDataType((DataType)structDT);
            pointerDT = this.currentProgram.getDataTypeManager().addDataType((DataType)pointerDT, DataTypeConflictHandler.DEFAULT_HANDLER);
            this.commitVariable(var, (DataType)pointerDT, isThisParam);
        }
        catch (Exception e) {
            Msg.showError((Object)((Object)this), (Component)this.tool.getToolFrame(), (String)"Auto Create Structure Failed", (Object)"Failed to create Structure variable", (Throwable)e);
        }
        finally {
            this.currentProgram.endTransaction(transaction, true);
        }
        return true;
    }

    private Address computeParamAddress(Function function, int paramIndex, DataType pointerDt) {
        Parameter[] parameters = function.getParameters();
        if (paramIndex < parameters.length) {
            return parameters[paramIndex].getMinAddress();
        }
        PrototypeModel model = function.getCallingConvention();
        if (model == null && (model = this.currentProgram.getCompilerSpec().getDefaultCallingConvention()) == null) {
            return null;
        }
        VariableStorage argLocation = model.getArgLocation(paramIndex, null, pointerDt, this.currentProgram);
        return argLocation.getMinAddress();
    }

    private void pushIntoCalls(Structure structDT) {
        AddressSet doneSet = new AddressSet();
        PointerDataType pointerDT = new PointerDataType((DataType)structDT);
        while (this.addressToCallInputMap.size() > 0) {
            ++this.currentCallDepth;
            if (this.currentCallDepth > this.maxCallDepth) {
                return;
            }
            HashMap<Address, Integer> savedList = this.addressToCallInputMap;
            this.addressToCallInputMap = new HashMap();
            Set<Address> keys = savedList.keySet();
            for (Address addr : keys) {
                int paramIndex;
                if (doneSet.contains(addr)) continue;
                doneSet.addRange(addr, addr);
                Function func = this.currentProgram.getFunctionManager().getFunctionAt(addr);
                Address storageAddr = this.computeParamAddress(func, paramIndex = savedList.get(addr).intValue(), (DataType)pointerDT);
                HighVariable paramHighVar = this.computeHighVariable(storageAddr, func);
                if (paramHighVar == null) continue;
                this.fillOutStructureDef(paramHighVar);
                this.populateStructure(structDT);
            }
        }
    }

    private void commitVariable(HighVariable var, DataType newDt, boolean isThisParam) {
        if (!isThisParam) {
            try {
                HighFunctionDBUtil.updateDBVariable((HighVariable)var, null, (DataType)newDt, (SourceType)SourceType.USER_DEFINED);
            }
            catch (DuplicateNameException e) {
                throw new AssertException("Unexpected exception", (Throwable)e);
            }
            catch (InvalidInputException e) {
                Msg.error((Object)((Object)this), (Object)("Failed to re-type variable " + var.getName() + ": " + e.getMessage()));
            }
        }
    }

    private Address computeStorageAddress(ProgramLocation location, Function function) {
        Address storageAddress = null;
        if (location instanceof VariableLocation) {
            VariableLocation varLoc = (VariableLocation)location;
            storageAddress = varLoc.getVariable().getVariableStorage().getMinAddress();
        } else if (location instanceof FunctionParameterFieldLocation) {
            FunctionParameterFieldLocation funcPFL = (FunctionParameterFieldLocation)location;
            storageAddress = funcPFL.getParameter().getVariableStorage().getMinAddress();
        }
        return storageAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HighVariable computeHighVariable(Address storageAddress, Function function) {
        if (storageAddress == null) {
            return null;
        }
        DecompInterface decomplib = this.setUpDecompiler();
        HighVariable highVar = null;
        try {
            if (!decomplib.openProgram(this.currentProgram)) {
                HighVariable highVariable = null;
                return highVariable;
            }
            DecompileResults results = this.decompileFunction(function, decomplib);
            HighFunction highFunc = results.getHighFunction();
            if (highFunc == null) {
                HighVariable highVariable = null;
                return highVariable;
            }
            HighSymbol sym = highFunc.getMappedSymbol(storageAddress, function.getEntryPoint().subtractWrap(1L));
            if (sym == null) {
                sym = highFunc.getMappedSymbol(storageAddress, null);
            }
            if (sym == null) {
                sym = highFunc.getMappedSymbol(storageAddress, function.getEntryPoint());
            }
            if (sym == null) {
                sym = highFunc.getLocalSymbolMap().findLocal(storageAddress, function.getEntryPoint().subtractWrap(1L));
            }
            if (sym == null) {
                sym = highFunc.getLocalSymbolMap().findLocal(storageAddress, null);
            }
            if (sym == null) {
                sym = highFunc.getLocalSymbolMap().findLocal(storageAddress, function.getEntryPoint());
            }
            if (sym == null) {
                HighVariable highVariable = null;
                return highVariable;
            }
            highVar = sym.getHighVariable();
        }
        finally {
            decomplib.dispose();
        }
        return highVar;
    }

    private DecompInterface setUpDecompiler() {
        DecompInterface decomplib = new DecompInterface();
        DecompileOptions options = new DecompileOptions();
        OptionsService service = (OptionsService)this.tool.getService(OptionsService.class);
        if (service != null) {
            ToolOptions opt = service.getOptions("Decompiler");
            options.grabFromToolAndProgram(null, opt, this.currentProgram);
        }
        decomplib.setOptions(options);
        decomplib.toggleCCode(true);
        decomplib.toggleSyntaxTree(true);
        decomplib.setSimplificationStyle("decompile");
        return decomplib;
    }

    public DecompileResults decompileFunction(Function f, DecompInterface decomplib) {
        DecompileResults decompRes = decomplib.decompileFunction(f, decomplib.getOptions().getDefaultTimeout(), this.monitor);
        return decompRes;
    }

    private Structure createStructure(HighVariable var, Function f, boolean isThisParam) {
        StructureDataType structDT = null;
        DataType varDT = var.getDataType();
        if (varDT instanceof Structure) {
            structDT = (StructureDataType)varDT;
        } else if (varDT instanceof Pointer) {
            DataType dt = ((Pointer)varDT).getDataType();
            while (dt instanceof Pointer) {
                dt = ((Pointer)dt).getDataType();
            }
            if (dt instanceof Structure) {
                structDT = (Structure)dt;
            }
        }
        if (structDT == null) {
            structDT = this.createNewStruct(var, (int)this.maxOffset, f, isThisParam);
        } else {
            int len = structDT.isNotYetDefined() ? 0 : structDT.getLength();
            if (this.maxOffset > (long)len) {
                structDT.growStructure((int)this.maxOffset - len);
            }
        }
        return structDT;
    }

    private void populateStructure(Structure structDT) {
        for (Long key : this.offsetToDataTypeMap.keySet()) {
            DataType valDT = this.offsetToDataTypeMap.get(key);
            if (key.intValue() < 0 || structDT.getLength() < key.intValue() + valDT.getLength()) continue;
            try {
                DataTypeComponent existing = structDT.getDataTypeAt(key.intValue());
                String name = null;
                String comment = null;
                if (existing != null) {
                    name = existing.getFieldName();
                    comment = existing.getComment();
                }
                structDT.replaceAtOffset(key.intValue(), valDT, valDT.getLength(), name, comment);
            }
            catch (IllegalArgumentException e) {
                Msg.debug((Object)((Object)this), (Object)"Unexpected error changing structure offset", (Throwable)e);
            }
        }
    }

    private Structure createNewStruct(HighVariable var, int size, Function f, boolean isThisParam) {
        if (isThisParam) {
            Namespace rootNamespace = this.currentProgram.getGlobalNamespace();
            Namespace newNamespace = this.createUniqueClassName(rootNamespace);
            RenameLabelCmd command = new RenameLabelCmd(f.getEntryPoint(), f.getName(), f.getName(), rootNamespace, newNamespace, SourceType.USER_DEFINED);
            if (!command.applyTo((DomainObject)this.currentProgram)) {
                return null;
            }
            Structure structDT = VariableUtilities.findOrCreateClassStruct((Function)f);
            int len = structDT.isNotYetDefined() ? 0 : structDT.getLength();
            if (len < size) {
                structDT.growStructure(size - len);
            }
            return structDT;
        }
        String structName = this.createUniqueStructName(var, DEFAULT_CATEGORY, DEFAULT_BASENAME);
        StructureDataType dt = new StructureDataType(new CategoryPath(DEFAULT_CATEGORY), structName, size);
        return dt;
    }

    private Namespace createUniqueClassName(Namespace rootNamespace) {
        SymbolTable symbolTable = this.currentProgram.getSymbolTable();
        String newClassBase = "AutoClass";
        Object newClassName = "";
        for (int i = 1; i < 1000 && !symbolTable.getSymbols((String)(newClassName = newClassBase + Integer.toString(i)), rootNamespace).isEmpty(); ++i) {
        }
        GhidraClass newClass = null;
        try {
            newClass = symbolTable.createClass(rootNamespace, (String)newClassName, SourceType.USER_DEFINED);
        }
        catch (DuplicateNameException e) {
            e.printStackTrace();
        }
        catch (InvalidInputException e) {
            e.printStackTrace();
        }
        return newClass;
    }

    private String createUniqueStructName(HighVariable var, String category, String base) {
        return this.currentProgram.getDataTypeManager().getUniqueName(new CategoryPath(category), base);
    }

    private boolean sanityCheck(long offset) {
        if (offset < 0L) {
            return false;
        }
        return offset <= 4096L;
    }

    private void fillOutStructureDef(HighVariable var) {
        Varnode startVN = var.getRepresentative();
        ArrayList<PointerRef> todoList = new ArrayList<PointerRef>();
        HashSet<Varnode> doneList = new HashSet<Varnode>();
        todoList.add(new PointerRef(startVN, 0L));
        while (!todoList.isEmpty()) {
            Varnode[] instances;
            PointerRef currentRef = (PointerRef)todoList.remove(0);
            if (currentRef.varnode == null) continue;
            for (Varnode iVn : instances = currentRef.varnode.getHigh().getInstances()) {
                Iterator descendants = iVn.getDescendants();
                while (descendants.hasNext()) {
                    PcodeOp pcodeOp = (PcodeOp)descendants.next();
                    Varnode output = pcodeOp.getOutput();
                    Varnode[] inputs = pcodeOp.getInputs();
                    switch (pcodeOp.getOpcode()) {
                        case 19: 
                        case 20: {
                            if (!inputs[1].isConstant()) break;
                            long value = this.getSigned(inputs[1]);
                            long newOff = currentRef.offset + (pcodeOp.getOpcode() == 19 ? value : -value);
                            if (!this.sanityCheck(newOff)) break;
                            this.putOnList(output, newOff, todoList, doneList);
                            this.maxOffset = this.computeMax(this.maxOffset, newOff, 0);
                            break;
                        }
                        case 65: {
                            long newOff;
                            if (!inputs[1].isConstant() || !inputs[2].isConstant() || !this.sanityCheck(newOff = currentRef.offset + this.getSigned(inputs[1]) * inputs[2].getOffset())) break;
                            this.putOnList(output, newOff, todoList, doneList);
                            this.maxOffset = this.computeMax(this.maxOffset, newOff, 0);
                            break;
                        }
                        case 66: {
                            long subOff;
                            if (!inputs[1].isConstant() || !this.sanityCheck(subOff = currentRef.offset + this.getSigned(inputs[1]))) break;
                            this.putOnList(output, subOff, todoList, doneList);
                            this.maxOffset = this.computeMax(this.maxOffset, subOff, 0);
                            break;
                        }
                        case 67: {
                            this.putOnList(output, currentRef.offset, todoList, doneList);
                            break;
                        }
                        case 2: {
                            DataType outDt = output.getHigh().getDataType();
                            if (outDt != null) {
                                this.offsetToDataTypeMap.put(currentRef.offset, outDt);
                            }
                            this.maxOffset = this.computeMax(this.maxOffset, currentRef.offset, output.getSize());
                            break;
                        }
                        case 3: {
                            if (pcodeOp.getSlot(iVn) != 1) break;
                            DataType outDt = inputs[2].getHigh().getDataType();
                            int outLen = 1;
                            if (outDt != null) {
                                this.offsetToDataTypeMap.put(currentRef.offset, outDt);
                                outLen = outDt.getLength();
                            }
                            this.maxOffset = this.computeMax(this.maxOffset, currentRef.offset, outLen);
                            break;
                        }
                        case 64: {
                            this.putOnList(output, currentRef.offset, todoList, doneList);
                            break;
                        }
                        case 60: {
                            this.putOnList(output, currentRef.offset, todoList, doneList);
                            break;
                        }
                        case 1: {
                            this.putOnList(output, currentRef.offset, todoList, doneList);
                            break;
                        }
                        case 7: {
                            int slot;
                            if (currentRef.offset != 0L || (slot = pcodeOp.getSlot(iVn)) <= 0 || slot >= pcodeOp.getNumInputs()) break;
                            this.putOnCallParamList(pcodeOp.getInput(0).getAddress(), slot - 1);
                        }
                    }
                }
            }
        }
    }

    private void putOnCallParamList(Address address, int j) {
        this.addressToCallInputMap.put(address, j);
    }

    private long computeMax(long max, long newOff, int length) {
        if (max < newOff + (long)length) {
            max = newOff + (long)length;
        }
        return max;
    }

    private long getSigned(Varnode varnode) {
        long mask = 128L << (varnode.getSize() - 1) * 8;
        long value = varnode.getOffset();
        if ((value & mask) != 0L) {
            value |= -1L << (varnode.getSize() - 1) * 8;
        }
        return value;
    }

    private void putOnList(Varnode output, long offset, ArrayList<PointerRef> todoList, HashSet<Varnode> doneList) {
        if (doneList.contains(output)) {
            return;
        }
        todoList.add(new PointerRef(output, offset));
        doneList.add(output);
    }

    private static class PointerRef {
        Varnode varnode;
        long offset;

        public PointerRef(Varnode ref, long off) {
            this.varnode = ref;
            this.offset = off;
        }
    }
}

