/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler.component;

import docking.widgets.SearchLocation;
import docking.widgets.fieldpanel.Layout;
import docking.widgets.fieldpanel.LayoutModel;
import docking.widgets.fieldpanel.field.AttributedString;
import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.listener.LayoutModelListener;
import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.fieldpanel.support.HighlightFactory;
import docking.widgets.fieldpanel.support.RowColLocation;
import docking.widgets.fieldpanel.support.SingleRowLayout;
import ghidra.app.decompiler.ClangBreak;
import ghidra.app.decompiler.ClangCommentToken;
import ghidra.app.decompiler.ClangFunction;
import ghidra.app.decompiler.ClangLine;
import ghidra.app.decompiler.ClangNode;
import ghidra.app.decompiler.ClangSyntaxToken;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.ClangTokenGroup;
import ghidra.app.decompiler.DecompileOptions;
import ghidra.app.decompiler.PrettyPrinter;
import ghidra.app.decompiler.component.ClangFieldElement;
import ghidra.app.decompiler.component.ClangTextField;
import ghidra.app.decompiler.component.DecompilerPanel;
import ghidra.app.plugin.core.decompile.actions.FieldBasedSearchLocation;
import ghidra.app.util.viewer.field.CommentUtils;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.HighFunction;
import ghidra.util.Msg;
import ghidra.util.StringUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JComponent;

public class ClangLayoutController
implements LayoutModel,
LayoutModelListener {
    private final ClangFieldElement EMPTY_LINE_NUMBER_SPACER;
    private int maxWidth;
    private int lineNumberFieldWidth;
    private int indentWidth;
    private DecompileOptions options;
    private DecompilerPanel decompilerPanel;
    private ClangTokenGroup docroot;
    private Field[] fieldList;
    private FontMetrics metrics;
    private HighlightFactory hlFactory;
    private ArrayList<LayoutModelListener> listeners;
    private Color[] syntax_color;
    private BigInteger numIndexes = BigInteger.ZERO;
    private ArrayList<ClangLine> lines = new ArrayList();
    private boolean showLineNumbers = true;

    private ClangFieldElement createEmptyLineNumberSpacer() {
        ClangToken lineNumberToken = ClangToken.buildSpacer(null, 0, "");
        AttributedString as = new AttributedString("", Color.WHITE, this.metrics);
        return new ClangFieldElement(lineNumberToken, as, 0);
    }

    public ClangLayoutController(DecompileOptions opt, DecompilerPanel decompilerPanel, FontMetrics met, HighlightFactory hlFactory) {
        this.options = opt;
        this.decompilerPanel = decompilerPanel;
        this.syntax_color = new Color[9];
        this.metrics = met;
        this.hlFactory = hlFactory;
        this.EMPTY_LINE_NUMBER_SPACER = this.createEmptyLineNumberSpacer();
        this.listeners = new ArrayList();
        this.buildLayouts(null, null, null, false);
    }

    public ArrayList<ClangLine> getLines() {
        return this.lines;
    }

    public boolean isUniform() {
        return false;
    }

    public Dimension getPreferredViewSize() {
        return new Dimension(this.maxWidth + this.lineNumberFieldWidth, 500);
    }

    public BigInteger getNumIndexes() {
        return this.numIndexes;
    }

    public Layout getLayout(BigInteger index) {
        if (index.compareTo(this.numIndexes) >= 0) {
            return null;
        }
        return new SingleRowLayout(this.fieldList[index.intValue()]);
    }

    public void addLayoutModelListener(LayoutModelListener listener) {
        this.listeners.add(listener);
    }

    public void removeLayoutModelListener(LayoutModelListener listener) {
        this.listeners.remove(listener);
    }

    public void modelSizeChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).modelSizeChanged();
        }
    }

    public void modelChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).modelSizeChanged();
        }
    }

    public void dataChanged(BigInteger start, BigInteger end) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).dataChanged(start, end);
        }
    }

    public void layoutChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).dataChanged(BigInteger.ZERO, this.numIndexes);
        }
    }

    public BigInteger getIndexAfter(BigInteger index) {
        BigInteger nextIndex = index.add(BigInteger.ONE);
        if (nextIndex.compareTo(this.numIndexes) >= 0) {
            return null;
        }
        return nextIndex;
    }

    public BigInteger getIndexBefore(BigInteger index) {
        if (index.compareTo(BigInteger.ZERO) <= 0) {
            return null;
        }
        return index.subtract(BigInteger.ONE);
    }

    public int getIndexBefore(int index) {
        return index - 1;
    }

    public ClangTokenGroup getRoot() {
        return this.docroot;
    }

    Field[] getFields() {
        return this.fieldList;
    }

    private ClangTextField createTextFieldForLine(ClangLine line, int lineCount, boolean paintLineNumbers) {
        ArrayList<ClangToken> tokens = line.getAllTokens();
        ClangFieldElement lineNumberFieldElement = this.createLineNumberFieldElement(line, lineCount, paintLineNumbers);
        if (this.isComment(tokens)) {
            return this.createCommentField(tokens, lineNumberFieldElement, line.getIndent());
        }
        FieldElement[] elements = this.createFieldElementsForLine(tokens);
        int indent = line.getIndent() * this.indentWidth;
        int lineNumberWidth = lineNumberFieldElement.getStringWidth();
        int updatedMaxWidth = this.maxWidth + lineNumberWidth;
        return new ClangTextField(tokens, elements, (FieldElement)lineNumberFieldElement, indent, updatedMaxWidth, this.hlFactory);
    }

    private ClangTextField createCommentField(List<ClangToken> tokens, ClangFieldElement lineNumberFieldElement, int indentCount) {
        StringBuilder buffy = new StringBuilder();
        for (ClangToken t : tokens) {
            buffy.append(t.getText());
        }
        String text = buffy.toString();
        ClangCommentToken token = this.getFirstCommentToken(tokens);
        Color color = this.syntax_color[token.getSyntaxType()];
        AttributedString prototype = new AttributedString("prototype", color, this.metrics);
        Program program = this.decompilerPanel.getProgram();
        FieldElement element = CommentUtils.parseTextForAnnotations((String)text, (Program)program, (AttributedString)prototype, (int)0);
        FieldElement[] elements = new FieldElement[]{element};
        ClangCommentToken newCommentToken = ClangCommentToken.derive(token, text);
        List<ClangToken> newTokens = Arrays.asList(newCommentToken);
        int indent = indentCount * this.indentWidth;
        int lineNumberWidth = lineNumberFieldElement.getStringWidth();
        int updatedMaxWidth = this.maxWidth + lineNumberWidth;
        return new ClangTextField(newTokens, elements, (FieldElement)lineNumberFieldElement, indent, updatedMaxWidth, this.hlFactory);
    }

    private FieldElement[] createFieldElementsForLine(List<ClangToken> tokens) {
        ClangFieldElement[] elements = new ClangFieldElement[tokens.size()];
        int columnPosition = 0;
        for (int i = 0; i < tokens.size(); ++i) {
            ClangToken token = tokens.get(i);
            AttributedString as = new AttributedString(token.getText(), this.syntax_color[token.getSyntaxType()], this.metrics);
            elements[i] = new ClangFieldElement(token, as, columnPosition);
            columnPosition += as.length();
        }
        return elements;
    }

    private ClangCommentToken getFirstCommentToken(List<ClangToken> tokens) {
        for (ClangToken t : tokens) {
            if (!(t instanceof ClangCommentToken)) continue;
            return (ClangCommentToken)t;
        }
        return null;
    }

    private boolean isComment(List<ClangToken> tokens) {
        for (ClangToken t : tokens) {
            if (!(t instanceof ClangCommentToken)) continue;
            return true;
        }
        return false;
    }

    private ClangFieldElement createLineNumberFieldElement(ClangLine line, int lineCount, boolean paintLineNumbers) {
        if (paintLineNumbers) {
            return new LineNumberFieldElement(line.getLineNumber(), lineCount, this.metrics);
        }
        return this.EMPTY_LINE_NUMBER_SPACER;
    }

    private void updateOptions() {
        this.syntax_color[0] = this.options.getKeywordColor();
        this.syntax_color[1] = this.options.getTypeColor();
        this.syntax_color[2] = this.options.getFunctionColor();
        this.syntax_color[3] = this.options.getCommentColor();
        this.syntax_color[4] = this.options.getVariableColor();
        this.syntax_color[5] = this.options.getConstantColor();
        this.syntax_color[6] = this.options.getParameterColor();
        this.syntax_color[7] = this.options.getGlobalColor();
        this.syntax_color[8] = this.options.getDefaultColor();
        Font font = this.options.getDefaultFont();
        this.metrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        this.indentWidth = this.metrics.stringWidth(" ");
        this.maxWidth = this.indentWidth * this.options.getMaxWidth();
        this.lineNumberFieldWidth = 0;
        this.showLineNumbers = this.options.isDisplayLineNumbers();
    }

    private void buildLayoutInternal(ghidra.program.model.listing.Function function, boolean display, boolean isError) {
        this.updateOptions();
        PrettyPrinter printer = new PrettyPrinter(function, this.docroot);
        this.lines = printer.getLines();
        int lineCount = this.lines.size();
        this.fieldList = new Field[lineCount];
        this.numIndexes = BigInteger.valueOf(lineCount);
        this.lineNumberFieldWidth = 0;
        if (this.showLineNumbers && !isError) {
            this.lineNumberFieldWidth = LineNumberFieldElement.getFieldWidth(this.metrics, lineCount);
        }
        for (int i = 0; i < lineCount; ++i) {
            ClangLine oneLine = this.lines.get(i);
            this.fieldList[i] = this.createTextFieldForLine(oneLine, lineCount, this.showLineNumbers);
        }
        if (display) {
            this.modelChanged();
        }
    }

    private void splitToMaxWidthLines(ArrayList<String> res, String line) {
        int maxchar = this.maxWidth == 0 || this.indentWidth == 0 ? 40 : this.maxWidth / this.indentWidth;
        String[] toklist = line.split("[ \t]+");
        StringBuffer buf = new StringBuffer();
        int cursize = 0;
        boolean atleastone = false;
        int i = 0;
        while (i < toklist.length) {
            if (!atleastone) {
                buf.append(' ');
                buf.append(toklist[i]);
                atleastone = true;
                cursize += toklist[i].length() + 1;
                ++i;
                continue;
            }
            if (cursize + toklist[i].length() >= maxchar) {
                String finishLine = buf.toString();
                res.add(finishLine);
                cursize = 5;
                atleastone = false;
                buf = new StringBuffer();
                buf.append("     ");
                continue;
            }
            buf.append(' ');
            buf.append(toklist[i]);
            cursize += toklist[i].length() + 1;
            ++i;
        }
        String finalLine = buf.toString();
        if (finalLine.length() != 0) {
            res.add(finalLine);
        }
    }

    private boolean addErrorLayout(String errmsg) {
        if (this.docroot == null) {
            this.docroot = new ClangFunction(null, null);
            if (errmsg == null) {
                errmsg = "No function";
            }
        }
        if (errmsg == null) {
            return false;
        }
        String[] errlines_init = errmsg.split("[\n\r]+");
        ArrayList<String> errlines = new ArrayList<String>();
        for (String element : errlines_init) {
            this.splitToMaxWidthLines(errlines, element);
        }
        for (int i = 0; i < errlines.size(); ++i) {
            ClangTokenGroup line = new ClangTokenGroup(this.docroot);
            ClangBreak lineBreak = new ClangBreak((ClangNode)line, 1);
            ClangSyntaxToken message = new ClangSyntaxToken(line, errlines.get(i), "comment");
            line.AddTokenGroup(lineBreak);
            line.AddTokenGroup(message);
            this.docroot.AddTokenGroup(line);
        }
        return true;
    }

    public void buildLayouts(ghidra.program.model.listing.Function function, ClangTokenGroup doc, String errmsg, boolean display) {
        this.docroot = doc;
        boolean isError = this.addErrorLayout(errmsg);
        this.buildLayoutInternal(function, display, isError);
    }

    public HighFunction getHighFunction(int i) {
        int numfunc = this.docroot.numChildren();
        if (i < 0 || i >= numfunc) {
            return null;
        }
        if (this.docroot.Child(i) instanceof ClangFunction) {
            return ((ClangFunction)this.docroot.Child(i)).getHighFunction();
        }
        return null;
    }

    private SearchLocation findNextTokenGoingForward(Function<String, SearchMatch> matcher, String searchString, FieldLocation currentLocation) {
        int row;
        for (int i = row = currentLocation.getIndex().intValue(); i < this.fieldList.length; ++i) {
            ClangTextField field;
            String textLine = this.getTextLineFromOffset((FieldLocation)(i == row ? currentLocation : null), field = (ClangTextField)this.fieldList[i], true);
            SearchMatch match = matcher.apply(textLine);
            if (match == SearchMatch.NO_MATCH) continue;
            if (i == row) {
                String fullLine = field.getText();
                match.start += fullLine.length() - textLine.length();
            }
            FieldNumberColumnPair pair = this.getFieldIndexFromOffset(match.start, field);
            FieldLocation fieldLocation = new FieldLocation(i, pair.getFieldNumber(), 0, pair.getColumn());
            return new FieldBasedSearchLocation(fieldLocation, match.start, match.end - 1, searchString, true);
        }
        return null;
    }

    private SearchLocation findNextTokenGoingBackward(Function<String, SearchMatch> matcher, String searchString, FieldLocation currentLocation) {
        int row;
        for (int i = row = currentLocation.getIndex().intValue(); i >= 0; --i) {
            ClangTextField field;
            String textLine = this.getTextLineFromOffset((FieldLocation)(i == row ? currentLocation : null), field = (ClangTextField)this.fieldList[i], false);
            SearchMatch match = matcher.apply(textLine);
            if (match == SearchMatch.NO_MATCH) continue;
            FieldNumberColumnPair pair = this.getFieldIndexFromOffset(match.start, field);
            FieldLocation fieldLocation = new FieldLocation(i, pair.getFieldNumber(), 0, pair.getColumn());
            return new FieldBasedSearchLocation(fieldLocation, match.start, match.end - 1, searchString, false);
        }
        return null;
    }

    public SearchLocation findNextTokenForSearchRegex(String searchString, FieldLocation currentLocation, boolean forwardSearch) {
        Pattern pattern = null;
        try {
            pattern = Pattern.compile(searchString, 34);
        }
        catch (PatternSyntaxException e) {
            Msg.showError((Object)this, (Component)this.decompilerPanel, (String)"Regular Expression Syntax Error", (Object)e.getMessage());
            return null;
        }
        Pattern finalPattern = pattern;
        if (forwardSearch) {
            Function<String, SearchMatch> function = textLine -> {
                Matcher matcher = finalPattern.matcher((CharSequence)textLine);
                if (matcher.find()) {
                    int start = matcher.start();
                    int end = matcher.end();
                    return new SearchMatch(start, end);
                }
                return SearchMatch.NO_MATCH;
            };
            return this.findNextTokenGoingForward(function, searchString, currentLocation);
        }
        Function<String, SearchMatch> reverse = textLine -> {
            Matcher matcher = finalPattern.matcher((CharSequence)textLine);
            if (!matcher.find()) {
                return SearchMatch.NO_MATCH;
            }
            int start = matcher.start();
            int end = matcher.end();
            while (matcher.find()) {
                start = matcher.start();
                end = matcher.end();
            }
            return new SearchMatch(start, end);
        };
        return this.findNextTokenGoingBackward(reverse, searchString, currentLocation);
    }

    public SearchLocation findNextTokenForSearch(String searchString, FieldLocation currentLocation, boolean forwardSearch) {
        if (forwardSearch) {
            Function<String, SearchMatch> function = textLine -> {
                int index = StringUtilities.indexOfIgnoreCase((String)textLine, (String)searchString);
                if (index == -1) {
                    return SearchMatch.NO_MATCH;
                }
                return new SearchMatch(index, index + searchString.length());
            };
            return this.findNextTokenGoingForward(function, searchString, currentLocation);
        }
        Function<String, SearchMatch> function = textLine -> {
            int index = StringUtilities.lastIndexOfIgnoreCase((String)textLine, (String)searchString);
            if (index == -1) {
                return SearchMatch.NO_MATCH;
            }
            return new SearchMatch(index, index + searchString.length());
        };
        return this.findNextTokenGoingBackward(function, searchString, currentLocation);
    }

    private String getTextLineFromOffset(FieldLocation location, ClangTextField textField, boolean forwardSearch) {
        if (location == null) {
            return textField.getText();
        }
        if (textField.getText().isEmpty()) {
            return "";
        }
        String partialText = textField.getText();
        if (forwardSearch) {
            if (location.getCol() + 1 >= partialText.length()) {
                return "";
            }
            return partialText.substring(location.getCol() + 1);
        }
        return partialText.substring(0, location.getCol());
    }

    private FieldNumberColumnPair getFieldIndexFromOffset(int screenOffset, ClangTextField textField) {
        RowColLocation rowColLocation = textField.textOffsetToScreenLocation(screenOffset);
        return new FieldNumberColumnPair(0, rowColLocation.col());
    }

    ClangToken getTokenForLocation(FieldLocation fieldLocation) {
        int row = fieldLocation.getIndex().intValue();
        ClangTextField field = (ClangTextField)this.fieldList[row];
        return field.getToken(fieldLocation);
    }

    public void locationChanged(FieldLocation loc, Field field, Color locationColor, Color parenColor) {
    }

    public boolean changePending() {
        return false;
    }

    public void flushChanges() {
    }

    private class FieldNumberColumnPair {
        private final int fieldNumber;
        private final int column;

        FieldNumberColumnPair(int fieldNumber, int column) {
            this.fieldNumber = fieldNumber;
            this.column = column;
        }

        int getFieldNumber() {
            return this.fieldNumber;
        }

        int getColumn() {
            return this.column;
        }
    }

    private static class LineNumberFieldElement
    extends ClangFieldElement {
        private static final Color FOREGROUND_COLOR = new Color(125, 125, 125);
        private int uniformWidth;

        private LineNumberFieldElement(int lineNumber, int lineCount, FontMetrics fontMetrics) {
            super(ClangToken.buildSpacer(null, 0, ""), LineNumberFieldElement.createAttributedLineNumberString(lineNumber, lineCount, FOREGROUND_COLOR, fontMetrics), 0);
            this.uniformWidth = this.calculateUniformStringWidth(fontMetrics);
        }

        private static String createLineNumberString(int lineNumber, int lineCount) {
            String lineCountString = Integer.toString(lineCount);
            int maxNumberOfDigits = lineCountString.length();
            String lineNumberString = Integer.toString(lineNumber);
            int lineNumberLength = lineNumberString.length();
            int padLength = maxNumberOfDigits - lineNumberLength;
            StringBuffer buffy = new StringBuffer();
            for (int i = 0; i < padLength; ++i) {
                buffy.append(' ');
            }
            buffy.append(lineNumberString).append(' ');
            return buffy.toString();
        }

        private static AttributedString createAttributedLineNumberString(int lineNumber, int lineCount, Color foregroundColor, FontMetrics fontMetrics) {
            return new AttributedString(LineNumberFieldElement.createLineNumberString(lineNumber, lineCount), foregroundColor, fontMetrics);
        }

        static int getFieldWidth(FontMetrics fontMetrics, int lineCnt) {
            int largestCharacterWidth = LineNumberFieldElement.getLargestCharacterWidth(fontMetrics);
            int numberOfCharacters = LineNumberFieldElement.createLineNumberString(0, lineCnt).length();
            return numberOfCharacters * largestCharacterWidth;
        }

        private int calculateUniformStringWidth(FontMetrics fontMetrics) {
            int largestCharacterWidth = LineNumberFieldElement.getLargestCharacterWidth(fontMetrics);
            int numberOfCharacters = this.getText().length();
            return numberOfCharacters * largestCharacterWidth;
        }

        private static int getLargestCharacterWidth(FontMetrics fontMetrics) {
            return fontMetrics.stringWidth("9");
        }

        @Override
        public void paint(JComponent c, Graphics g, int x, int y) {
            super.paint(c, g, 0, 0);
            Color color = this.getColor(0);
            g.setColor(color);
            FontMetrics fontMetrics = g.getFontMetrics();
            int topX = fontMetrics.getMaxAscent() + 1;
            int maxDescent = fontMetrics.getMaxDescent();
            int baselineX = maxDescent + 1;
            g.drawLine(this.uniformWidth, -topX, this.uniformWidth, baselineX);
        }

        public int getStringWidth() {
            return this.uniformWidth + 3;
        }
    }

    private static class SearchMatch {
        private static SearchMatch NO_MATCH = new SearchMatch(-1, -1);
        private int start;
        private int end;

        SearchMatch(int start, int end) {
            this.start = start;
            this.end = end;
        }
    }
}

