/*
 * Decompiled with CFR 0.152.
 */
package ghidra.javaclass.format.constantpool;

import ghidra.app.util.bin.BinaryReader;
import ghidra.javaclass.format.constantpool.AbstractConstantPoolInfoJava;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ConstantPoolInvokeDynamicInfo
extends AbstractConstantPoolInfoJava {
    private short bootstrapMethodAttrIndex;
    private short nameAndTypeIndex;

    public ConstantPoolInvokeDynamicInfo(BinaryReader reader) throws IOException {
        super(reader);
        this.bootstrapMethodAttrIndex = reader.readNextShort();
        this.nameAndTypeIndex = reader.readNextShort();
    }

    public short getBootstrapMethodAttrIndex() {
        return this.bootstrapMethodAttrIndex;
    }

    public short getNameAndTypeIndex() {
        return this.nameAndTypeIndex;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        String name = "CONSTANT_InvokeDynamic_info";
        StructureDataType structure = new StructureDataType(name, 0);
        structure.add(BYTE, "tag", null);
        structure.add(WORD, "bootstrap_method_attr_index", null);
        structure.add(WORD, "name_and_type_index", null);
        return structure;
    }
}

