/*
 * Decompiled with CFR 0.152.
 */
package ghidra.bitpatterns.gui;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.widgets.textfield.IntegerTextField;
import ghidra.bitpatterns.gui.InputDialogComponentProvider;
import ghidra.util.HelpLocation;
import ghidra.util.layout.PairLayout;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class BitsInputDialogComponentProvider
extends InputDialogComponentProvider {
    private static final String TOTAL_BITS_LABEL = "Total Bits ";
    private static final Long DEFAULT_TOTAL_BITS = 32L;
    private static final String POST_BITS_LABEL = "Post Bits ";
    private static final Long DEFAULT_POST_BITS = 16L;
    private IntegerTextField totalBitsBox;
    private IntegerTextField preBitsBox;

    public BitsInputDialogComponentProvider(String title) {
        super(title);
        JPanel panel = this.createPanel();
        this.addWorkPanel(panel);
        this.addOKButton();
        this.addCancelButton();
        this.setDefaultButton(this.okButton);
        DockingWindowManager.showDialog(null, (DialogComponentProvider)this);
        HelpLocation helpLocation = new HelpLocation("FunctionBitPatternsExplorerPlugin", "Pattern_Clipboard_Tab");
        this.setHelpLocation(helpLocation);
    }

    @Override
    protected JPanel createPanel() {
        JPanel mainPanel = new JPanel();
        PairLayout pairLayout = new PairLayout();
        mainPanel.setLayout((LayoutManager)pairLayout);
        mainPanel.add(new JLabel(TOTAL_BITS_LABEL));
        this.totalBitsBox = new IntegerTextField();
        this.totalBitsBox.setValue(DEFAULT_TOTAL_BITS.longValue());
        mainPanel.add(this.totalBitsBox.getComponent());
        mainPanel.add(new JLabel(POST_BITS_LABEL));
        this.preBitsBox = new IntegerTextField();
        this.preBitsBox.setValue(DEFAULT_POST_BITS.longValue());
        mainPanel.add(this.preBitsBox.getComponent());
        return mainPanel;
    }

    public int getTotalBits() {
        return this.totalBitsBox.getIntValue();
    }

    public int getPostBits() {
        return this.preBitsBox.getIntValue();
    }
}

