/*
 * Decompiled with CFR 0.152.
 */
package ghidra.launch;

import ghidra.launch.JavaFinder;
import ghidra.launch.JavaVersion;
import ghidra.launch.LaunchProperties;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.text.ParseException;
import java.util.Properties;

public class JavaConfig {
    private static final String LAUNCH_PROPERTIES_NAME = "launch.properties";
    private static final String JAVA_HOME_SAVE_NAME = "java_home.save";
    private LaunchProperties launchProperties;
    private File javaHomeSaveFile;
    private String applicationName;
    private String applicationVersion;
    private int minSupportedJava;
    private int maxSupportedJava;
    private String compilerComplianceLevel;

    public JavaConfig(File installDir) throws FileNotFoundException, IOException, ParseException {
        this.initApplicationProperties(installDir);
        this.initLaunchProperties(installDir);
        this.initJavaHomeSaveFile(installDir);
    }

    public LaunchProperties getLaunchProperties() {
        return this.launchProperties;
    }

    public int getMinSupportedJava() {
        return this.minSupportedJava;
    }

    public int getMaxSupportedJava() {
        return this.maxSupportedJava;
    }

    public String getCompilerComplianceLevel() {
        return this.compilerComplianceLevel;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File getSavedJavaHome() throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(this.javaHomeSaveFile));){
            String line = reader.readLine().trim();
            if (line == null) return null;
            if (line.isEmpty()) return null;
            File file = new File(line);
            return file;
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public File saveJavaHome(File javaHomeDir) throws IOException {
        if (!this.javaHomeSaveFile.getParentFile().exists() && !this.javaHomeSaveFile.getParentFile().mkdirs()) {
            throw new IOException("Failed to create directory: " + this.javaHomeSaveFile.getParentFile());
        }
        try (PrintWriter writer = new PrintWriter(new FileWriter(this.javaHomeSaveFile));){
            writer.println(javaHomeDir);
        }
        return this.javaHomeSaveFile;
    }

    public boolean isSupportedJavaHomeDir(File dir, JavaFinder.JavaFilter javaFilter) {
        try {
            return this.isJavaVersionSupported(this.getJavaVersion(dir, javaFilter));
        }
        catch (IOException | ParseException e) {
            return false;
        }
    }

    public boolean isJavaVersionSupported(JavaVersion javaVersion) {
        int major = javaVersion.getMajor();
        return major >= this.minSupportedJava && (this.maxSupportedJava == 0 || major <= this.maxSupportedJava);
    }

    public JavaVersion getJavaVersion(File javaHomeDir, JavaFinder.JavaFilter javaFilter) throws FileNotFoundException, IOException, ParseException {
        if (javaHomeDir == null) {
            throw new FileNotFoundException("Directory not specified");
        }
        if (!javaHomeDir.isDirectory()) {
            throw new FileNotFoundException("Not a directory");
        }
        File binDir = new File(javaHomeDir, "bin");
        if (!binDir.isDirectory()) {
            throw new FileNotFoundException("Missing bin directory");
        }
        File javaExecutable = null;
        File javacExecutable = null;
        for (File f : binDir.listFiles()) {
            if (f.getName().equals("java") || f.getName().equals("java.exe")) {
                javaExecutable = f;
            }
            if (!f.getName().equals("javac") && !f.getName().equals("javac.exe")) continue;
            javacExecutable = f;
        }
        if (javaExecutable == null) {
            throw new FileNotFoundException("Missing java executable");
        }
        if (javaFilter.equals((Object)JavaFinder.JavaFilter.JDK_ONLY) && javacExecutable == null) {
            throw new FileNotFoundException("JDK is missing javac executable");
        }
        if (javaFilter.equals((Object)JavaFinder.JavaFilter.JRE_ONLY) && javacExecutable != null) {
            throw new FileNotFoundException("JRE should not have javac executable");
        }
        return this.runAndGetJavaVersion(javaExecutable);
    }

    private JavaVersion runAndGetJavaVersion(File javaExecutable) throws ParseException, IOException {
        Runtime rt = Runtime.getRuntime();
        Process proc = rt.exec(new String[]{javaExecutable.getAbsolutePath(), "-version"});
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getErrorStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith("Picked up")) continue;
                String[] parts = line.split("\\s");
                if (parts.length < 3) {
                    throw new ParseException("Failed to parse version: " + line, 0);
                }
                JavaVersion javaVersion = new JavaVersion(parts[2]);
                return javaVersion;
            }
            throw new ParseException("Failed to find Java version", 0);
        }
    }

    private void initApplicationProperties(File installDir) throws FileNotFoundException, IOException, ParseException {
        File applicationPropertiesFile = new File(installDir, "Ghidra/application.properties");
        if (!applicationPropertiesFile.isFile()) {
            throw new FileNotFoundException("Application properties file does not exist: " + applicationPropertiesFile);
        }
        Properties applicationProperties = new Properties();
        try (FileInputStream fin = new FileInputStream(applicationPropertiesFile);){
            applicationProperties.load(fin);
        }
        this.applicationName = this.getDefinedProperty(applicationProperties, "application.name");
        this.applicationVersion = this.getDefinedProperty(applicationProperties, "application.version");
        this.compilerComplianceLevel = this.getDefinedProperty(applicationProperties, "application.java.compiler");
        try {
            this.minSupportedJava = Integer.parseInt(this.getDefinedProperty(applicationProperties, "application.java.min"));
        }
        catch (NumberFormatException e) {
            throw new ParseException("Failed to parse application's minimum supported Java major verison", 0);
        }
        String max = applicationProperties.getProperty("application.java.max");
        if (max != null && !max.isEmpty()) {
            try {
                this.maxSupportedJava = Integer.parseInt(max);
            }
            catch (NumberFormatException e) {
                throw new ParseException("Failed to parse application's maximum supported Java major verison", 0);
            }
        } else {
            this.maxSupportedJava = 0;
        }
    }

    private void initLaunchProperties(File installDir) throws FileNotFoundException, IOException, ParseException {
        boolean isDev = new File(installDir, "build.gradle").isFile();
        File launchPropertiesFile = new File(installDir, (isDev ? "Ghidra/RuntimeScripts/Common/" : "") + "support/" + LAUNCH_PROPERTIES_NAME);
        if (!launchPropertiesFile.isFile()) {
            throw new FileNotFoundException("Launch properties file does not exist: " + launchPropertiesFile);
        }
        this.launchProperties = new LaunchProperties(launchPropertiesFile);
    }

    private void initJavaHomeSaveFile(File installDir) throws FileNotFoundException {
        boolean isDev = new File(installDir, "build.gradle").isFile();
        String userHomeDirPath = System.getProperty("user.home");
        if (userHomeDirPath == null || userHomeDirPath.isEmpty()) {
            throw new FileNotFoundException("User home directory is not known.");
        }
        File userHomeDir = new File(userHomeDirPath);
        if (!userHomeDir.isDirectory()) {
            throw new FileNotFoundException("User home directory does not exist: " + userHomeDir);
        }
        String prefix = "." + this.applicationName.replaceAll("\\s", "").toLowerCase();
        String suffix = this.applicationVersion;
        if (isDev) {
            suffix = suffix + "_location_" + installDir.getParentFile().getName();
        }
        File userSettingsDir = new File(userHomeDir, prefix + File.separator + prefix + "-" + suffix);
        this.javaHomeSaveFile = new File(userSettingsDir, JAVA_HOME_SAVE_NAME);
    }

    private String getDefinedProperty(Properties properties, String key) throws ParseException {
        String value = properties.getProperty(key);
        if (value == null || value.isEmpty()) {
            throw new ParseException("Property \"" + key + "\" is not defined.", 0);
        }
        return value;
    }
}

