/*
 * Decompiled with CFR 0.152.
 */
import ghidra.launch.JavaConfig;
import ghidra.launch.JavaFinder;
import ghidra.launch.JavaVersion;
import ghidra.launch.LaunchProperties;
import ghidra.launch.MacJavaFinder;
import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.util.List;
import javax.swing.JFileChooser;

public class LaunchSupport {
    private static final int EXIT_SUCCESS = 0;
    private static final int EXIT_FAILURE = 1;

    public static void main(String[] args) {
        int exitCode = 1;
        if (args.length < 2 || args.length > 4) {
            System.err.println("LaunchSupport expected 2 to 4 arguments but got " + args.length);
            System.exit(exitCode);
        }
        String installDirPath = args[0];
        String mode = args[1];
        boolean ask = false;
        boolean save = false;
        for (int i = 2; i < args.length; ++i) {
            if (args[i].equals("-ask")) {
                ask = true;
                continue;
            }
            if (args[i].equals("-save")) {
                save = true;
                continue;
            }
            System.err.println("LaunchSupport received illegal argument: " + args[i]);
            System.exit(exitCode);
        }
        try {
            File installDir = new File(installDirPath).getCanonicalFile();
            JavaConfig javaConfig = new JavaConfig(installDir);
            JavaFinder javaFinder = JavaFinder.create();
            switch (mode.toLowerCase()) {
                case "-java_home": {
                    exitCode = LaunchSupport.handleJavaHome(javaConfig, javaFinder, JavaFinder.JavaFilter.ANY, ask, save);
                    break;
                }
                case "-jdk_home": {
                    exitCode = LaunchSupport.handleJavaHome(javaConfig, javaFinder, JavaFinder.JavaFilter.JDK_ONLY, ask, save);
                    break;
                }
                case "-vmargs": {
                    exitCode = LaunchSupport.handleVmArgs(javaConfig);
                    break;
                }
                default: {
                    System.err.println("LaunchSupport received illegal argument: " + mode);
                    break;
                }
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        System.exit(exitCode);
    }

    private static int handleJavaHome(JavaConfig javaConfig, JavaFinder javaFinder, JavaFinder.JavaFilter javaFilter, boolean ask, boolean save) throws IOException {
        if (ask) {
            return LaunchSupport.askJavaHome(javaConfig, javaFinder, javaFilter);
        }
        return LaunchSupport.findJavaHome(javaConfig, javaFinder, javaFilter, save);
    }

    private static int findJavaHome(JavaConfig javaConfig, JavaFinder javaFinder, JavaFinder.JavaFilter javaFilter, boolean save) throws IOException {
        LaunchProperties launchProperties = javaConfig.getLaunchProperties();
        File javaHomeDir = launchProperties.getJavaHomeOverride();
        if (javaConfig.isSupportedJavaHomeDir(javaHomeDir, javaFilter)) {
            if (save) {
                javaConfig.saveJavaHome(javaHomeDir);
            }
            System.out.println(javaHomeDir);
            return 0;
        }
        javaHomeDir = javaFinder.findSupportedJavaHomeFromCurrentJavaHome(javaConfig, javaFilter);
        if (javaHomeDir != null) {
            if (save) {
                javaConfig.saveJavaHome(javaHomeDir);
            }
            System.out.println(javaHomeDir);
            return 0;
        }
        javaHomeDir = javaConfig.getSavedJavaHome();
        if (javaConfig.isSupportedJavaHomeDir(javaHomeDir, javaFilter)) {
            System.out.println(javaHomeDir);
            return 0;
        }
        List<File> javaHomeDirs = javaFinder.findSupportedJavaHomeFromInstallations(javaConfig, javaFilter);
        if (!javaHomeDirs.isEmpty()) {
            javaHomeDir = javaHomeDirs.iterator().next();
            if (save) {
                javaConfig.saveJavaHome(javaHomeDir);
            }
            System.out.println(javaHomeDir);
            return 0;
        }
        return 1;
    }

    private static int askJavaHome(JavaConfig javaConfig, JavaFinder javaFinder, JavaFinder.JavaFilter javaFilter) throws IOException {
        int max;
        String javaName = javaFilter.equals((Object)JavaFinder.JavaFilter.JDK_ONLY) ? "JDK" : "Java";
        int min = javaConfig.getMinSupportedJava();
        String javaRange = min == (max = javaConfig.getMaxSupportedJava()) ? min + "" : (max == 0 ? min + "+" : min + "-" + max);
        System.out.println("*******************************************************");
        System.out.println(javaName + " " + javaRange + " could not be found and must be manually chosen!");
        System.out.println("*******************************************************");
        File javaHomeDir = null;
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            boolean supportsDialog = !GraphicsEnvironment.isHeadless() && !(javaFinder instanceof MacJavaFinder);
            System.out.print("Enter path to " + javaName + " home directory");
            System.out.print(supportsDialog ? " (ENTER for dialog): " : ": ");
            String line = in.readLine().trim();
            if (supportsDialog && line.isEmpty()) {
                System.out.println("Opening selection dialog...");
                JFileChooser chooser = new JFileChooser();
                chooser.setFileSelectionMode(1);
                chooser.setDialogTitle("Choose a " + javaName + " home directory");
                if (chooser.showOpenDialog(null) == 0) {
                    javaHomeDir = chooser.getSelectedFile();
                }
            } else {
                if (line.isEmpty()) continue;
                javaHomeDir = new File(line);
            }
            try {
                JavaVersion javaVersion = javaConfig.getJavaVersion(javaHomeDir, javaFilter);
                if (javaConfig.isJavaVersionSupported(javaVersion)) break;
                System.out.println("Java version " + javaVersion + " is outside of supported range: [" + javaRange + "]");
            }
            catch (FileNotFoundException e) {
                System.out.println("Not a valid " + javaName + " home directory. " + e.getMessage() + "!");
            }
            catch (IOException | ParseException e) {
                System.out.println("Failed to verify Java version. " + e.getMessage() + "!");
            }
        }
        File javaHomeSaveFile = javaConfig.saveJavaHome(javaHomeDir);
        System.out.println("Saved changes to " + javaHomeSaveFile);
        return 0;
    }

    private static int handleVmArgs(JavaConfig javaConfig) {
        if (javaConfig.getLaunchProperties() == null) {
            System.out.println("Launch properties file was not specified!");
            return 1;
        }
        System.out.println(javaConfig.getLaunchProperties().getVmArgs());
        return 0;
    }
}

