/*
 * Decompiled with CFR 0.152.
 */
package functioncalls.graph.view;

import com.google.common.base.Function;
import edu.uci.ics.jung.visualization.RenderContext;
import functioncalls.graph.FcgEdge;
import functioncalls.graph.FcgVertex;
import functioncalls.graph.FunctionCallGraph;
import functioncalls.graph.renderer.FcgEdgePaintTransformer;
import functioncalls.graph.renderer.FcgVertexPaintTransformer;
import ghidra.graph.VisualGraph;
import ghidra.graph.viewer.GraphComponent;
import ghidra.graph.viewer.GraphViewer;
import ghidra.graph.viewer.SatelliteGraphViewer;
import ghidra.graph.viewer.VisualGraphViewUpdater;
import ghidra.graph.viewer.layout.VisualGraphLayout;
import java.awt.Color;

public class FcgComponent
extends GraphComponent<FcgVertex, FcgEdge, FunctionCallGraph> {
    private FunctionCallGraph fcGraph;
    private FcgVertexPaintTransformer vertexPaintTransformer = new FcgVertexPaintTransformer(FcgVertex.DEFAULT_VERTEX_SHAPE_COLOR);
    private Color lightGreen = new Color(143, 197, 143);
    private Color lightGray = new Color(233, 233, 233);
    private Color washedOutBlack = new Color(0, 0, 0, 25);
    private FcgEdgePaintTransformer edgePaintTransformer = new FcgEdgePaintTransformer(this.lightGreen, this.lightGray);
    private FcgEdgePaintTransformer satelliteEdgePaintTransformer = new FcgEdgePaintTransformer(this.washedOutBlack, new Color(125, 125, 125, 25));

    FcgComponent(FunctionCallGraph g) {
        this.setGraph((VisualGraph)g);
        this.build();
    }

    protected FcgVertex getInitialVertex() {
        return this.fcGraph.getSource();
    }

    protected void decoratePrimaryViewer(GraphViewer<FcgVertex, FcgEdge> viewer, VisualGraphLayout<FcgVertex, FcgEdge> layout) {
        super.decoratePrimaryViewer(viewer, layout);
        RenderContext renderContext = viewer.getRenderContext();
        renderContext.setVertexFillPaintTransformer((Function)this.vertexPaintTransformer);
        renderContext.setEdgeDrawPaintTransformer((Function)this.edgePaintTransformer);
        renderContext.setArrowFillPaintTransformer((Function)this.edgePaintTransformer);
        renderContext.setArrowDrawPaintTransformer((Function)this.edgePaintTransformer);
    }

    protected void decorateSatelliteViewer(SatelliteGraphViewer<FcgVertex, FcgEdge> viewer, VisualGraphLayout<FcgVertex, FcgEdge> layout) {
        super.decorateSatelliteViewer(viewer, layout);
        RenderContext renderContext = viewer.getRenderContext();
        renderContext.setVertexFillPaintTransformer((Function)this.vertexPaintTransformer);
        renderContext.setEdgeDrawPaintTransformer((Function)this.satelliteEdgePaintTransformer);
        renderContext.setArrowFillPaintTransformer((Function)this.satelliteEdgePaintTransformer);
        renderContext.setArrowDrawPaintTransformer((Function)this.satelliteEdgePaintTransformer);
    }

    public void dispose() {
        this.fcGraph = null;
        super.dispose();
    }

    public VisualGraphViewUpdater<FcgVertex, FcgEdge> getViewUpdater() {
        return super.getViewUpdater();
    }
}

