/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.sevenzip;

import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.recognizer.ArjRecognizer;
import ghidra.app.util.recognizer.Bzip2Recognizer;
import ghidra.app.util.recognizer.CHMRecognizer;
import ghidra.app.util.recognizer.CabarcRecognizer;
import ghidra.app.util.recognizer.CramFSRecognizer;
import ghidra.app.util.recognizer.DebRecognizer;
import ghidra.app.util.recognizer.LhaRecognizer;
import ghidra.app.util.recognizer.MSWIMRecognizer;
import ghidra.app.util.recognizer.RPMRecognizer;
import ghidra.app.util.recognizer.RarRecognizer;
import ghidra.app.util.recognizer.Recognizer;
import ghidra.app.util.recognizer.SevenZipRecognizer;
import ghidra.app.util.recognizer.UnixCompressRecognizer;
import ghidra.app.util.recognizer.VHDRecognizer;
import ghidra.app.util.recognizer.XZRecognizer;
import ghidra.app.util.recognizer.XarRecognizer;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileImpl;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.GFileSystemBase;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.formats.gfilesystem.factory.GFileSystemBaseFactory;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.CryptoException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.sevenzipjbinding.ExtractOperationResult;
import net.sf.sevenzipjbinding.IInArchive;
import net.sf.sevenzipjbinding.IInStream;
import net.sf.sevenzipjbinding.ISequentialOutStream;
import net.sf.sevenzipjbinding.SevenZip;
import net.sf.sevenzipjbinding.SevenZipException;
import net.sf.sevenzipjbinding.impl.RandomAccessFileInStream;
import net.sf.sevenzipjbinding.simple.ISimpleInArchive;
import net.sf.sevenzipjbinding.simple.ISimpleInArchiveItem;

@FileSystemInfo(type="7zip", description="7Zip", factory=GFileSystemBaseFactory.class)
public class SevenZipFileSystem
extends GFileSystemBase {
    private static final Recognizer[] RECOGNIZERS = new Recognizer[]{new SevenZipRecognizer(), new XZRecognizer(), new Bzip2Recognizer(), new MSWIMRecognizer(), new ArjRecognizer(), new CabarcRecognizer(), new CHMRecognizer(), new CramFSRecognizer(), new DebRecognizer(), new LhaRecognizer(), new RarRecognizer(), new RPMRecognizer(), new VHDRecognizer(), new XarRecognizer(), new UnixCompressRecognizer()};
    private static final int MAX_BYTES;
    private Map<GFile, ISimpleInArchiveItem> map = new HashMap<GFile, ISimpleInArchiveItem>();
    private IInArchive archive;
    private ISimpleInArchive archiveInterface;
    private RandomAccessFile randomAccessFile;

    public SevenZipFileSystem(String fileSystemName, ByteProvider provider) {
        super(fileSystemName, provider);
    }

    public boolean isValid(TaskMonitor monitor) throws IOException {
        try {
            byte[] bytes = this.provider.readBytes(0L, (long)MAX_BYTES);
            for (Recognizer recognizer : RECOGNIZERS) {
                String recognized = recognizer.recognize(bytes);
                if (recognized == null) continue;
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public void open(TaskMonitor monitor) throws IOException, CryptoException, CancelledException {
        monitor.setMessage("Opening ZIP...");
        try {
            if (this.openFile(monitor)) {
                return;
            }
        }
        catch (SevenZipException e) {
            Msg.warn((Object)((Object)this), (Object)"Problem opening 7-Zip archive", (Throwable)e);
            throw new IOException(e);
        }
        if (this.openInputStream(monitor)) {
            return;
        }
        throw new IOException("Unable to open zip file system.");
    }

    private boolean openFile(TaskMonitor monitor) throws FileNotFoundException, SevenZipException {
        File file = this.provider.getFile();
        if (file != null) {
            ISimpleInArchiveItem[] items;
            this.randomAccessFile = new RandomAccessFile(file, "r");
            this.archive = SevenZip.openInArchive(null, (IInStream)new RandomAccessFileInStream(this.randomAccessFile));
            this.archiveInterface = this.archive.getSimpleInterface();
            for (ISimpleInArchiveItem item : items = this.archiveInterface.getArchiveItems()) {
                if (monitor.isCancelled()) break;
                this.storeEntry(item, monitor);
            }
            return true;
        }
        return false;
    }

    private void storeEntry(ISimpleInArchiveItem entry, TaskMonitor monitor) throws SevenZipException {
        String path = entry.getPath();
        monitor.setMessage(path);
        GFileImpl file = GFileImpl.fromPathString((GFileSystem)this, (GFile)this.root, (String)path, null, (boolean)entry.isFolder(), (long)this.getSize(entry));
        this.storeFile((GFile)file, entry);
    }

    private void storeFile(GFile file, ISimpleInArchiveItem entry) {
        if (file == null) {
            return;
        }
        if (file.equals(this.root)) {
            return;
        }
        if (!this.map.containsKey(file) || this.map.get(file) == null) {
            this.map.put(file, entry);
        }
        GFile parentFile = file.getParentFile();
        this.storeFile(parentFile, null);
    }

    private boolean openInputStream(TaskMonitor monitor) {
        return false;
    }

    public List<GFile> getListing(GFile directory) throws IOException {
        if (directory == null || directory.equals(this.root)) {
            ArrayList<GFile> roots = new ArrayList<GFile>();
            for (GFile file : this.map.keySet()) {
                if (file.getParentFile() != this.root && !file.getParentFile().equals(this.root)) continue;
                roots.add(file);
            }
            return roots;
        }
        ArrayList<GFile> tmp = new ArrayList<GFile>();
        for (GFile file : this.map.keySet()) {
            if (file.getParentFile() == null || !file.getParentFile().equals(directory)) continue;
            tmp.add(file);
        }
        return tmp;
    }

    public String getInfo(GFile file, TaskMonitor monitor) throws IOException {
        ISimpleInArchiveItem entry = this.map.get(file);
        StringBuffer buffer = new StringBuffer();
        try {
            buffer.append("Path: " + entry.getPath() + "\n");
            buffer.append("Folder?: " + entry.isFolder() + "\n");
            buffer.append("Encrypted?: " + entry.isEncrypted() + "\n");
            buffer.append("Comment: " + entry.getComment() + "\n");
            Long packedSize = entry.getPackedSize();
            buffer.append("Compressed Size: " + (String)(packedSize == null ? "(null)" : " 0x" + Long.toHexString(packedSize)) + "\n");
            buffer.append("Uncompressed Size: 0x" + this.getSize(entry) + "\n");
            Integer crc = entry.getCRC();
            buffer.append("CRC: " + (String)(crc == null ? "(null)" : " 0x" + Long.toHexString(crc.intValue())) + "\n");
            buffer.append("Compression Method: " + entry.getMethod() + "\n");
            buffer.append("Time: " + entry.getCreationTime() + "\n");
        }
        catch (SevenZipException e) {
            Msg.warn((Object)((Object)this), (Object)"7-Zip exception trying to get info on item", (Throwable)e);
        }
        return buffer.toString();
    }

    protected InputStream getData(GFile file, TaskMonitor monitor) throws IOException, CancelledException {
        ISimpleInArchiveItem entry = this.map.get(file);
        if (entry == null) {
            return null;
        }
        try {
            if (entry.isFolder()) {
                throw new IOException(file.getName() + " is a directory");
            }
        }
        catch (SevenZipException e) {
            throw new IOException("trying to test if " + file + " is a folder", e);
        }
        if (this.archiveInterface != null) {
            MySequentialOutStream sequentialOutputStream = new MySequentialOutStream();
            try {
                entry.extractSlow((ISequentialOutStream)sequentialOutputStream);
            }
            catch (SevenZipException e1) {
                throw new IOException(e1);
            }
            try {
                ExtractOperationResult operationResult = entry.extractSlow((ISequentialOutStream)sequentialOutputStream);
                if (operationResult == null) {
                    throw new IOException("7-Zip returned null operation result");
                }
                switch (operationResult) {
                    case CRCERROR: {
                        throw new IOException("7-Zip returned CRC error");
                    }
                    case DATAERROR: {
                        throw new IOException("7-Zip returned data error");
                    }
                    case UNSUPPORTEDMETHOD: {
                        throw new IOException("Unexpected: 7-Zip returned unsupported method");
                    }
                    case UNKNOWN_OPERATION_RESULT: {
                        throw new IOException("Unexpected: 7-Zip returned unknown operation result");
                    }
                }
            }
            catch (SevenZipException e) {
                Throwable cause = e.getCause();
                if (cause != null && cause instanceof IOException) {
                    throw (IOException)cause;
                }
                if (cause != null && cause instanceof CancelledException) {
                    throw (CancelledException)cause;
                }
                throw new IOException("7-Zip exception", e);
            }
            return sequentialOutputStream.getData();
        }
        return null;
    }

    private int getSize(ISimpleInArchiveItem entry) {
        try {
            Long tempSize = entry.getSize();
            return tempSize == null ? 0 : tempSize.intValue();
        }
        catch (SevenZipException sevenZipException) {
            return 0;
        }
    }

    public void close() throws IOException {
        try {
            this.archive.close();
        }
        catch (SevenZipException e) {
            Msg.warn((Object)((Object)this), (Object)"Problem closing 7-Zip archive", (Throwable)e);
        }
        this.randomAccessFile.close();
        super.close();
    }

    static {
        int max = 0;
        for (Recognizer recognizer : RECOGNIZERS) {
            int numberOfBytesRequired = recognizer.numberOfBytesRequired();
            if (numberOfBytesRequired <= max) continue;
            max = numberOfBytesRequired;
        }
        MAX_BYTES = max;
    }

    class MySequentialOutStream
    implements ISequentialOutStream {
        private File tempFile = File.createTempFile("Ghidra_", ".tmp");
        private OutputStream outputStream = new FileOutputStream(this.tempFile);

        MySequentialOutStream() throws IOException {
        }

        InputStream getData() throws IOException {
            this.outputStream.close();
            return new FileInputStream(this.tempFile);
        }

        public int write(byte[] buffer) throws SevenZipException {
            try {
                this.outputStream.write(buffer);
            }
            catch (IOException e) {
                throw new SevenZipException((Throwable)e);
            }
            return buffer.length;
        }
    }
}

