/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.dmg;

import generic.jar.ResourceFile;
import ghidra.app.util.bin.ByteProvider;
import ghidra.file.formats.ios.dmg.DmgClientFileSystem;
import ghidra.file.formats.ios.dmg.DmgConstants;
import ghidra.file.formats.ios.dmg.DmgDecryptorStream;
import ghidra.file.formats.xar.XARUtil;
import ghidra.file.formats.zlib.ZLIB;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FileCacheEntry;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.factory.GFileSystemFactoryWithFile;
import ghidra.formats.gfilesystem.factory.GFileSystemProbeFull;
import ghidra.framework.Application;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.CryptoException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import utilities.util.ArrayUtilities;
import utilities.util.FileUtilities;

public class DmgClientFileSystemFactory
implements GFileSystemFactoryWithFile<DmgClientFileSystem>,
GFileSystemProbeFull {
    public boolean probe(FSRL containerFSRL, ByteProvider byteProvider, File containerFile, FileSystemService fsService, TaskMonitor taskMonitor) throws IOException, CancelledException {
        if (!DmgClientFileSystemFactory.isDmgPresent()) {
            return false;
        }
        if (XARUtil.isXAR(byteProvider)) {
            return false;
        }
        if (ZLIB.isZLIB(byteProvider)) {
            return true;
        }
        return DmgClientFileSystemFactory.isEncrypted(containerFile);
    }

    private static boolean isEncrypted(byte[] startBytes) {
        return ArrayUtilities.arrayRangesEquals((byte[])startBytes, (int)0, (byte[])DmgConstants.DMG_MAGIC_BYTES_v1, (int)0, (int)DmgConstants.DMG_MAGIC_BYTES_v1.length) || ArrayUtilities.arrayRangesEquals((byte[])startBytes, (int)0, (byte[])DmgConstants.DMG_MAGIC_BYTES_v2, (int)0, (int)DmgConstants.DMG_MAGIC_BYTES_v2.length);
    }

    private static boolean isEncrypted(File f) {
        try {
            byte[] startBytes = FileUtilities.getBytesFromFile((File)f, (long)0L, (long)8L);
            return DmgClientFileSystemFactory.isEncrypted(startBytes);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public DmgClientFileSystem create(FSRL containerFSRL, FSRLRoot targetFSRL, File containerFile, FileSystemService fsService, TaskMonitor monitor) throws IOException, CancelledException {
        File decrypted_dmg_file;
        String dmgName = containerFSRL.getName();
        if (DmgClientFileSystemFactory.isEncrypted(containerFile)) {
            if (containerFSRL.getNestingDepth() < 2) {
                throw new CryptoException("Unable to decrypt DMG data because DMG crypto keys are specific to the container it is embedded in and this DMG was not in a container");
            }
            String containerName = containerFSRL.getName(1);
            FileCacheEntry fce = fsService.getDerivedFile(containerFSRL, "decrypted " + containerName, srcFile -> {
                monitor.initialize(srcFile.length());
                return new DmgDecryptorStream(containerName, dmgName, srcFile);
            }, monitor);
            decrypted_dmg_file = fce.file;
        } else {
            decrypted_dmg_file = containerFile;
        }
        DmgClientFileSystem fs = new DmgClientFileSystem(decrypted_dmg_file, targetFSRL, fsService);
        try {
            fs.mount(monitor);
            return fs;
        }
        catch (IOException ioe) {
            Msg.error((Object)this, (Object)("Failed to mount DMG file system " + containerFSRL + ": "), (Throwable)ioe);
            fs.close();
            throw ioe;
        }
    }

    private static boolean isDmgPresent() {
        return DmgPresentHolder.DMG_PRESENT;
    }

    private static class DmgPresentHolder {
        static final boolean DMG_PRESENT = DmgPresentHolder.isDmgPresent();

        private DmgPresentHolder() {
        }

        private static boolean isDmgPresent() {
            ResourceFile dmgModule = Application.getModuleRootDir((String)"DMG");
            if (dmgModule == null) {
                Msg.debug(DmgClientFileSystemFactory.class, (Object)"The required \"DMG\" module is not installed.   You must install this module in order to open DMG filesystems.");
                return false;
            }
            return true;
        }
    }
}

