/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.dex.format;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.android.dex.format.EncodedValue;
import ghidra.file.formats.android.dex.util.Leb128;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;

public class EncodedArray
implements StructConverter {
    private int size;
    private int sizeLength;
    private byte[] values;

    public EncodedArray(BinaryReader reader) throws IOException {
        this.size = Leb128.readUnsignedLeb128(reader.readByteArray(reader.getPointerIndex(), 5));
        this.sizeLength = Leb128.unsignedLeb128Size(this.size);
        reader.readNextByteArray(this.sizeLength);
        long oldIndex = reader.getPointerIndex();
        ArrayList<EncodedValue> valuesList = new ArrayList<EncodedValue>();
        for (int i = 0; i < this.size; ++i) {
            valuesList.add(new EncodedValue(reader));
        }
        int nBytes = (int)(reader.getPointerIndex() - oldIndex);
        reader.setPointerIndex(oldIndex);
        this.values = reader.readNextByteArray(nBytes);
    }

    public int getSize() {
        return this.size;
    }

    public byte[] getValues() {
        return this.values;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType("encoded_array_" + this.values.length, 0);
        structure.add((DataType)new ArrayDataType(BYTE, this.sizeLength, BYTE.getLength()), "size", null);
        if (this.values.length > 0) {
            structure.add((DataType)new ArrayDataType(BYTE, this.values.length, BYTE.getLength()), "values", null);
        }
        structure.setCategoryPath(new CategoryPath("/dex/encoded_array"));
        return structure;
    }
}

