/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.task;

import generic.util.WindowUtilities;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.TaskUtilities;
import ghidra.util.task.CancelledListener;
import ghidra.util.task.MonitoredRunnable;
import ghidra.util.task.Task;
import ghidra.util.task.TaskDialog;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import javax.swing.SwingUtilities;

public class TaskLauncher {
    static final int INITIAL_DELAY = 1000;
    public static final int INITIAL_MODAL_DELAY = 500;
    protected Task task;
    private TaskDialog taskDialog;
    private Thread taskThread;
    private CancelledListener monitorChangeListener = () -> {
        if (this.task.isInterruptible()) {
            this.taskThread.interrupt();
        }
        if (this.task.isForgettable()) {
            this.taskDialog.close();
        }
    };

    public static <T extends Task> T launch(T task) {
        new TaskLauncher(task);
        return task;
    }

    public static void launchNonModal(String title, final MonitoredRunnable runnable) {
        new TaskLauncher(new Task(title, true, true, false){

            public void run(TaskMonitor monitor) {
                runnable.monitoredRun(monitor);
            }
        }, null, 1000);
    }

    public static void launchModal(String title, final MonitoredRunnable runnable) {
        new TaskLauncher(new Task(title, true, true, true){

            public void run(TaskMonitor monitor) {
                runnable.monitoredRun(monitor);
            }
        }, null, 500);
    }

    public static void launchModal(String title, final Runnable runnable) {
        Task t = new Task(title, false, false, true){

            public void run(TaskMonitor monitor) {
                runnable.run();
            }
        };
        int delay = 0;
        new TaskLauncher(t, null, delay);
    }

    private static Component getParent(Component parent) {
        if (parent == null) {
            return null;
        }
        return parent.isVisible() ? parent : null;
    }

    public TaskLauncher(Task task) {
        this(task, null, task.isModal() ? 500 : 1000);
    }

    public TaskLauncher(Task task, Component parent) {
        this(task, TaskLauncher.getParent(parent), task.isModal() ? 500 : 1000);
    }

    public TaskLauncher(Task task, Component parent, int delay) {
        this(task, parent, delay, 275);
    }

    public TaskLauncher(Task task, Component parent, int delay, int dialogWidth) {
        this.task = task;
        this.taskDialog = this.buildTaskDialog(parent, dialogWidth);
        this.startBackgroundThread(this.taskDialog);
        this.taskDialog.show(Math.max(delay, 0));
        this.waitForModalIfNotSwing();
    }

    private void waitForModalIfNotSwing() {
        if (SwingUtilities.isEventDispatchThread() || !this.task.isModal()) {
            return;
        }
        try {
            this.taskThread.join();
        }
        catch (InterruptedException e) {
            Msg.debug((Object)this, (Object)"Task Launcher unexpectedly interrupted waiting for task thread", (Throwable)e);
        }
    }

    public TaskLauncher(Task task, TaskMonitor taskMonitor) {
        this.task = task;
        this.startBackgroundThread(taskMonitor);
    }

    private TaskDialog buildTaskDialog(Component comp, int dialogWidth) {
        SystemUtilities.runSwingNow(() -> {
            this.taskDialog = this.createTaskDialog(comp);
            this.taskDialog.setMinimumSize(dialogWidth, 0);
        });
        if (this.task.isInterruptible() || this.task.isForgettable()) {
            this.taskDialog.addCancelledListener(this.monitorChangeListener);
        }
        this.taskDialog.setStatusJustification(this.task.getStatusTextAlignment());
        return this.taskDialog;
    }

    private void startBackgroundThread(TaskMonitor monitor) {
        TaskUtilities.addTrackedTask((Task)this.task, (TaskMonitor)monitor);
        String name = "Task - " + this.task.getTaskTitle();
        this.taskThread = new Thread(() -> {
            this.task.monitoredRun(monitor);
            this.taskProcessed();
        }, name);
        this.taskThread.setPriority(1);
        this.taskThread.start();
    }

    private void taskProcessed() {
        if (this.taskDialog != null) {
            this.taskDialog.taskProcessed();
        }
    }

    protected TaskDialog createTaskDialog(Component comp) {
        Component parent = comp;
        if (parent != null) {
            parent = WindowUtilities.windowForComponent((Component)comp);
        }
        if (parent == null) {
            return new TaskDialog(this.task);
        }
        return new TaskDialog(comp, this.task);
    }
}

