/*
 * Decompiled with CFR 0.152.
 */
package ghidra.docking.util;

import ghidra.docking.util.painting.GRepaintManager;
import ghidra.framework.OperatingSystem;
import ghidra.framework.Platform;
import ghidra.framework.preferences.Preferences;
import ghidra.util.BeginningOfLineAction;
import ghidra.util.DeleteToEndOfWordAction;
import ghidra.util.DeleteToStartOfWordAction;
import ghidra.util.EndOfLineAction;
import ghidra.util.Msg;
import ghidra.util.SelectBeginningOfLineAction;
import ghidra.util.SelectEndOfLineAction;
import ghidra.util.SystemUtilities;
import java.awt.Dimension;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.RepaintManager;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.ComponentUI;

public class DockingWindowsLookAndFeelUtils {
    public static final String LAST_LOOK_AND_FEEL_KEY = "LastLookAndFeel";
    public static final String USE_INVERTED_COLORS_KEY = "LookAndFeel.UseInvertedColors";
    public static final String METAL_LOOK_AND_FEEL = "Metal";
    private static final String SYSTEM_LOOK_AND_FEEL = "System";
    private static final String NIMBUS_LOOK_AND_FEEL = "Nimbus";
    private static RepaintManager defaultSwingRepaintManager = null;

    private DockingWindowsLookAndFeelUtils() {
    }

    public static void loadFromPreferences() {
        boolean useHistoricalValue = true;
        String laf = Preferences.getProperty((String)LAST_LOOK_AND_FEEL_KEY, (String)DockingWindowsLookAndFeelUtils.getDefaultLookAndFeelName(), (boolean)useHistoricalValue);
        DockingWindowsLookAndFeelUtils.setLookAndFeel(laf);
        boolean useInvertedColors = DockingWindowsLookAndFeelUtils.getUseInvertedColorsPreference();
        DockingWindowsLookAndFeelUtils.setUseInvertedColors(useInvertedColors);
        Integer fontOverride = SystemUtilities.getFontSizeOverrideValue();
        if (fontOverride != null) {
            DockingWindowsLookAndFeelUtils.setGlobalFontSizeOverride(fontOverride);
        }
    }

    public static boolean getUseInvertedColorsPreference() {
        boolean useHistoricalValue = true;
        String useInvertedColorsString = Preferences.getProperty((String)USE_INVERTED_COLORS_KEY, (String)Boolean.FALSE.toString(), (boolean)useHistoricalValue);
        boolean useInvertedColors = Boolean.parseBoolean(useInvertedColorsString);
        return useInvertedColors;
    }

    public static String getInstalledLookAndFeelName() {
        return UIManager.getLookAndFeel().getName();
    }

    public static void setLookAndFeel(String lookAndFeelName) {
        SystemUtilities.runSwingNow(() -> {
            try {
                DockingWindowsLookAndFeelUtils.installLookAndFeelByName(lookAndFeelName);
                DockingWindowsLookAndFeelUtils.installGlobalLookAndFeelAttributes();
                DockingWindowsLookAndFeelUtils.installGlobalFontSizeOverride();
                DockingWindowsLookAndFeelUtils.installCustomLookAndFeelActions();
                DockingWindowsLookAndFeelUtils.installPopupMenuSettingsOverride();
            }
            catch (Exception exc) {
                Msg.error(DockingWindowsLookAndFeelUtils.class, (Object)("Error loading Look and Feel: " + exc), (Throwable)exc);
            }
        });
    }

    public static List<String> getLookAndFeelNames() {
        UIManager.LookAndFeelInfo[] installedLookAndFeels;
        ArrayList<String> list = new ArrayList<String>();
        list.add(SYSTEM_LOOK_AND_FEEL);
        for (UIManager.LookAndFeelInfo info : installedLookAndFeels = UIManager.getInstalledLookAndFeels()) {
            list.add(info.getName());
        }
        return list;
    }

    private static void installLookAndFeelByName(String lookAndFeelName) throws ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        String lookAndFeelClassName = DockingWindowsLookAndFeelUtils.findLookAndFeelClassName(lookAndFeelName);
        UIManager.setLookAndFeel(lookAndFeelClassName);
        DockingWindowsLookAndFeelUtils.fixupLookAndFeelIssues();
    }

    private static String findLookAndFeelClassName(String lookAndFeelName) {
        UIManager.LookAndFeelInfo[] installedLookAndFeels;
        if (lookAndFeelName.equalsIgnoreCase(SYSTEM_LOOK_AND_FEEL)) {
            return UIManager.getSystemLookAndFeelClassName();
        }
        for (UIManager.LookAndFeelInfo info : installedLookAndFeels = UIManager.getInstalledLookAndFeels()) {
            String className = info.getClassName();
            if (!lookAndFeelName.equals(className) && !lookAndFeelName.equals(info.getName())) continue;
            return className;
        }
        Msg.debug(DockingWindowsLookAndFeelUtils.class, (Object)("Unable to find requested Look and Feel: " + lookAndFeelName));
        return UIManager.getSystemLookAndFeelClassName();
    }

    public static void setUseInvertedColors(boolean useInvertedColors) {
        SystemUtilities.runIfSwingOrPostSwingLater(() -> {
            if (defaultSwingRepaintManager == null) {
                defaultSwingRepaintManager = RepaintManager.currentManager(null);
            }
            RepaintManager rm = defaultSwingRepaintManager;
            if (useInvertedColors) {
                rm = new GRepaintManager();
            }
            RepaintManager.setCurrentManager(rm);
        });
    }

    private static void fixupLookAndFeelIssues() {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        switch (lookAndFeel.getName()) {
            case "Nimbus": {
                UIDefaults defaults = lookAndFeel.getDefaults();
                defaults.put("ScrollBar.minimumThumbSize", new Dimension(30, 30));
            }
        }
    }

    private static void installGlobalLookAndFeelAttributes() {
        Font f = new Font("Monospaced", 0, 12);
        UIManager.put("PasswordField.font", f);
        UIManager.put("TextArea.font", f);
        UIManager.put("Button.rollover", Boolean.TRUE);
        UIManager.put("ToolBar.isRollover", Boolean.TRUE);
    }

    private static void installPopupMenuSettingsOverride() {
        UIManager.put("PopupMenu.consumeEventOnClose", Boolean.FALSE);
    }

    private static void installGlobalFontSizeOverride() {
        Integer overrideFontInteger = SystemUtilities.getFontSizeOverrideValue();
        if (overrideFontInteger == null) {
            return;
        }
        DockingWindowsLookAndFeelUtils.setGlobalFontSizeOverride(overrideFontInteger);
    }

    private static void installCustomLookAndFeelActions() {
        String[] UIPrefixValues = new String[]{"TextField", "FormattedTextField", "TextArea", "TextPane", "EditorPane"};
        DeleteToStartOfWordAction deleteToStartOfWordAction = new DeleteToStartOfWordAction();
        DockingWindowsLookAndFeelUtils.registerAction(deleteToStartOfWordAction, DeleteToStartOfWordAction.KEY_STROKE, UIPrefixValues);
        DeleteToEndOfWordAction deleteToEndOfWordAction = new DeleteToEndOfWordAction();
        DockingWindowsLookAndFeelUtils.registerAction(deleteToEndOfWordAction, DeleteToEndOfWordAction.KEY_STROKE, UIPrefixValues);
        BeginningOfLineAction beginningOfLineAction = new BeginningOfLineAction();
        DockingWindowsLookAndFeelUtils.registerAction(beginningOfLineAction, BeginningOfLineAction.KEY_STROKE, UIPrefixValues);
        EndOfLineAction endOfLineAction = new EndOfLineAction();
        DockingWindowsLookAndFeelUtils.registerAction(endOfLineAction, EndOfLineAction.KEY_STROKE, UIPrefixValues);
        SelectBeginningOfLineAction selectBeginningOfLineAction = new SelectBeginningOfLineAction();
        DockingWindowsLookAndFeelUtils.registerAction(selectBeginningOfLineAction, SelectBeginningOfLineAction.KEY_STROKE, UIPrefixValues);
        SelectEndOfLineAction selectEndOfLineAction = new SelectEndOfLineAction();
        DockingWindowsLookAndFeelUtils.registerAction(selectEndOfLineAction, SelectEndOfLineAction.KEY_STROKE, UIPrefixValues);
    }

    private static void registerAction(Action action, KeyStroke keyStroke, String[] prefixValues) {
        for (String properyPrefix : prefixValues) {
            UIDefaults defaults = UIManager.getDefaults();
            Object object = defaults.get(properyPrefix + ".focusInputMap");
            InputMap inputMap = (InputMap)object;
            inputMap.put(keyStroke, action);
        }
    }

    private static void setGlobalFontSizeOverride(int fontSize) {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        UIDefaults defaults = lookAndFeel.getDefaults();
        Set set = defaults.entrySet();
        for (Map.Entry entry : set) {
            Font currentFont;
            Object key = entry.getKey();
            if (key.toString().toLowerCase().indexOf("font") == -1 || (currentFont = defaults.getFont(key)) == null) continue;
            Font newFont = currentFont.deriveFont((float)fontSize);
            UIManager.put(key, newFont);
        }
    }

    private static String getDefaultLookAndFeelName() {
        OperatingSystem OS = Platform.CURRENT_PLATFORM.getOperatingSystem();
        if (OS == OperatingSystem.LINUX) {
            return NIMBUS_LOOK_AND_FEEL;
        }
        return SYSTEM_LOOK_AND_FEEL;
    }

    public static boolean isUsingAquaUI(ComponentUI UI) {
        Class<?> clazz = UI.getClass();
        String name = clazz.getSimpleName();
        return name.startsWith("Aqua");
    }
}

