/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.tree.support;

import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.support.GTreeFilter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class GTreeRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = 1L;
    private static final Color VALID_DROP_TARGET_COLOR = new Color(200, 200, 255);
    private static final int DEFAULT_MIN_ICON_WIDTH = 22;
    private Object dropTarget;
    private boolean paintDropTarget;
    private Font cachedDefaultFont;
    private Font cachedBoldFont;
    private int minIconWidth = 22;

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected1, boolean expanded, boolean leaf, int row, boolean hasFocus1) {
        super.getTreeCellRendererComponent(tree, value, selected1, expanded, leaf, row, hasFocus1);
        GTreeNode node = (GTreeNode)value;
        String text = node.getName();
        this.setText(text);
        this.setToolTipText(node.getToolTip());
        Icon icon = node.getIcon(expanded);
        if (icon == null) {
            icon = this.getIcon();
        } else {
            this.setIcon(icon);
        }
        this.updateIconTextGap(icon, this.minIconWidth);
        this.paintDropTarget = value == this.dropTarget;
        GTree gtree = node.getTree();
        GTreeFilter filter = gtree == null ? null : gtree.getFilter();
        boolean isBold = filter != null && filter.showFilterMatches() && filter.acceptsNode(node);
        this.setFont(this.getFont(isBold));
        return this;
    }

    protected void updateIconTextGap(Icon icon, int minWidth) {
        int iconWidth = 0;
        if (icon != null) {
            iconWidth = icon.getIconWidth();
        }
        this.setIconTextGap(Math.max(minWidth - iconWidth, 2));
    }

    @Override
    public void setIcon(Icon icon) {
        super.setIcon(icon);
        this.updateIconTextGap(icon, this.minIconWidth);
    }

    public int getMinIconWidth() {
        return this.minIconWidth;
    }

    public void setMinIconWidth(int minIconWidth) {
        this.minIconWidth = minIconWidth;
    }

    private Font getFont(boolean bold) {
        Font font = this.getFont();
        if (font != this.cachedDefaultFont && font != this.cachedBoldFont) {
            this.cachedDefaultFont = font;
            this.cachedBoldFont = new Font(font.getFamily(), 1, font.getSize());
        }
        return bold ? this.cachedBoldFont : this.cachedDefaultFont;
    }

    @Override
    public Color getBackgroundNonSelectionColor() {
        if (this.paintDropTarget) {
            return VALID_DROP_TARGET_COLOR;
        }
        return super.getBackgroundNonSelectionColor();
    }

    public void setRendererDropTarget(Object target) {
        this.dropTarget = target;
    }
}

