/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table.constraint.dialog;

import docking.widgets.EmptyBorderButton;
import docking.widgets.combobox.GhidraComboBox;
import docking.widgets.list.GListCellRenderer;
import docking.widgets.table.constraint.dialog.ColumnFilterData;
import docking.widgets.table.constraint.dialog.ConstraintFilterPanel;
import docking.widgets.table.constraint.dialog.DialogFilterCondition;
import docking.widgets.table.constraint.dialog.DialogFilterRow;
import ghidra.util.layout.VerticalLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import resources.ResourceManager;

class ColumnFilterPanel
extends JPanel {
    private static final int BUTTON_ICON_SIZE = 16;
    private DialogFilterRow filterEntry;
    private JComboBox<ColumnFilterData<?>> columnFilterComboBox;
    private List<ConstraintFilterPanel> filterPanels = new ArrayList<ConstraintFilterPanel>(2);

    ColumnFilterPanel(DialogFilterRow filterEntry) {
        this.filterEntry = filterEntry;
        this.setLayout(new BorderLayout());
        this.add(this.buildConstraintPanels(), "Center");
        this.add(this.buildButtonPanel(), "East");
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
    }

    private Component buildButtonPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        ImageIcon icon = ResourceManager.loadImage((String)"images/Plus.png");
        icon = ResourceManager.getScaledIcon((Icon)icon, (int)16, (int)16);
        EmptyBorderButton button = new EmptyBorderButton(icon);
        button.setToolTipText("Add a column condition");
        button.addActionListener(e -> this.filterEntry.addFilterCondition());
        panel.add((Component)button, "North");
        return panel;
    }

    private Component buildColumnComboBox() {
        Vector v = new Vector(this.filterEntry.getAllColumnData());
        DefaultComboBoxModel model = new DefaultComboBoxModel(v);
        this.columnFilterComboBox = new GhidraComboBox(model);
        this.columnFilterComboBox.setRenderer(new GListCellRenderer<ColumnFilterData<?>>(){

            @Override
            protected String getItemText(ColumnFilterData<?> value) {
                return value == null ? "" : value.getName();
            }

            @Override
            public boolean shouldAlternateRowBackgroundColor() {
                return false;
            }
        });
        this.columnFilterComboBox.setSelectedItem(this.filterEntry.getColumnFilterData());
        this.columnFilterComboBox.addItemListener(e -> this.columnChanged());
        this.columnFilterComboBox.addActionListener(e -> this.columnChanged());
        return this.columnFilterComboBox;
    }

    private Component buildConstraintPanels() {
        JPanel panel = new JPanel((LayoutManager)new VerticalLayout(0));
        this.setBorder(BorderFactory.createEmptyBorder(5, 2, 2, 2));
        this.buildColumnComboBox();
        List<DialogFilterCondition<?>> filterConditions = this.filterEntry.getFilterConditions();
        ConstraintFilterPanel filterPanel = new ConstraintFilterPanel(filterConditions.get(0), this.columnFilterComboBox);
        this.filterPanels.add(filterPanel);
        panel.add(filterPanel);
        for (int i = 1; i < filterConditions.size(); ++i) {
            filterPanel = new ConstraintFilterPanel(filterConditions.get(i), this.createOrLabel());
            this.filterPanels.add(filterPanel);
            panel.add(filterPanel);
        }
        return panel;
    }

    private Component createOrLabel() {
        JLabel jLabel = new JLabel("<OR>", 0);
        jLabel.setForeground(Color.GRAY);
        return jLabel;
    }

    private void columnChanged() {
        int selectedIndex = this.columnFilterComboBox.getSelectedIndex();
        ColumnFilterData<?> selectedColumnData = this.columnFilterComboBox.getItemAt(selectedIndex);
        this.filterEntry.setColumnData(selectedColumnData);
    }

    boolean hasValidFilterValue() {
        return this.filterEntry.hasValidFilterValue();
    }

    DialogFilterRow getColumnFilterEntry() {
        return this.filterEntry;
    }
}

