/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.dialogs;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.widgets.dialogs.StringChoices;
import docking.widgets.table.DefaultSortedTableModel;
import docking.widgets.table.GTable;
import ghidra.docking.settings.BooleanSettingsDefinition;
import ghidra.docking.settings.EnumSettingsDefinition;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.util.HelpLocation;
import ghidra.util.exception.AssertException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.AbstractCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;

public class SettingsDialog
extends DialogComponentProvider {
    private static final int WIDTH = 300;
    private static final int HEIGHT = 150;
    private SettingsDefinition[] settingsDefs;
    private Settings settings;
    private SettingsTableModel settingsTableModel;
    private GTable settingsTable;

    public SettingsDialog(HelpLocation help) {
        super("Settings", true, false, true, false);
        if (help != null) {
            this.setHelpLocation(help);
        }
        this.addWorkPanel(this.buildWorkPanel());
        this.addDismissButton();
        this.setHelpLocation(new HelpLocation("Tables/GhidraTableHeaders.html", "ColumnSettings"));
    }

    public void show(Component parent, String title, SettingsDefinition[] newSettingsDefs, Settings newSettings) {
        this.settingsDefs = newSettingsDefs;
        this.settings = newSettings;
        this.setTitle(title);
        this.settingsTableModel.fireTableDataChanged();
        DockingWindowManager.showDialog(parent, this);
    }

    public void dispose() {
        this.settingsTable.editingStopped(null);
        this.close();
        this.settingsDefs = null;
        this.settings = null;
    }

    private JPanel buildWorkPanel() {
        JPanel workPanel = new JPanel(new BorderLayout());
        workPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.settingsTableModel = new SettingsTableModel();
        DefaultSortedTableModel sorter = new DefaultSortedTableModel(this.settingsTableModel);
        sorter.sortByColumn(0);
        this.settingsTable = new GTable(sorter);
        this.settingsTable.setAutoscrolls(true);
        this.settingsTable.setRowSelectionAllowed(false);
        this.settingsTable.setColumnSelectionAllowed(false);
        this.settingsTable.getTableHeader().setReorderingAllowed(false);
        this.settingsTable.setColumnHeaderPopupEnabled(false);
        this.settingsTable.setUserSortingEnabled(false);
        this.settingsTable.setDefaultRenderer(Settings.class, new DefaultTableCellRenderer());
        this.settingsTable.setDefaultEditor(Settings.class, new SettingsEditor());
        JScrollPane scrollpane = new JScrollPane(this.settingsTable);
        scrollpane.setPreferredSize(new Dimension(300, 150));
        workPanel.add((Component)scrollpane, "Center");
        return workPanel;
    }

    @Override
    protected void cancelCallback() {
        this.dispose();
    }

    private class SettingsEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    PopupMenuListener {
        static final int ENUM = 0;
        static final int BOOLEAN = 1;
        private int mode;
        private JComboBox comboBox = new JComboBox();
        private JCheckBox checkBox = new JCheckBox();
        private final Runnable editStopped = new Runnable(){

            @Override
            public void run() {
                SettingsEditor.this.fireEditingStopped();
            }
        };

        SettingsEditor() {
            this.comboBox.addPopupMenuListener(this);
        }

        @Override
        public Object getCellEditorValue() {
            switch (this.mode) {
                case 0: {
                    return this.getComboBoxEnum();
                }
                case 1: {
                    return new Boolean(this.checkBox.isSelected());
                }
            }
            throw new AssertException();
        }

        private StringChoices getComboBoxEnum() {
            String[] items = new String[this.comboBox.getItemCount()];
            for (int i = 0; i < items.length; ++i) {
                items[i] = (String)this.comboBox.getItemAt(i);
            }
            StringChoices choices = new StringChoices(items);
            choices.setSelectedValue(this.comboBox.getSelectedIndex());
            return choices;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value instanceof StringChoices) {
                this.initComboBox((StringChoices)value);
                return this.comboBox;
            }
            if (value instanceof Boolean) {
                this.initCheckBox((Boolean)value);
                return this.checkBox;
            }
            throw new AssertException("SettingsEditor: " + value.getClass().getName() + " not supported");
        }

        private void initCheckBox(Boolean b) {
            this.mode = 1;
            this.checkBox.setSelected(b);
        }

        private void initComboBox(StringChoices choices) {
            String[] items;
            this.mode = 0;
            this.comboBox.removeAllItems();
            for (String item : items = choices.getValues()) {
                this.comboBox.addItem(item);
            }
            this.comboBox.setSelectedIndex(choices.getSelectedValueIndex());
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            SwingUtilities.invokeLater(this.editStopped);
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }
    }

    class SettingsTableModel
    extends AbstractTableModel {
        static final int DEFAULT_SORT_COL = 0;

        SettingsTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return SettingsDialog.this.settingsDefs != null ? SettingsDialog.this.settingsDefs.length : 0;
        }

        @Override
        public Object getValueAt(int row, int col) {
            switch (col) {
                case 0: {
                    return SettingsDialog.this.settingsDefs[row].getName();
                }
                case 1: {
                    if (SettingsDialog.this.settingsDefs[row] instanceof EnumSettingsDefinition) {
                        EnumSettingsDefinition def = (EnumSettingsDefinition)SettingsDialog.this.settingsDefs[row];
                        StringChoices choices = new StringChoices(def.getDisplayChoices(SettingsDialog.this.settings));
                        choices.setSelectedValue(def.getChoice(SettingsDialog.this.settings));
                        return choices;
                    }
                    if (SettingsDialog.this.settingsDefs[row] instanceof BooleanSettingsDefinition) {
                        BooleanSettingsDefinition def = (BooleanSettingsDefinition)SettingsDialog.this.settingsDefs[row];
                        return new Boolean(def.getValue(SettingsDialog.this.settings));
                    }
                    return "<Unsupported>";
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            switch (col) {
                case 1: {
                    if (SettingsDialog.this.settingsDefs[row] instanceof EnumSettingsDefinition) {
                        EnumSettingsDefinition def = (EnumSettingsDefinition)SettingsDialog.this.settingsDefs[row];
                        StringChoices choices = (StringChoices)value;
                        def.setChoice(SettingsDialog.this.settings, choices.getSelectedValueIndex());
                        this.fireTableDataChanged();
                        break;
                    }
                    if (!(SettingsDialog.this.settingsDefs[row] instanceof BooleanSettingsDefinition)) break;
                    BooleanSettingsDefinition def = (BooleanSettingsDefinition)SettingsDialog.this.settingsDefs[row];
                    def.setValue(SettingsDialog.this.settings, (Boolean)value);
                    this.fireTableDataChanged();
                    break;
                }
                case 2: {
                    if (!((Boolean)value).booleanValue()) break;
                    SettingsDialog.this.settingsDefs[row].clear(SettingsDialog.this.settings);
                    this.fireTableDataChanged();
                }
            }
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return "Name";
                }
                case 1: {
                    return "Settings";
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int col) {
            switch (col) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return Settings.class;
                }
            }
            return null;
        }

        public boolean isColumnSortable(int col) {
            return col == 0;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col != 0;
        }
    }
}

