/*
 * Decompiled with CFR 0.152.
 */
package docking.menu;

import docking.action.MenuData;
import java.util.HashMap;
import java.util.Map;

public class MenuGroupMap {
    private Map<String, String> preferredMenuGroups = new HashMap<String, String>();
    private Map<String, String> preferredMenuSubGroups = new HashMap<String, String>();

    public void setMenuGroup(String[] menuPath, String group) {
        this.setMenuGroup(menuPath, group, MenuData.NO_SUBGROUP);
    }

    public void setMenuGroup(String[] menuPath, String group, String menuSubGroup) {
        if (menuSubGroup == null) {
            menuSubGroup = MenuData.NO_SUBGROUP;
        }
        String key = MenuGroupMap.getMenuPathKey(menuPath);
        if (group == null) {
            this.preferredMenuGroups.remove(key);
        } else {
            this.preferredMenuGroups.put(key, group);
        }
        this.preferredMenuSubGroups.put(key, menuSubGroup);
    }

    public String getMenuGroup(String[] menuPath) {
        return this.preferredMenuGroups.get(MenuGroupMap.getMenuPathKey(menuPath));
    }

    public String getMenuSubGroup(String[] menuPath) {
        return this.preferredMenuSubGroups.get(MenuGroupMap.getMenuPathKey(menuPath));
    }

    private static String getMenuPathKey(String[] menuPath) {
        StringBuffer buf = new StringBuffer();
        for (String element : menuPath) {
            buf.append("/");
            buf.append(element);
        }
        return buf.toString();
    }
}

