/*
 * Decompiled with CFR 0.152.
 */
package docking.action;

import docking.ActionContext;
import docking.DockingMenuItem;
import docking.DockingWindowManager;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MenuBarData;
import docking.action.MenuData;
import docking.action.PopupMenuData;
import docking.action.ToolBarData;
import docking.widgets.EmptyBorderButton;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.StringUtilities;
import ghidra.util.SystemUtilities;
import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;
import ghidra.util.exception.AssertException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import resources.ResourceManager;
import resources.icons.FileBasedIcon;
import resources.icons.ImageIconWrapper;
import utilities.util.reflection.ReflectionUtilities;

public abstract class DockingAction
implements DockingActionIf {
    private WeakSet<PropertyChangeListener> propertyListeners = WeakDataStructureFactory.createCopyOnWriteWeakSet();
    private final String name;
    private final String owner;
    private String description = "";
    private String inceptionInformation;
    private boolean isEnabled = true;
    private boolean isKeyBindingManaged = true;
    private KeyBindingData defaultKeyBindingData;
    private KeyBindingData keyBindingData;
    private MenuBarData menuBarData;
    private PopupMenuData popupMenuData;
    private ToolBarData toolBarData;

    public DockingAction(String name, String owner) {
        this(name, owner, true);
    }

    public DockingAction(String name, String owner, boolean isKeyBindingManaged) {
        this.name = name;
        this.owner = owner;
        this.isKeyBindingManaged = isKeyBindingManaged;
        this.recordInception();
        HelpLocation location = new HelpLocation(owner, name, this.inceptionInformation);
        this.setHelpLocation(location);
    }

    @Override
    public abstract void actionPerformed(ActionContext var1);

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyListeners.add((Object)listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyListeners.remove((Object)listener);
    }

    @Override
    public boolean isKeyBindingManaged() {
        return this.isKeyBindingManaged;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getFullName() {
        return this.getName() + " (" + this.getOwner() + ")";
    }

    @Override
    public KeyBindingData getKeyBindingData() {
        return this.keyBindingData;
    }

    @Override
    public KeyBindingData getDefaultKeyBindingData() {
        return this.defaultKeyBindingData;
    }

    @Override
    public KeyStroke getKeyBinding() {
        return this.keyBindingData == null ? null : this.keyBindingData.getKeyBinding();
    }

    @Override
    public MenuData getMenuBarData() {
        return this.menuBarData;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    @Override
    public MenuData getPopupMenuData() {
        return this.popupMenuData;
    }

    @Override
    public ToolBarData getToolBarData() {
        return this.toolBarData;
    }

    @Override
    public String getInceptionInformation() {
        return this.inceptionInformation;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public boolean isAddToPopup(ActionContext context) {
        return this.isEnabledForContext(context);
    }

    @Override
    public boolean isEnabledForContext(ActionContext context) {
        return this.isEnabled();
    }

    @Override
    public boolean isValidContext(ActionContext context) {
        return true;
    }

    @Override
    public boolean isValidGlobalContext(ActionContext globalContext) {
        return this.isValidContext(globalContext);
    }

    @Override
    public boolean shouldAddToWindow(boolean isMainWindow, Set<Class<?>> contextTypes) {
        if (isMainWindow) {
            return this.menuBarData != null || this.toolBarData != null;
        }
        return false;
    }

    public void setHelpLocation(HelpLocation location) {
        DockingWindowManager.getHelpService().registerHelp(this, location);
    }

    public void markHelpUnnecessary() {
        DockingWindowManager.getHelpService().excludeFromHelp(this);
    }

    @Override
    public boolean setEnabled(boolean newValue) {
        if (this.isEnabled == newValue) {
            return this.isEnabled;
        }
        this.isEnabled = newValue;
        this.firePropertyChanged("enabled", !this.isEnabled, this.isEnabled);
        return !this.isEnabled;
    }

    @Override
    public final JButton createButton() {
        Icon icon;
        JButton button = this.doCreateButton();
        button.setName(this.getName());
        button.setFocusable(false);
        Icon icon2 = icon = this.toolBarData == null ? null : this.toolBarData.getIcon();
        if (icon == null) {
            icon = ResourceManager.getDefaultIcon();
        }
        button.setIcon(icon);
        String tt = this.getDescription();
        if (tt == null || tt.length() == 0) {
            tt = this.getName();
        }
        button.setToolTipText(tt);
        button.setEnabled(this.isEnabled());
        return button;
    }

    @Override
    public JMenuItem createMenuItem(boolean isPopup) {
        KeyStroke ks;
        MenuData menuData;
        JMenuItem menuItem = this.doCreateMenuItem();
        MenuData menuData2 = menuData = isPopup ? this.popupMenuData : this.menuBarData;
        if (menuData == null) {
            throw new AssertException("No menu data for menu type: " + (isPopup ? "Popup" : "Menubar"));
        }
        String text = menuData.getMenuItemName();
        String trimmed = StringUtilities.trimMiddle((String)text, (int)50);
        menuItem.setText(trimmed);
        menuItem.setIcon(menuData.getMenuIcon());
        menuItem.setMnemonic(menuData.getMnemonic());
        KeyStroke keyStroke = ks = this.keyBindingData == null ? null : this.keyBindingData.getKeyBinding();
        if (ks != null) {
            menuItem.setAccelerator(ks);
        }
        menuItem.setEnabled(this.isEnabled);
        return menuItem;
    }

    public void setMenuBarData(MenuData newMenuData) {
        MenuBarData newDataCopy;
        MenuBarData oldData = this.menuBarData;
        this.menuBarData = newDataCopy = newMenuData == null ? null : new MenuBarData(this, newMenuData);
        this.firePropertyChanged("MenuBar", oldData, newDataCopy);
    }

    public void setPopupMenuData(MenuData newMenuData) {
        PopupMenuData newDataCopy;
        PopupMenuData oldData = this.popupMenuData;
        this.popupMenuData = newDataCopy = newMenuData == null ? null : new PopupMenuData(this, newMenuData);
        this.firePropertyChanged("PopupMenu", oldData, newDataCopy);
    }

    public void setToolBarData(ToolBarData newToolBarData) {
        ToolBarData newToolBarDataCopy;
        ToolBarData oldData = this.toolBarData;
        this.toolBarData = newToolBarDataCopy = newToolBarData == null ? null : new ToolBarData(this, newToolBarData.getIcon(), newToolBarData.getToolBarGroup(), newToolBarData.getToolBarSubGroup());
        this.firePropertyChanged("ToolBar", oldData, newToolBarDataCopy);
    }

    @Override
    public void setKeyBindingData(KeyBindingData newKeyBindingData) {
        KeyBindingData oldData = this.keyBindingData;
        this.keyBindingData = KeyBindingData.validateKeyBindingData(newKeyBindingData);
        if (this.defaultKeyBindingData == null) {
            this.defaultKeyBindingData = this.keyBindingData;
        }
        this.firePropertyChanged("KeyBindings", oldData, this.keyBindingData);
    }

    @Override
    public void setUnvalidatedKeyBindingData(KeyBindingData newKeyBindingData) {
        KeyBindingData oldData = this.keyBindingData;
        this.keyBindingData = newKeyBindingData;
        this.firePropertyChanged("KeyBindings", oldData, this.keyBindingData);
    }

    void createReservedKeyBinding(KeyStroke keyStroke) {
        KeyBindingData data = KeyBindingData.createReservedKeyBindingData(keyStroke);
        this.setKeyBindingData(data);
    }

    public void setDescription(String newDescription) {
        if (SystemUtilities.isEqual((Object)newDescription, (Object)this.description)) {
            return;
        }
        String oldDescription = this.description;
        this.description = newDescription;
        this.firePropertyChanged("description", oldDescription, newDescription);
    }

    public void dispose() {
        this.propertyListeners.clear();
    }

    public String toString() {
        return this.getName() + "  (" + this.getOwner() + ")";
    }

    @Override
    public String getHelpInfo() {
        String inception;
        KeyStroke keyStroke;
        String filename;
        FileBasedIcon wrapper;
        Icon icon;
        StringBuilder buffer = new StringBuilder();
        buffer.append("   ACTION:    ").append(this.getOwner()).append(" - ").append(this.getName());
        buffer.append('\n');
        if (this.menuBarData != null) {
            buffer.append("        MENU PATH:           ").append(this.menuBarData.getMenuPathAsString());
            buffer.append('\n');
            buffer.append("        MENU GROUP:        ").append(this.menuBarData.getMenuGroup());
            buffer.append('\n');
            icon = this.menuBarData.getMenuIcon();
            if (icon != null && icon instanceof ImageIconWrapper) {
                wrapper = (ImageIconWrapper)icon;
                filename = wrapper.getFilename();
                buffer.append("        MENU ICON:           ").append(filename);
                buffer.append('\n');
            }
        }
        if (this.popupMenuData != null) {
            Icon icon2;
            buffer.append("        POPUP PATH:         ").append(this.popupMenuData.getMenuPathAsString());
            buffer.append('\n');
            buffer.append("        POPUP GROUP:      ").append(this.popupMenuData.getMenuGroup());
            buffer.append('\n');
            String menuSubGroup = this.popupMenuData.getMenuSubGroup();
            if (menuSubGroup != MenuData.NO_SUBGROUP) {
                buffer.append("        POPUP SUB-GROUP:         ").append(menuSubGroup);
                buffer.append('\n');
            }
            if ((icon2 = this.popupMenuData.getMenuIcon()) != null && icon2 instanceof ImageIconWrapper) {
                ImageIconWrapper wrapper2 = (ImageIconWrapper)icon2;
                String filename2 = wrapper2.getFilename();
                buffer.append("        POPUP ICON:         ").append(filename2);
                buffer.append('\n');
            }
        }
        if (this.toolBarData != null) {
            buffer.append("        TOOLBAR GROUP:  ").append(this.toolBarData.getToolBarGroup());
            buffer.append('\n');
            icon = this.toolBarData.getIcon();
            if (icon != null) {
                if (icon instanceof FileBasedIcon) {
                    wrapper = (FileBasedIcon)icon;
                    filename = wrapper.getFilename();
                    buffer.append("        TOOLBAR ICON:     ").append(filename);
                    buffer.append('\n');
                } else if (icon instanceof ImageIcon) {
                    ImageIcon ii = (ImageIcon)icon;
                    String text = ii.getDescription();
                    buffer.append("        TOOLBAR ICON:     ").append(text);
                    buffer.append('\n');
                }
            }
        }
        if ((keyStroke = this.getKeyBinding()) != null) {
            buffer.append("        KEYBINDING:          ").append(keyStroke.toString());
            buffer.append('\n');
        }
        if ((inception = this.getInceptionInformation()) != null) {
            buffer.append("\n    \n");
            buffer.append("   CREATED AT: ").append(inception);
            buffer.append("\n    ");
        } else {
            Msg.debug((Object)this, (Object)"No inception info");
        }
        return buffer.toString();
    }

    public void firePropertyChanged(String propertyName, Object oldValue, Object newValue) {
        PropertyChangeEvent event = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
        for (PropertyChangeListener listener : this.propertyListeners) {
            listener.propertyChange(event);
        }
    }

    @Override
    public Object getHelpObject() {
        return this;
    }

    protected JButton doCreateButton() {
        return new EmptyBorderButton();
    }

    protected JMenuItem doCreateMenuItem() {
        return new DockingMenuItem();
    }

    private void recordInception() {
        if (!SystemUtilities.isInDevelopmentMode()) {
            this.inceptionInformation = "";
            return;
        }
        this.inceptionInformation = this.getInceptionFromTheFirstClassThatIsNotUs();
    }

    private String getInceptionFromTheFirstClassThatIsNotUs() {
        Throwable t = ReflectionUtilities.createThrowableWithStackOlderThan((Class[])new Class[]{this.getClass()});
        StackTraceElement[] trace = t.getStackTrace();
        String classInfo = trace[0].toString();
        return classInfo;
    }
}

