/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.ComponentPlaceholder;
import docking.ComponentProvider;
import docking.DockableComponent;
import docking.DockableHeader;
import docking.DockingWindowManager;
import docking.Node;
import docking.SplitNode;
import docking.WindowNode;
import docking.WindowPosition;
import docking.help.HelpService;
import docking.widgets.OptionDialog;
import docking.widgets.tabbedpane.DockingTabRenderer;
import ghidra.util.HelpLocation;
import ghidra.util.SystemUtilities;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeListener;
import org.jdom.Content;
import org.jdom.Element;

class ComponentNode
extends Node {
    private ComponentPlaceholder top;
    private List<ComponentPlaceholder> windowPlaceholders;
    private JComponent comp;
    private ChangeListener tabbedPaneChangeListener = e -> {
        Component selectedComponent = ((JTabbedPane)this.comp).getSelectedComponent();
        for (ComponentPlaceholder placeholder : this.windowPlaceholders) {
            if (placeholder.getComponent() != selectedComponent) continue;
            this.top = placeholder;
            break;
        }
        SystemUtilities.runSwingLater(() -> {
            if (this.top != null) {
                this.top.requestFocus();
            }
        });
    };

    ComponentNode(DockingWindowManager mgr) {
        super(mgr);
        this.windowPlaceholders = new ArrayList<ComponentPlaceholder>();
    }

    ComponentNode(Element elem, DockingWindowManager mgr, Node parent, List<ComponentPlaceholder> restoredPlaceholders) {
        super(mgr);
        this.parent = parent;
        this.windowPlaceholders = new ArrayList<ComponentPlaceholder>();
        int topIndex = Integer.parseInt(elem.getAttributeValue("TOP_INFO"));
        for (Element e2 : elem.getChildren()) {
            ComponentPlaceholder placeholder;
            String name = e2.getAttributeValue("NAME");
            String owner = e2.getAttributeValue("OWNER");
            String title = e2.getAttributeValue("TITLE");
            String group = e2.getAttributeValue("GROUP");
            if (group == null || group.trim().isEmpty()) {
                group = "Default";
            }
            if (name.length() > 100) {
                name = name.substring(0, 100);
            }
            if (title.length() > 100) {
                title = title.substring(0, 100);
            }
            boolean isActive = Boolean.valueOf(e2.getAttributeValue("ACTIVE"));
            long uniqueID = this.getUniqueID(e2, 0L);
            String mappedOwner = ComponentProvider.getMappedOwner(owner, name);
            if (mappedOwner != null) {
                name = ComponentProvider.getMappedName(owner, name);
                owner = mappedOwner;
            }
            if (this.containsPlaceholder(placeholder = new ComponentPlaceholder(name, owner, group, title, isActive, this, uniqueID))) continue;
            this.windowPlaceholders.add(placeholder);
            restoredPlaceholders.add(placeholder);
        }
        if (topIndex >= 0 && topIndex < this.windowPlaceholders.size()) {
            this.top = this.windowPlaceholders.get(topIndex);
        }
    }

    private boolean containsPlaceholder(ComponentPlaceholder placeholder) {
        String group = placeholder.getGroup();
        if (group == null) {
            group = "";
        }
        String owner = placeholder.getOwner();
        String name = placeholder.getName();
        String title = placeholder.getTitle();
        for (ComponentPlaceholder existingPlaceholder : this.windowPlaceholders) {
            if (!existingPlaceholder.getOwner().equals(owner) || !existingPlaceholder.getName().equals(name) || !existingPlaceholder.getGroup().equals(group) || !existingPlaceholder.getTitle().equals(title)) continue;
            return true;
        }
        return false;
    }

    private long getUniqueID(Element e, long defaultValue) {
        String attributeValue = e.getAttributeValue("INSTANCE_ID");
        if (attributeValue == null) {
            return defaultValue;
        }
        return Long.parseLong(attributeValue);
    }

    @Override
    List<Node> getChildren() {
        return Collections.emptyList();
    }

    public String toString() {
        return this.printTree();
    }

    @Override
    String getDescription() {
        return this.windowPlaceholders.toString();
    }

    void add(ComponentPlaceholder placeholder) {
        this.windowPlaceholders.add(placeholder);
        placeholder.setNode(this);
        if (placeholder.isShowing()) {
            this.top = placeholder;
            this.invalidate();
        }
        WindowNode topLevelNode = this.getTopLevelNode();
        topLevelNode.componentAdded(placeholder);
    }

    void remove(ComponentPlaceholder placeholder) {
        if (this.getTopLevelNode() == null) {
            return;
        }
        if (placeholder.isShowing()) {
            if (this.top == placeholder) {
                this.top = null;
            }
            this.invalidate();
        }
        WindowNode topLevelNode = this.getTopLevelNode();
        topLevelNode.componentRemoved(placeholder);
        this.windowPlaceholders.remove(placeholder);
        placeholder.setNode(null);
        if (this.windowPlaceholders.isEmpty()) {
            this.parent.removeNode(this);
        }
    }

    void remove(ComponentPlaceholder placeholder, boolean keepEmptyPlaceholder) {
        if (placeholder.isShowing()) {
            placeholder.show(false);
            if (this.top == placeholder) {
                this.top = null;
            }
            this.invalidate();
            this.winMgr.scheduleUpdate();
        }
        placeholder.setProvider(null);
        if (!keepEmptyPlaceholder) {
            this.windowPlaceholders.remove(placeholder);
            placeholder.setNode(null);
            if (this.windowPlaceholders.isEmpty()) {
                this.parent.removeNode(this);
            }
        }
    }

    int getComponentCount() {
        return this.windowPlaceholders.size();
    }

    @Override
    void close() {
        ArrayList<ComponentPlaceholder> list = new ArrayList<ComponentPlaceholder>(this.windowPlaceholders);
        for (ComponentPlaceholder placeholder : list) {
            if (!placeholder.isShowing()) continue;
            placeholder.close();
        }
    }

    @Override
    JComponent getComponent() {
        if (!this.invalid) {
            return this.comp;
        }
        if (this.comp instanceof JTabbedPane) {
            ((JTabbedPane)this.comp).removeChangeListener(this.tabbedPaneChangeListener);
            this.comp.removeAll();
        }
        this.comp = null;
        ArrayList<ComponentPlaceholder> activeComponents = new ArrayList<ComponentPlaceholder>();
        this.populateActiveComponents(activeComponents);
        int count = activeComponents.size();
        if (count == 1) {
            this.top = (ComponentPlaceholder)activeComponents.get(0);
            this.comp = this.top.getComponent();
            this.comp.setBorder(BorderFactory.createRaisedBevelBorder());
            this.installRenameMenu(this.top, null);
        } else if (count > 1) {
            JTabbedPane pane = new JTabbedPane(3, 1);
            this.comp = pane;
            int topIndex = 0;
            for (int i = 0; i < count; ++i) {
                ComponentPlaceholder placeholder = (ComponentPlaceholder)activeComponents.get(i);
                DockableComponent c = placeholder.getComponent();
                c.setBorder(BorderFactory.createEmptyBorder());
                String title = placeholder.getTitle();
                String tabText = placeholder.getTabText();
                DockableComponent component = placeholder.getComponent();
                pane.add((Component)component, title);
                DockingTabRenderer tabRenderer = this.createTabRenderer(pane, placeholder, title, tabText, component);
                c.installDragDropTarget(pane);
                pane.setTabComponentAt(i, tabRenderer);
                Icon icon = placeholder.getIcon();
                if (icon != null) {
                    tabRenderer.setIcon(icon);
                }
                if (placeholder != this.top) continue;
                topIndex = i;
            }
            DockableComponent activeComp = (DockableComponent)pane.getComponentAt(topIndex);
            this.top = activeComp.getComponentWindowingPlaceholder();
            pane.setSelectedComponent(activeComp);
            pane.addChangeListener(this.tabbedPaneChangeListener);
        }
        this.invalid = false;
        return this.comp;
    }

    private DockingTabRenderer createTabRenderer(JTabbedPane pane, ComponentPlaceholder placeholder, String title, String tabText, DockableComponent component) {
        DockingTabRenderer tabRenderer = new DockingTabRenderer(pane, title, tabText, e -> this.closeTab(component));
        this.installRenameMenu(placeholder, tabRenderer);
        return tabRenderer;
    }

    private void installRenameMenu(ComponentPlaceholder placeholder, DockingTabRenderer tabRenderer) {
        ComponentProvider provider = placeholder.getProvider();
        if (!provider.isTransient()) {
            return;
        }
        RenameMouseListener listener = new RenameMouseListener(placeholder);
        DockableComponent dockableComponent = placeholder.getComponent();
        DockableHeader header = dockableComponent.getHeader();
        header.installRenameAction(listener);
        if (tabRenderer != null) {
            tabRenderer.installRenameAction(listener);
        }
    }

    @Override
    void populateActiveComponents(List<ComponentPlaceholder> list) {
        for (ComponentPlaceholder placeholder : this.windowPlaceholders) {
            if (!placeholder.isShowing()) continue;
            list.add(placeholder);
        }
    }

    @Override
    void removeNode(Node node) {
        throw new UnsupportedOperationException();
    }

    @Override
    void replaceNode(Node oldNode, Node newNode) {
    }

    void split(ComponentPlaceholder source, WindowPosition dropCode) {
        SplitNode splitNode;
        ComponentNode sourceNode = new ComponentNode(this.winMgr);
        source.setNode(sourceNode);
        Node parentNode = this.parent;
        switch (dropCode) {
            case LEFT: {
                splitNode = new SplitNode(this.winMgr, sourceNode, (Node)this, true);
                break;
            }
            case RIGHT: {
                splitNode = new SplitNode(this.winMgr, this, (Node)sourceNode, true);
                break;
            }
            case TOP: {
                splitNode = new SplitNode(this.winMgr, sourceNode, (Node)this, false);
                break;
            }
            case BOTTOM: {
                splitNode = new SplitNode(this.winMgr, this, (Node)sourceNode, false);
                break;
            }
            default: {
                splitNode = new SplitNode(this.winMgr, this, (Node)sourceNode, true);
            }
        }
        parentNode.replaceNode(this, splitNode);
        sourceNode.add(source);
    }

    boolean isStacked() {
        return this.comp instanceof JTabbedPane;
    }

    public void makeSelectedTab(ComponentPlaceholder placeholder) {
        JTabbedPane tab;
        if (this.invalid) {
            return;
        }
        if (!(this.comp instanceof JTabbedPane)) {
            return;
        }
        DockableComponent dc = placeholder.getComponent();
        if (dc != null && (tab = (JTabbedPane)this.comp).getSelectedComponent() != dc) {
            tab.setSelectedComponent(dc);
        }
    }

    @Override
    Element saveToXML() {
        Element root = new Element("COMPONENT_NODE");
        int topIndex = 0;
        if (this.top != null) {
            for (int i = 0; i < this.windowPlaceholders.size(); ++i) {
                ComponentPlaceholder placeholder = this.windowPlaceholders.get(i);
                if (placeholder != this.top) continue;
                topIndex = i;
                break;
            }
        }
        root.setAttribute("TOP_INFO", "" + topIndex);
        for (ComponentPlaceholder placeholder : this.windowPlaceholders) {
            Element elem = new Element("COMPONENT_INFO");
            elem.setAttribute("NAME", placeholder.getName());
            elem.setAttribute("OWNER", placeholder.getOwner());
            elem.setAttribute("TITLE", placeholder.getTitle());
            elem.setAttribute("ACTIVE", "" + placeholder.isShowing());
            elem.setAttribute("GROUP", placeholder.getGroup());
            elem.setAttribute("INSTANCE_ID", Long.toString(placeholder.getInstanceID()));
            root.addContent((Content)elem);
        }
        return root;
    }

    @Override
    boolean contains(ComponentPlaceholder placeholder) {
        for (ComponentPlaceholder ph : this.windowPlaceholders) {
            if (!ph.isShowing() || !ph.equals(placeholder)) continue;
            return true;
        }
        return false;
    }

    void titleChanged(ComponentPlaceholder placeholder) {
        if (!(this.comp instanceof JTabbedPane)) {
            return;
        }
        JTabbedPane pane = (JTabbedPane)this.comp;
        int index = pane.indexOfComponent(placeholder.getComponent());
        if (index == -1) {
            return;
        }
        DockingTabRenderer renderer = (DockingTabRenderer)pane.getTabComponentAt(index);
        renderer.setIcon(placeholder.getIcon());
        String tabText = placeholder.getTabText();
        String fullTitle = placeholder.getTitle();
        renderer.setTitle(tabText, fullTitle);
    }

    public void iconChanged(ComponentPlaceholder placeholder) {
        if (!(this.comp instanceof JTabbedPane)) {
            return;
        }
        JTabbedPane pane = (JTabbedPane)this.comp;
        int index = pane.indexOfComponent(placeholder.getComponent());
        if (index == -1) {
            return;
        }
        DockingTabRenderer renderer = (DockingTabRenderer)pane.getTabComponentAt(index);
        renderer.setIcon(placeholder.getIcon());
        pane.setIconAt(index, placeholder.getIcon());
    }

    private void closeTab(Component tabComponent) {
        if (!(this.comp instanceof JTabbedPane)) {
            return;
        }
        ComponentPlaceholder placeholder = this.getPlaceHolderForComponent(tabComponent);
        if (placeholder != null) {
            placeholder.close();
        }
    }

    private ComponentPlaceholder getPlaceHolderForComponent(Component component) {
        for (ComponentPlaceholder placeholder : this.windowPlaceholders) {
            if (component != placeholder.getComponent()) continue;
            return placeholder;
        }
        return null;
    }

    @Override
    WindowNode getTopLevelNode() {
        if (this.parent != null) {
            return this.parent.getTopLevelNode();
        }
        return null;
    }

    @Override
    void dispose() {
        if (this.top != null) {
            this.top.dispose();
        }
    }

    private static class RenameMouseListener
    extends MouseAdapter {
        private static final HelpLocation RENAME_HELP = new HelpLocation("DockingWindows", "Renaming_Windows");
        private ComponentPlaceholder placeholder;

        RenameMouseListener(ComponentPlaceholder placeholder) {
            this.placeholder = placeholder;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            JMenuItem menuItem = new JMenuItem("Rename");
            menuItem.addActionListener(new RenameActionListener());
            HelpService helpService = DockingWindowManager.getHelpService();
            helpService.registerHelp(menuItem, RENAME_HELP);
            JPopupMenu menu = new JPopupMenu();
            menu.add(menuItem);
            menu.show(e.getComponent(), e.getX(), e.getY());
        }

        private class RenameActionListener
        implements ActionListener {
            private RenameActionListener() {
            }

            @Override
            public void actionPerformed(ActionEvent event) {
                String currentTabText;
                ComponentProvider provider = RenameMouseListener.this.placeholder.getProvider();
                JComponent component = provider.getComponent();
                String newName = OptionDialog.showInputSingleLineDialog(component, "Rename Tab", "New name:", currentTabText = provider.getTabText());
                if (newName == null || newName.isEmpty()) {
                    return;
                }
                provider.setTitle(newName);
                provider.setSubTitle("");
                provider.setTabText(newName);
                RenameMouseListener.this.placeholder.update();
            }
        }
    }
}

