/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.task.gui;

import ghidra.framework.task.GTaskManager;
import ghidra.framework.task.GTaskResult;
import ghidra.framework.task.gui.CompletedTaskListModel;
import ghidra.framework.task.gui.GTaskResultInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import resources.Icons;
import resources.ResourceManager;

public class GTaskResultPanel
extends JPanel {
    private JList jList;
    private CompletedTaskListModel model;

    public GTaskResultPanel(GTaskManager taskMgr) {
        super(new BorderLayout());
        this.model = new CompletedTaskListModel(taskMgr);
        this.jList = new JList<GTaskResultInfo>(this.model);
        this.jList.setCellRenderer(new GTaskResultCellRenderer());
        JScrollPane scroll = new JScrollPane(this.jList);
        this.add(scroll);
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
    }

    static class GTaskResultCellRenderer
    extends DefaultListCellRenderer {
        private static final Icon CANCELLED_ICON = ResourceManager.loadImage((String)"images/dialog-cancel.png");
        private static final Icon EXCEPTION_ICON = Icons.ERROR_ICON;
        private static final Icon COMPLETED_ICON = ResourceManager.loadImage((String)"images/checkmark_green.gif");

        GTaskResultCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            GTaskResultInfo element = (GTaskResultInfo)value;
            GTaskResult result = element.getResult();
            this.setText(value.toString());
            this.setIcon(this.getIcon(result));
            this.setBackground(Color.white);
            return this;
        }

        private Icon getIcon(GTaskResult result) {
            if (result == null) {
                return null;
            }
            if (result.wasCancelled()) {
                return CANCELLED_ICON;
            }
            if (result.getException() != null) {
                return EXCEPTION_ICON;
            }
            return COMPLETED_ICON;
        }
    }
}

