/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.plugintool.mgr;

import docking.widgets.OptionDialog;
import docking.widgets.filechooser.GhidraFileChooser;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.dialog.SaveToolConfigDialog;
import ghidra.framework.preferences.Preferences;
import ghidra.util.Msg;
import ghidra.util.filechooser.GhidraFileChooserModel;
import ghidra.util.filechooser.GhidraFileFilter;
import java.awt.Component;
import java.io.File;
import java.io.IOException;

public class DialogManager {
    private PluginTool tool;
    private SaveToolConfigDialog saveToolDialog;
    private GhidraFileChooser ghidraFileChooser;

    public DialogManager(PluginTool tool) {
        this.tool = tool;
    }

    public boolean saveToolAs() {
        if (this.saveToolDialog == null) {
            this.saveToolDialog = new SaveToolConfigDialog(this.tool, this.tool.getToolServices());
        }
        this.saveToolDialog.show(this.tool.getName(), this.tool.getToolName());
        return !this.saveToolDialog.didCancel();
    }

    public void exportTool() {
        GhidraFileChooser fileChooser = this.getFileChooser();
        File exportFile = null;
        while (exportFile == null) {
            int result;
            exportFile = fileChooser.getSelectedFile();
            if (exportFile == null) {
                return;
            }
            Preferences.setProperty((String)"LastToolExportDirectory", (String)exportFile.getParent());
            if (!exportFile.getName().endsWith(".tool")) {
                exportFile = new File(exportFile.getAbsolutePath() + ".tool");
            }
            if (!exportFile.exists() || (result = OptionDialog.showOptionDialog((Component)this.tool.getToolFrame(), (String)"Overwrite?", (String)("Overwrite existing file, " + exportFile.getName() + "?"), (String)"Overwrite", (int)3)) == 1) continue;
            exportFile = null;
        }
        try {
            this.tool.getProject().getToolServices().exportTool(exportFile, this.tool);
            Msg.info((Object)this, (Object)("Successfully exported " + this.tool.getName() + " to " + exportFile.getAbsolutePath()));
        }
        catch (IOException e) {
            Msg.showError((Object)this, (Component)this.tool.getToolFrame(), (String)"Error Exporting Tool", (Object)("Error exporting tool: " + e.getMessage()), (Throwable)e);
        }
        catch (Exception e) {
            Msg.showError((Object)this, null, (String)"Error", (Object)"Error exporting tool tool", (Throwable)e);
        }
    }

    private GhidraFileChooser getFileChooser() {
        if (this.ghidraFileChooser != null) {
            return this.ghidraFileChooser;
        }
        GhidraFileChooser newFileChooser = new GhidraFileChooser((Component)this.tool.getToolFrame());
        newFileChooser.setFileFilter(new GhidraFileFilter(){

            public boolean accept(File file, GhidraFileChooserModel model) {
                if (file == null) {
                    return false;
                }
                if (file.isDirectory()) {
                    return true;
                }
                return file.getAbsolutePath().toLowerCase().endsWith("tool");
            }

            public String getDescription() {
                return "Tools";
            }
        });
        String exportDir = Preferences.getProperty((String)"LastToolExportDirectory");
        if (exportDir != null) {
            newFileChooser.setCurrentDirectory(new File(exportDir));
        }
        newFileChooser.setTitle("Export Tool");
        newFileChooser.setApproveButtonText("Export");
        return newFileChooser;
    }
}

