/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.projectdata.actions;

import docking.action.MenuData;
import docking.action.ToolBarData;
import ghidra.framework.client.ClientUtil;
import ghidra.framework.client.RepositoryAdapter;
import ghidra.framework.main.datatable.DomainFileProvider;
import ghidra.framework.main.datatree.UndoActionDialog;
import ghidra.framework.main.projectdata.actions.VersionControlAction;
import ghidra.framework.model.DomainFile;
import ghidra.framework.plugintool.Plugin;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.ResourceManager;

public class VersionControlUndoCheckOutAction
extends VersionControlAction {
    public VersionControlUndoCheckOutAction(Plugin plugin) {
        super("UndoCheckOut", plugin.getName(), plugin.getTool());
        ImageIcon icon = ResourceManager.loadImage((String)"images/vcUndoCheckOut.png");
        this.setPopupMenuData(new MenuData(new String[]{"Undo Checkout"}, (Icon)icon, "Repository"));
        this.setToolBarData(new ToolBarData((Icon)icon, "Repository"));
        this.setDescription("Undo checkout");
        this.setEnabled(false);
    }

    @Override
    public void actionPerformed(DomainFileProvider context) {
        this.undoCheckOut(context.getSelectedFiles());
    }

    @Override
    public boolean isEnabledForContext(DomainFileProvider context) {
        List<DomainFile> domainFiles = context.getSelectedFiles();
        for (DomainFile domainFile : domainFiles) {
            if (!domainFile.isCheckedOut()) continue;
            return true;
        }
        return false;
    }

    private void undoCheckOut(List<DomainFile> domainFiles) {
        if (!this.checkRepositoryConnected()) {
            return;
        }
        ArrayList<DomainFile> unmodifiedCheckOutsList = new ArrayList<DomainFile>();
        ArrayList<DomainFile> modifiedCheckOutsList = new ArrayList<DomainFile>();
        for (DomainFile domainFile : domainFiles) {
            if (!domainFile.isCheckedOut()) continue;
            if (domainFile.modifiedSinceCheckout()) {
                modifiedCheckOutsList.add(domainFile);
                continue;
            }
            unmodifiedCheckOutsList.add(domainFile);
        }
        this.undoCheckOuts(unmodifiedCheckOutsList, modifiedCheckOutsList);
    }

    private void undoCheckOuts(List<DomainFile> unmodifiedCheckOutsList, List<DomainFile> modifiedCheckOutsList) {
        boolean saveCopy = false;
        DomainFile[] files = new DomainFile[]{};
        boolean undoWasCancelled = false;
        if (modifiedCheckOutsList.size() > 0) {
            UndoActionDialog dialog = new UndoActionDialog("Confirm Undo Checkout", ResourceManager.loadImage((String)"images/vcUndoCheckOut.png"), "UndoCheckOut", "checkout", modifiedCheckOutsList);
            int actionID = dialog.showDialog(this.tool);
            if (actionID != 1) {
                saveCopy = dialog.saveCopy();
                files = dialog.getSelectedDomainFiles();
            } else {
                undoWasCancelled = true;
            }
        }
        if (unmodifiedCheckOutsList.size() > 0 || files.length > 0) {
            this.tool.execute(new UndoCheckOutTask(unmodifiedCheckOutsList, files, saveCopy));
        }
        if (undoWasCancelled) {
            this.tool.setStatusInfo("Undo check out was canceled");
        }
    }

    private class UndoCheckOutTask
    extends Task {
        private List<DomainFile> unmodifiedCheckOutsList;
        private DomainFile[] modifiedCheckedOutFiles;
        private boolean saveCopy;

        UndoCheckOutTask(List<DomainFile> unmodifiedCheckOutsList, DomainFile[] modifiedCheckedOutFiles, boolean saveCopy) {
            super("Undo Check Out", true, true, true);
            this.unmodifiedCheckOutsList = unmodifiedCheckOutsList;
            this.modifiedCheckedOutFiles = modifiedCheckedOutFiles;
            this.saveCopy = saveCopy;
        }

        public void run(TaskMonitor monitor) {
            try {
                for (int i = 0; i < this.unmodifiedCheckOutsList.size(); ++i) {
                    DomainFile df = this.unmodifiedCheckOutsList.get(i);
                    if (!df.isCheckedOut()) continue;
                    df.undoCheckout(false);
                }
                for (DomainFile currentDF : this.modifiedCheckedOutFiles) {
                    monitor.checkCanceled();
                    monitor.setMessage("Undoing Check Out " + currentDF.getName());
                    currentDF.undoCheckout(this.saveCopy);
                }
            }
            catch (CancelledException e) {
                VersionControlUndoCheckOutAction.this.tool.setStatusInfo("Undo check out was canceled");
            }
            catch (IOException e) {
                ClientUtil.handleException((RepositoryAdapter)VersionControlUndoCheckOutAction.this.repository, (Exception)e, (String)"Undo Check Out", (Component)VersionControlUndoCheckOutAction.this.tool.getToolFrame());
            }
        }
    }
}

