/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.projectdata.actions;

import docking.DialogComponentProvider;
import docking.action.MenuData;
import ghidra.framework.main.datatable.DomainFileProvider;
import ghidra.framework.main.datatree.VersionHistoryDialog;
import ghidra.framework.main.projectdata.actions.VersionControlAction;
import ghidra.framework.model.DomainFile;
import ghidra.framework.plugintool.Plugin;
import java.util.List;

public class VersionControlShowHistoryAction
extends VersionControlAction {
    private VersionHistoryDialog dialog;

    public VersionControlShowHistoryAction(Plugin plugin) {
        super("Show History", plugin.getName(), plugin.getTool());
        String[] menuItemName = new String[]{"Show History..."};
        this.setPopupMenuData(new MenuData(menuItemName, null, "Repository"));
        this.setDescription("Show version history");
        this.setEnabled(false);
    }

    @Override
    public void actionPerformed(DomainFileProvider context) {
        this.showHistory(context.getSelectedFiles());
    }

    @Override
    public boolean isEnabledForContext(DomainFileProvider context) {
        List<DomainFile> domainFiles = context.getSelectedFiles();
        if (domainFiles.size() != 1) {
            return false;
        }
        DomainFile domainFile = domainFiles.get(0);
        return domainFile.isVersioned();
    }

    private void showHistory(List<DomainFile> domainFiles) {
        if (!this.checkRepositoryConnected()) {
            return;
        }
        if (domainFiles.size() != 1) {
            return;
        }
        if (this.dialog == null) {
            this.dialog = new VersionHistoryDialog();
        }
        this.dialog.setDomainFile(domainFiles.get(0));
        this.tool.showDialog((DialogComponentProvider)this.dialog, this.tool.getToolFrame());
    }
}

