/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.logviewer.ui;

import ghidra.framework.main.logviewer.event.FVEvent;
import ghidra.framework.main.logviewer.event.FVEventListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class ReloadDialog
extends JDialog {
    boolean showUpdateWarning = true;
    private FVEventListener eventListener;

    public ReloadDialog(FVEventListener eventListener) {
        this.eventListener = eventListener;
        Object[] options = new Object[]{this.createContent()};
        JOptionPane optionPane = new JOptionPane("File has changed. Reload?", 2, 0, null, options);
        this.setContentPane(optionPane);
        this.pack();
        this.setResizable(false);
        this.setDefaultCloseOperation(1);
    }

    private JPanel createContent() {
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout());
        JPanel buttonPanel = new JPanel();
        JButton yesBtn = new JButton("Yes");
        JButton noBtn = new JButton("No");
        buttonPanel.add(yesBtn);
        buttonPanel.add(noBtn);
        contentPane.add((Component)buttonPanel, "Center");
        final JCheckBox checkbox = new JCheckBox("Do not show this message again.");
        contentPane.add((Component)checkbox, "South");
        yesBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FVEvent reloadEvt = new FVEvent(FVEvent.EventType.RELOAD_FILE, null);
                ReloadDialog.this.eventListener.send(reloadEvt);
                ReloadDialog.this.setVisible(false);
                ReloadDialog.this.showUpdateWarning = !checkbox.isSelected();
            }
        });
        noBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReloadDialog.this.setVisible(false);
                ReloadDialog.this.showUpdateWarning = !checkbox.isSelected();
            }
        });
        return contentPane;
    }

    @Override
    public void setVisible(boolean visible) {
        if (!this.showUpdateWarning) {
            return;
        }
        super.setVisible(visible);
    }
}

