/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main;

import docking.DialogComponentProvider;
import ghidra.framework.client.ClientUtil;
import ghidra.framework.client.NotConnectedException;
import ghidra.framework.client.RepositoryServerAdapter;
import ghidra.framework.main.FrontEndTool;
import ghidra.framework.main.ServerInfoComponent;
import ghidra.framework.model.ServerInfo;
import ghidra.framework.protocol.ghidra.GhidraURL;
import ghidra.util.MessageType;
import ghidra.util.Msg;
import ghidra.util.StatusListener;
import ghidra.util.layout.MiddleLayout;
import ghidra.util.layout.PairLayout;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputAdapter;
import resources.ResourceManager;

class RepositoryChooser
extends DialogComponentProvider {
    static final Icon REFRESH_ICON = ResourceManager.loadImage((String)"images/view-refresh.png");
    private static final String SERVER_INFO = "ServerInfo";
    private static final String GHIDRA_URL = "GhidraURL";
    private JRadioButton serverInfoChoice;
    private JRadioButton urlChoice;
    private JPanel cardPanel;
    private CardLayout cardLayout;
    private ServerInfoComponent serverInfoComponent;
    private JButton queryButton;
    private JList<String> nameList;
    private DefaultListModel<String> listModel;
    private JTextField urlTextField;
    private boolean okPressed;

    RepositoryChooser(String title) {
        super(title);
        this.setRememberLocation(false);
        this.buildMainPanel();
    }

    private JPanel buildServerInfoPanel() {
        JPanel serverInfoPanel = new JPanel(new BorderLayout(10, 10));
        JPanel topPanel = new JPanel(new BorderLayout(10, 10));
        this.serverInfoComponent = new ServerInfoComponent();
        this.serverInfoComponent.setStatusListener((StatusListener)this);
        this.serverInfoComponent.setChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RepositoryChooser.this.serverInfoChanged();
            }
        });
        topPanel.add((Component)this.serverInfoComponent, "Center");
        this.queryButton = new JButton(REFRESH_ICON);
        this.queryButton.setToolTipText("Refresh Repository Names List");
        this.setDefaultButton(this.queryButton);
        this.queryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RepositoryChooser.this.queryServer();
            }
        });
        JPanel buttonPanel = new JPanel((LayoutManager)new MiddleLayout());
        buttonPanel.add(this.queryButton);
        topPanel.add((Component)buttonPanel, "East");
        serverInfoPanel.add((Component)topPanel, "North");
        JPanel lowerPanel = new JPanel(new BorderLayout());
        JLabel label = new JLabel("Repository Names", 2);
        label.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 5));
        lowerPanel.add((Component)label, "North");
        this.listModel = new DefaultListModel();
        this.nameList = new JList<String>(this.listModel);
        this.nameList.setSelectionMode(0);
        this.nameList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                RepositoryChooser.this.selectionChanged();
            }
        });
        this.nameList.addMouseListener(new MouseInputAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() != 1 || e.getClickCount() != 2) {
                    return;
                }
                if (RepositoryChooser.this.nameList.getSelectedValue() != null) {
                    e.consume();
                    RepositoryChooser.this.okCallback();
                }
            }
        });
        JScrollPane sp = new JScrollPane(this.nameList);
        lowerPanel.add(sp);
        serverInfoPanel.add((Component)lowerPanel, "Center");
        return serverInfoPanel;
    }

    private JPanel buildURLPanel() {
        JPanel urlPanel = new JPanel(new BorderLayout(10, 10));
        this.urlTextField = new JTextField("ghidra:");
        JPanel panel = new JPanel((LayoutManager)new PairLayout());
        panel.add(new JLabel("URL:"));
        panel.add(this.urlTextField);
        urlPanel.add((Component)panel, "North");
        return urlPanel;
    }

    private void choiceActivated(JRadioButton choiceButton) {
        if (choiceButton == this.urlChoice) {
            this.cardLayout.show(this.cardPanel, GHIDRA_URL);
        } else {
            this.cardLayout.show(this.cardPanel, SERVER_INFO);
        }
        this.cardPanel.requestFocus();
        this.choiceChanged();
    }

    private void choiceChanged() {
        this.setStatusText("");
        if (this.urlChoice.isSelected()) {
            this.urlInfoChanged();
        } else {
            this.serverInfoChanged();
        }
    }

    private void buildMainPanel() {
        JPanel panel = new JPanel(new BorderLayout(10, 10));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel radioButtonPanel = new JPanel((LayoutManager)new PairLayout(5, 5));
        radioButtonPanel.setBorder(BorderFactory.createTitledBorder("Repository Specification"));
        ChangeListener choiceListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JRadioButton choiceButton;
                Object src = e.getSource();
                if (src instanceof JRadioButton && (choiceButton = (JRadioButton)src).isSelected()) {
                    RepositoryChooser.this.choiceActivated(choiceButton);
                }
            }
        };
        this.serverInfoChoice = new JRadioButton("Ghidra Server");
        this.serverInfoChoice.setSelected(true);
        this.serverInfoChoice.addChangeListener(choiceListener);
        radioButtonPanel.add(this.serverInfoChoice);
        this.urlChoice = new JRadioButton("Ghidra URL");
        this.urlChoice.addChangeListener(choiceListener);
        radioButtonPanel.add(this.urlChoice);
        ButtonGroup panelChoices = new ButtonGroup();
        panelChoices.add(this.serverInfoChoice);
        panelChoices.add(this.urlChoice);
        panel.add((Component)radioButtonPanel, "North");
        this.cardLayout = new CardLayout();
        this.cardPanel = new JPanel(this.cardLayout);
        this.cardPanel.add((Component)this.buildServerInfoPanel(), SERVER_INFO);
        this.cardPanel.add((Component)this.buildURLPanel(), GHIDRA_URL);
        panel.add((Component)this.cardPanel, "Center");
        this.cardLayout.show(this.cardPanel, SERVER_INFO);
        this.addWorkPanel(panel);
        this.addCancelButton();
        this.addOKButton();
        this.setOkButtonText("Select Repository");
        this.setOkEnabled(false);
    }

    private void selectionChanged() {
        String name = this.nameList.getSelectedValue();
        this.setOkEnabled(name != null);
    }

    private void queryServer() {
        this.listModel.clear();
        RepositoryServerAdapter repositoryServer = ClientUtil.getRepositoryServer((String)this.serverInfoComponent.getServerName(), (int)this.serverInfoComponent.getPortNumber(), (boolean)true);
        if (repositoryServer == null) {
            return;
        }
        try {
            for (String name : repositoryServer.getRepositoryNames()) {
                this.listModel.addElement(name);
            }
        }
        catch (NotConnectedException e) {
            return;
        }
        catch (IOException e) {
            Msg.showError((Object)((Object)this), null, (String)"Server Error", (Object)("Failed to query list of repositories: " + e.getMessage()));
        }
        if (this.listModel.size() == 0) {
            this.setStatusText("No repositories found");
        }
    }

    private void urlInfoChanged() {
        this.setStatusText("");
        this.setOkEnabled(false);
        try {
            URL url = new URL(this.urlTextField.getText());
            if (!"ghidra".equals(url.getProtocol())) {
                this.setStatusText("URL must specify 'ghidra:' protocol", MessageType.ERROR);
            } else {
                this.setOkEnabled(true);
            }
        }
        catch (MalformedURLException e) {
            this.setStatusText(e.getMessage(), MessageType.ERROR);
        }
    }

    private void serverInfoChanged() {
        this.setStatusText("");
        this.setOkEnabled(false);
        this.listModel.clear();
        this.queryButton.setEnabled(this.serverInfoComponent.isValidInformation());
    }

    URL getSelectedRepository(FrontEndTool tool, URL initURL) {
        this.init(initURL);
        tool.showDialog((DialogComponentProvider)this, tool.getToolFrame());
        if (!this.okPressed) {
            return null;
        }
        if (this.serverInfoChoice.isSelected()) {
            return GhidraURL.makeURL(this.serverInfoComponent.getServerName(), this.serverInfoComponent.getPortNumber(), this.nameList.getSelectedValue());
        }
        try {
            return new URL(this.urlTextField.getText());
        }
        catch (MalformedURLException e) {
            Msg.error((Object)((Object)this), (Object)e.getMessage());
            return null;
        }
    }

    protected void okCallback() {
        if (this.serverInfoChoice.isSelected()) {
            if (this.nameList.getSelectedValue() != null) {
                this.okPressed = true;
                this.close();
            }
        } else {
            this.okPressed = true;
            this.close();
        }
    }

    private void init(URL initURL) {
        this.okPressed = false;
        if (initURL != null) {
            String ghidraProtocol;
            String url = initURL.toExternalForm();
            if (url.startsWith(ghidraProtocol = "ghidra:")) {
                if (!url.startsWith(ghidraProtocol + "//")) {
                    this.urlTextField.setText(url);
                    this.urlChoice.setSelected(true);
                    return;
                }
            } else {
                initURL = null;
            }
        }
        ServerInfo serverInfo = null;
        if (initURL != null) {
            String host = initURL.getHost();
            int port = initURL.getPort();
            if (port <= 0) {
                port = 13100;
            }
            serverInfo = new ServerInfo(host, port);
        }
        this.serverInfoComponent.setServerInfo(serverInfo);
        this.serverInfoChoice.setSelected(true);
    }
}

