/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.stringable.deprecated;

import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.LocalVariableImpl;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.InvalidInputException;
import java.util.StringTokenizer;

public class LocalVariableInfo
extends LocalVariableImpl {
    static LocalVariableInfo createLocalVariableInfo(Variable localVariable) {
        try {
            LocalVariableInfo localVarInfo = new LocalVariableInfo(localVariable.getName(), localVariable.getFirstUseOffset(), localVariable.getDataType(), localVariable.getVariableStorage(), localVariable.getProgram(), localVariable.getSource());
            localVarInfo.setComment(localVariable.getComment());
            return localVarInfo;
        }
        catch (InvalidInputException e) {
            throw new AssertException("Failed to clone local variable: " + localVariable.getFunction().getName() + ":" + localVariable.getName());
        }
    }

    static LocalVariableInfo createLocalVariableInfo(String localVariableInfoString, Program program) {
        try {
            StringTokenizer tokenizer = new StringTokenizer(localVariableInfoString, "\t");
            tokenizer.nextToken();
            long managerUniversalID = Long.parseLong(tokenizer.nextToken());
            long dataTypeID = Long.parseLong(tokenizer.nextToken());
            String dataTypeName = tokenizer.nextToken();
            DataType dt = LocalVariableInfo.getDataType(program, managerUniversalID, dataTypeID);
            if (dt == null || !dt.getName().equals(dataTypeName)) {
                throw new AssertException("Data type name/ID mismatch " + dt.getName() + " doesn't match " + dataTypeName + ".");
            }
            int firstUseOffset = Integer.parseInt(tokenizer.nextToken());
            String localVariableName = tokenizer.nextToken();
            SourceType sourceType = SourceType.valueOf((String)tokenizer.nextToken());
            String comment = tokenizer.nextToken();
            VariableStorage storage = VariableStorage.deserialize((Program)program, (String)tokenizer.nextToken());
            LocalVariableInfo localVarInfo = new LocalVariableInfo(localVariableName, firstUseOffset, dt, storage, program, sourceType);
            localVarInfo.setComment(comment);
            return localVarInfo;
        }
        catch (Exception e) {
            throw new AssertException("Failed to deserialize local variable (" + localVariableInfoString + "): " + e.getMessage());
        }
    }

    private static DataType getDataType(Program program, long managerUniversalID, long dataTypeID) {
        DataTypeManager dataTypeManager = program.getDataTypeManager();
        long actualUniversalID = dataTypeManager.getUniversalID().getValue();
        if (actualUniversalID != managerUniversalID) {
            throw new AssertException("Provided data type manager ID of " + actualUniversalID + " doesn't matched saved ID of " + managerUniversalID + ".");
        }
        return dataTypeManager.getDataType(dataTypeID);
    }

    LocalVariableInfo(String name, int firstUseOffset, DataType dataType, VariableStorage storage, Program program, SourceType sourceType) throws InvalidInputException {
        super(name, firstUseOffset, dataType, storage, true, program, sourceType);
    }

    String convertToString() {
        DataTypeManager dataTypeMananger = this.getProgram().getDataTypeManager();
        DataType dt = this.getDataType();
        StringBuffer buffy = new StringBuffer();
        buffy.append(((Object)((Object)this)).getClass().getSimpleName()).append("\t");
        buffy.append(Long.toString(dataTypeMananger.getUniversalID().getValue())).append("\t");
        buffy.append(Long.toString(dataTypeMananger.getID(dt))).append("\t");
        buffy.append(dt.getName()).append("\t");
        buffy.append(Integer.toString(this.getFirstUseOffset())).append("\t");
        buffy.append(this.getName()).append("\t");
        buffy.append(this.getSource().name()).append("\t");
        buffy.append(this.getComment()).append("\t");
        buffy.append(this.getVariableStorage().getSerializationString());
        return buffy.toString();
    }

    public Variable createLocalVariable(Function destFunction, Address destinationStorageAddress) {
        try {
            long offset = destinationStorageAddress.subtract(destFunction.getEntryPoint());
            MyLocalVariable var = new MyLocalVariable(this.getName(), (int)offset, this.getDataType(), this.getVariableStorage().getSerializationString(), destFunction.getProgram(), this.getSource());
            var.setComment(this.getComment());
            return var;
        }
        catch (InvalidInputException e) {
            Msg.error((Object)((Object)this), (Object)("Unable to apply local variable '" + this.getName() + "' to function " + destFunction.getName() + ": " + e.getMessage()));
            return null;
        }
    }

    private static class MyLocalVariable
    extends LocalVariableImpl {
        MyLocalVariable(String name, int firstUseOffset, DataType dataType, String serializedStorage, Program program, SourceType sourceType) throws InvalidInputException {
            super(name, firstUseOffset, dataType, VariableStorage.deserialize((Program)program, (String)serializedStorage), true, program, sourceType);
        }
    }
}

