/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Format;

import org.jf.dexlib.Code.Format.Format;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.LiteralInstruction;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.Code.TwoRegisterInstruction;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Util.AnnotatedOutput;

public class Instruction22b
extends Instruction
implements TwoRegisterInstruction,
LiteralInstruction {
    public static final Instruction.InstructionFactory Factory = new Factory();
    private byte regA;
    private byte regB;
    private byte litC;

    public Instruction22b(Opcode opcode, short regA, short regB, byte litC) {
        super(opcode);
        if (regA >= 256 || regB >= 256) {
            throw new RuntimeException("The register number must be less than v256");
        }
        this.regA = (byte)regA;
        this.regB = (byte)regB;
        this.litC = litC;
    }

    private Instruction22b(Opcode opcode, byte[] buffer, int bufferIndex) {
        super(opcode);
        this.regA = buffer[bufferIndex + 1];
        this.regB = buffer[bufferIndex + 2];
        this.litC = buffer[bufferIndex + 3];
    }

    @Override
    protected void writeInstruction(AnnotatedOutput out, int currentCodeAddress) {
        out.writeByte(this.opcode.value);
        out.writeByte(this.regA);
        out.writeByte(this.regB);
        out.writeByte(this.litC);
    }

    @Override
    public Format getFormat() {
        return Format.Format22b;
    }

    @Override
    public int getRegisterA() {
        return this.regA & 0xFF;
    }

    @Override
    public int getRegisterB() {
        return this.regB & 0xFF;
    }

    @Override
    public long getLiteral() {
        return this.litC;
    }

    private static class Factory
    implements Instruction.InstructionFactory {
        private Factory() {
        }

        @Override
        public Instruction makeInstruction(DexFile dexFile, Opcode opcode, byte[] buffer, int bufferIndex) {
            return new Instruction22b(opcode, buffer, bufferIndex);
        }
    }
}

