/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.parser;

import java.nio.ByteBuffer;
import org.eclipse.jetty.spdy.api.Settings;
import org.eclipse.jetty.spdy.frames.SettingsFrame;
import org.eclipse.jetty.spdy.parser.ControlFrameBodyParser;
import org.eclipse.jetty.spdy.parser.ControlFrameParser;

public class SettingsBodyParser
extends ControlFrameBodyParser {
    private final Settings settings = new Settings();
    private final ControlFrameParser controlFrameParser;
    private State state = State.COUNT;
    private int cursor;
    private int count;
    private int idAndFlags;
    private int value;

    public SettingsBodyParser(ControlFrameParser controlFrameParser) {
        this.controlFrameParser = controlFrameParser;
    }

    @Override
    public boolean parse(ByteBuffer buffer) {
        block8: while (buffer.hasRemaining()) {
            switch (this.state) {
                case COUNT: {
                    if (buffer.remaining() >= 4) {
                        this.count = buffer.getInt();
                        this.state = State.ID_FLAGS;
                        continue block8;
                    }
                    this.state = State.COUNT_BYTES;
                    this.cursor = 4;
                    continue block8;
                }
                case COUNT_BYTES: {
                    byte currByte = buffer.get();
                    --this.cursor;
                    this.count += (currByte & 0xFF) << 8 * this.cursor;
                    if (this.cursor != 0) continue block8;
                    this.state = State.ID_FLAGS;
                    continue block8;
                }
                case ID_FLAGS: {
                    if (buffer.remaining() >= 4) {
                        this.idAndFlags = this.convertIdAndFlags(this.controlFrameParser.getVersion(), buffer.getInt());
                        this.state = State.VALUE;
                        continue block8;
                    }
                    this.state = State.ID_FLAGS_BYTES;
                    this.cursor = 4;
                    continue block8;
                }
                case ID_FLAGS_BYTES: {
                    byte currByte = buffer.get();
                    --this.cursor;
                    this.value += (currByte & 0xFF) << 8 * this.cursor;
                    if (this.cursor != 0) continue block8;
                    this.idAndFlags = this.convertIdAndFlags(this.controlFrameParser.getVersion(), this.value);
                    this.state = State.VALUE;
                    continue block8;
                }
                case VALUE: {
                    if (buffer.remaining() >= 4) {
                        this.value = buffer.getInt();
                        if (!this.onPair()) continue block8;
                        return true;
                    }
                    this.state = State.VALUE_BYTES;
                    this.cursor = 4;
                    this.value = 0;
                    continue block8;
                }
                case VALUE_BYTES: {
                    byte currByte = buffer.get();
                    --this.cursor;
                    this.value += (currByte & 0xFF) << 8 * this.cursor;
                    if (this.cursor != 0 || !this.onPair()) continue block8;
                    return true;
                }
            }
            throw new IllegalStateException();
        }
        return false;
    }

    private int convertIdAndFlags(short version, int idAndFlags) {
        switch (version) {
            case 2: {
                int result = (idAndFlags & 0xFF) << 24;
                result += (idAndFlags & 0xFF00) << 8;
                result += (idAndFlags & 0xFF0000) >>> 8;
                return result += (idAndFlags & 0xFF000000) >>> 24;
            }
            case 3: {
                return idAndFlags;
            }
        }
        throw new IllegalStateException();
    }

    private boolean onPair() {
        int id = this.idAndFlags & 0xFFFFFF;
        byte flags = (byte)((this.idAndFlags & 0xFF000000) >>> 24);
        this.settings.put(new Settings.Setting(Settings.ID.from(id), Settings.Flag.from(flags), this.value));
        this.state = State.ID_FLAGS;
        this.idAndFlags = 0;
        this.value = 0;
        --this.count;
        if (this.count == 0) {
            this.onSettings();
            return true;
        }
        return false;
    }

    private void onSettings() {
        SettingsFrame frame = new SettingsFrame(this.controlFrameParser.getVersion(), this.controlFrameParser.getFlags(), new Settings(this.settings, true));
        this.controlFrameParser.onControlFrame(frame);
        this.reset();
    }

    private void reset() {
        this.settings.clear();
        this.state = State.COUNT;
        this.cursor = 0;
        this.count = 0;
        this.idAndFlags = 0;
        this.value = 0;
    }

    private static enum State {
        COUNT,
        COUNT_BYTES,
        ID_FLAGS,
        ID_FLAGS_BYTES,
        VALUE,
        VALUE_BYTES;

    }
}

