/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import org.apache.camel.CamelContext;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedStreamCachingStrategyMBean;
import org.apache.camel.management.mbean.ManagedService;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.spi.StreamCachingStrategy;

@ManagedResource(description="Managed StreamCachingStrategy")
public class ManagedStreamCachingStrategy
extends ManagedService
implements ManagedStreamCachingStrategyMBean {
    private final CamelContext camelContext;
    private final StreamCachingStrategy streamCachingStrategy;

    public ManagedStreamCachingStrategy(CamelContext camelContext, StreamCachingStrategy streamCachingStrategy) {
        super(camelContext, streamCachingStrategy);
        this.camelContext = camelContext;
        this.streamCachingStrategy = streamCachingStrategy;
    }

    @Override
    public void init(ManagementStrategy strategy) {
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public StreamCachingStrategy getStreamCachingStrategy() {
        return this.streamCachingStrategy;
    }

    @Override
    public boolean isEnabled() {
        return this.streamCachingStrategy.isEnabled();
    }

    @Override
    public String getSpoolDirectory() {
        return this.streamCachingStrategy.getSpoolDirectory().getPath();
    }

    @Override
    public String getSpoolChiper() {
        return this.streamCachingStrategy.getSpoolChiper();
    }

    @Override
    public void setSpoolThreshold(long threshold) {
        this.streamCachingStrategy.setSpoolThreshold(threshold);
    }

    @Override
    public long getSpoolThreshold() {
        return this.streamCachingStrategy.getSpoolThreshold();
    }

    @Override
    public void setSpoolUsedHeapMemoryThreshold(int percentage) {
        this.streamCachingStrategy.setSpoolUsedHeapMemoryThreshold(percentage);
    }

    @Override
    public int getSpoolUsedHeapMemoryThreshold() {
        return this.streamCachingStrategy.getSpoolUsedHeapMemoryThreshold();
    }

    @Override
    public void setSpoolUsedHeapMemoryLimit(StreamCachingStrategy.SpoolUsedHeapMemoryLimit limit) {
        this.streamCachingStrategy.setSpoolUsedHeapMemoryLimit(limit);
    }

    @Override
    public StreamCachingStrategy.SpoolUsedHeapMemoryLimit getSpoolUsedHeapMemoryLimit() {
        return this.streamCachingStrategy.getSpoolUsedHeapMemoryLimit();
    }

    @Override
    public void setBufferSize(int bufferSize) {
        this.streamCachingStrategy.setBufferSize(bufferSize);
    }

    @Override
    public int getBufferSize() {
        return this.streamCachingStrategy.getBufferSize();
    }

    @Override
    public void setRemoveSpoolDirectoryWhenStopping(boolean remove2) {
        this.streamCachingStrategy.setRemoveSpoolDirectoryWhenStopping(remove2);
    }

    @Override
    public boolean isRemoveSpoolDirectoryWhenStopping() {
        return this.streamCachingStrategy.isRemoveSpoolDirectoryWhenStopping();
    }

    @Override
    public void setAnySpoolRules(boolean any) {
        this.streamCachingStrategy.setAnySpoolRules(any);
    }

    @Override
    public boolean isAnySpoolRules() {
        return this.streamCachingStrategy.isAnySpoolRules();
    }

    @Override
    public long getCacheMemoryCounter() {
        return this.streamCachingStrategy.getStatistics().getCacheMemoryCounter();
    }

    @Override
    public long getCacheMemorySize() {
        return this.streamCachingStrategy.getStatistics().getCacheMemorySize();
    }

    @Override
    public long getCacheMemoryAverageSize() {
        return this.streamCachingStrategy.getStatistics().getCacheMemoryAverageSize();
    }

    @Override
    public long getCacheSpoolCounter() {
        return this.streamCachingStrategy.getStatistics().getCacheSpoolCounter();
    }

    @Override
    public long getCacheSpoolSize() {
        return this.streamCachingStrategy.getStatistics().getCacheSpoolSize();
    }

    @Override
    public long getCacheSpoolAverageSize() {
        return this.streamCachingStrategy.getStatistics().getCacheSpoolAverageSize();
    }

    @Override
    public boolean isStatisticsEnabled() {
        return this.streamCachingStrategy.getStatistics().isStatisticsEnabled();
    }

    @Override
    public void setStatisticsEnabled(boolean enabled) {
        this.streamCachingStrategy.getStatistics().setStatisticsEnabled(enabled);
    }

    @Override
    public void resetStatistics() {
        this.streamCachingStrategy.getStatistics().reset();
    }
}

