/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.amqp;

import java.nio.ByteBuffer;
import java.util.AbstractMap;
import java.util.Map;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.transport.amqp.AmqpProtocolException;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.DescribedType;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedLong;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.apache.qpid.proton.amqp.messaging.Terminus;
import org.apache.qpid.proton.amqp.transaction.Coordinator;
import org.fusesource.hawtbuf.Buffer;

public class AmqpSupport {
    public static final UnsignedLong JMS_SELECTOR_CODE = UnsignedLong.valueOf((long)77567109365764L);
    public static final Symbol JMS_SELECTOR_NAME = Symbol.valueOf((String)"apache.org:selector-filter:string");
    public static final Object[] JMS_SELECTOR_FILTER_IDS = new Object[]{JMS_SELECTOR_CODE, JMS_SELECTOR_NAME};
    public static final UnsignedLong NO_LOCAL_CODE = UnsignedLong.valueOf((long)77567109365763L);
    public static final Symbol NO_LOCAL_NAME = Symbol.valueOf((String)"apache.org:no-local-filter:list");
    public static final Object[] NO_LOCAL_FILTER_IDS = new Object[]{NO_LOCAL_CODE, NO_LOCAL_NAME};
    public static final Symbol TEMP_QUEUE_CAPABILITY = Symbol.valueOf((String)"temporary-queue");
    public static final Symbol TEMP_TOPIC_CAPABILITY = Symbol.valueOf((String)"temporary-topic");
    public static final Symbol QUEUE_CAPABILITY = Symbol.valueOf((String)"queue");
    public static final Symbol TOPIC_CAPABILITY = Symbol.valueOf((String)"topic");
    public static final Symbol INVALID_FIELD = Symbol.valueOf((String)"invalid-field");
    public static final Symbol CONTAINER_ID = Symbol.valueOf((String)"container-id");
    public static final Symbol ANONYMOUS_RELAY = Symbol.valueOf((String)"ANONYMOUS-RELAY");
    public static final Symbol DELAYED_DELIVERY = Symbol.valueOf((String)"DELAYED_DELIVERY");
    public static final Symbol QUEUE_PREFIX = Symbol.valueOf((String)"queue-prefix");
    public static final Symbol TOPIC_PREFIX = Symbol.valueOf((String)"topic-prefix");
    public static final Symbol CONNECTION_OPEN_FAILED = Symbol.valueOf((String)"amqp:connection-establishment-failed");
    public static final Symbol PRODUCT = Symbol.valueOf((String)"product");
    public static final Symbol VERSION = Symbol.valueOf((String)"version");
    public static final Symbol PLATFORM = Symbol.valueOf((String)"platform");
    public static final Symbol COPY = Symbol.getSymbol((String)"copy");
    public static final Symbol LIFETIME_POLICY = Symbol.valueOf((String)"lifetime-policy");

    public static boolean contains(Symbol[] symbols, Symbol key) {
        if (symbols == null || symbols.length == 0) {
            return false;
        }
        for (Symbol symbol : symbols) {
            if (!symbol.equals(key)) continue;
            return true;
        }
        return false;
    }

    public static Map.Entry<Symbol, DescribedType> findFilter(Map<Symbol, Object> filters, Object[] filterIds) {
        if (filterIds == null || filterIds.length == 0) {
            throw new IllegalArgumentException("Invalid empty Filter Ids array passed: ");
        }
        if (filters == null || filters.isEmpty()) {
            return null;
        }
        for (Map.Entry<Symbol, Object> filter : filters.entrySet()) {
            if (!(filter.getValue() instanceof DescribedType)) continue;
            DescribedType describedType = (DescribedType)filter.getValue();
            Object descriptor = describedType.getDescriptor();
            for (Object filterId : filterIds) {
                if (!descriptor.equals(filterId)) continue;
                return new AbstractMap.SimpleImmutableEntry<Symbol, DescribedType>(filter.getKey(), describedType);
            }
        }
        return null;
    }

    public static Buffer toBuffer(ByteBuffer data) {
        Buffer rc;
        if (data == null) {
            return null;
        }
        if (data.isDirect()) {
            rc = new Buffer(data.remaining());
            data.get(rc.data);
        } else {
            rc = new Buffer(data);
            data.position(data.position() + data.remaining());
        }
        return rc;
    }

    public static byte[] toBytes(long value) {
        Buffer buffer = new Buffer(8);
        buffer.bigEndianEditor().writeLong(value);
        return buffer.data;
    }

    public static long toLong(Binary value) {
        Buffer buffer = new Buffer(value.getArray(), value.getArrayOffset(), value.getLength());
        return buffer.bigEndianEditor().readLong();
    }

    public static ActiveMQDestination createDestination(Object endpoint) throws AmqpProtocolException {
        if (endpoint == null) {
            return null;
        }
        if (endpoint instanceof Coordinator) {
            return null;
        }
        if (endpoint instanceof Terminus) {
            Terminus terminus = (Terminus)endpoint;
            if (terminus.getAddress() == null || terminus.getAddress().length() == 0) {
                if (terminus instanceof Source) {
                    throw new AmqpProtocolException("amqp:invalid-field", "source address not set");
                }
                throw new AmqpProtocolException("amqp:invalid-field", "target address not set");
            }
            return ActiveMQDestination.createDestination(terminus.getAddress(), (byte)1);
        }
        throw new RuntimeException("Unexpected terminus type: " + endpoint);
    }

    public static Symbol getDestinationTypeSymbol(ActiveMQDestination destination) {
        if (destination.isQueue()) {
            if (destination.isTemporary()) {
                return TEMP_QUEUE_CAPABILITY;
            }
            return QUEUE_CAPABILITY;
        }
        if (destination.isTemporary()) {
            return TEMP_TOPIC_CAPABILITY;
        }
        return TOPIC_CAPABILITY;
    }
}

