/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.opf;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.opf.OPFItem;
import com.adobe.epubcheck.opf.OPFItems;
import com.adobe.epubcheck.opf.OPFReference;
import com.adobe.epubcheck.opf.ValidationContext;
import com.adobe.epubcheck.opf.XRefChecker;
import com.adobe.epubcheck.util.DateParser;
import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.util.FeatureEnum;
import com.adobe.epubcheck.util.HandlerUtil;
import com.adobe.epubcheck.util.InvalidDateException;
import com.adobe.epubcheck.util.PathUtil;
import com.adobe.epubcheck.xml.XMLElement;
import com.adobe.epubcheck.xml.XMLHandler;
import com.adobe.epubcheck.xml.XMLParser;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.Vector;

public class OPFHandler
implements XMLHandler {
    protected final String path;
    protected final XMLParser parser;
    protected final Report report;
    protected final ValidationContext context;
    protected String pageMapId = null;
    protected EPUBLocation pageMapReferenceLocation = null;
    protected final Map<String, OPFItem.Builder> itemBuilders = Maps.newLinkedHashMap();
    protected final Map<String, OPFItem.Builder> itemBuildersByPath = Maps.newLinkedHashMap();
    private final List<String> spineIDs = new LinkedList<String>();
    private OPFItems items = null;
    private final Vector<OPFReference> refs = new Vector();
    private static final HashSet<String> validRoles = new HashSet();
    private String uniqueIdent;
    private boolean uniqueIdentExists = false;
    String uid;
    private boolean opf12PackageFile = false;
    private boolean checkedUnsupportedXmlVersion = false;
    private int spineItemCounter = 0;

    public OPFHandler(ValidationContext context, XMLParser parser) {
        this.context = context;
        this.path = context.path;
        this.report = context.report;
        this.parser = parser;
    }

    public boolean getOpf12PackageFile() {
        return this.opf12PackageFile;
    }

    public boolean getOpf20PackageFile() {
        return !this.opf12PackageFile;
    }

    public Optional<OPFItem> getItemById(String id) {
        return this.items != null ? this.items.getItemById(id) : Optional.absent();
    }

    public Optional<OPFItem> getItemByPath(String path) {
        return this.items != null ? this.items.getItemByPath(path) : Optional.absent();
    }

    public List<OPFItem> getSpineItems() {
        return this.items != null ? this.items.getSpineItems() : ImmutableList.of();
    }

    public List<OPFItem> getItems() {
        return this.items != null ? this.items.getItems() : ImmutableList.of();
    }

    public int getReferenceCount() {
        return this.refs.size();
    }

    public OPFReference getReference(int index) {
        return this.refs.elementAt(index);
    }

    public boolean checkUniqueIdentExists() {
        return this.uniqueIdentExists;
    }

    public String getUid() {
        return this.uid;
    }

    private static boolean isValidRole(String role) {
        return validRoles.contains(role) || role.startsWith("oth.");
    }

    @Override
    public void startElement() {
        XMLElement e;
        String ns;
        if (!this.checkedUnsupportedXmlVersion) {
            HandlerUtil.checkXMLVersion(this.parser);
            this.checkedUnsupportedXmlVersion = true;
        }
        if ((ns = (e = this.parser.getCurrentElement()).getNamespace()) == null || ns.equals("") || ns.equals("http://openebook.org/namespaces/oeb-package/1.0/") || ns.equals("http://www.idpf.org/2007/opf")) {
            String name = e.getName();
            if (name.equals("package")) {
                String uniqueIdentAttr;
                if (!ns.equals("http://www.idpf.org/2007/opf")) {
                    this.report.message(MessageId.OPF_047, EPUBLocation.create(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber()), new Object[0]);
                    this.opf12PackageFile = true;
                }
                if ((uniqueIdentAttr = e.getAttribute("unique-identifier")) != null && !uniqueIdentAttr.equals("")) {
                    this.uniqueIdent = uniqueIdentAttr;
                } else {
                    this.report.message(MessageId.OPF_048, EPUBLocation.create(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber()), new Object[0]);
                }
            } else if (name.equals("item")) {
                String id = e.getAttribute("id");
                if (id != null) {
                    String href = e.getAttribute("href");
                    if (!(href == null || this.context.version == EPUBVersion.VERSION_3 && href.matches("^[^:/?#]+://.*"))) {
                        try {
                            href = PathUtil.resolveRelativeReference(this.path, href);
                        }
                        catch (IllegalArgumentException ex) {
                            this.report.message(MessageId.OPF_010, EPUBLocation.create(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), href), ex.getMessage());
                            href = null;
                        }
                    }
                    if (href != null && href.matches("^[^:/?#]+://.*")) {
                        this.report.info(this.path, FeatureEnum.REFERENCE, href);
                    }
                    String mimeType = e.getAttribute("media-type");
                    String fallback = e.getAttribute("fallback");
                    String fallbackStyle = this.context.version == EPUBVersion.VERSION_3 ? e.getAttribute("fallback") : e.getAttribute("fallback-style");
                    OPFItem.Builder itemBuilder = new OPFItem.Builder(id, href, mimeType, this.parser.getLineNumber(), this.parser.getColumnNumber()).fallback(fallback).fallbackStyle(fallbackStyle);
                    this.itemBuilders.put(id.trim(), itemBuilder);
                    this.itemBuildersByPath.put(href, itemBuilder);
                    this.report.info(href, FeatureEnum.UNIQUE_IDENT, id);
                }
            } else if (name.equals("reference")) {
                String type = e.getAttribute("type");
                String title = e.getAttribute("title");
                String href = e.getAttribute("href");
                if (href != null && this.context.xrefChecker.isPresent()) {
                    try {
                        href = PathUtil.resolveRelativeReference(this.path, href);
                        this.context.xrefChecker.get().registerReference(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), href, XRefChecker.Type.GENERIC);
                    }
                    catch (IllegalArgumentException ex) {
                        this.report.message(MessageId.OPF_010, EPUBLocation.create(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), href), ex.getMessage());
                        href = null;
                    }
                }
                if (href != null && href.startsWith("http")) {
                    this.report.info(this.path, FeatureEnum.REFERENCE, href);
                }
                OPFReference ref = new OPFReference(type, title, href, this.parser.getLineNumber(), this.parser.getColumnNumber());
                this.refs.add(ref);
            } else if (name.equals("spine")) {
                String idref;
                String pageMap = e.getAttribute("page-map");
                if (pageMap != null) {
                    this.pageMapId = pageMap;
                    this.pageMapReferenceLocation = EPUBLocation.create(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), String.format("page-map=\"%1$s\"", this.pageMapId));
                    this.report.message(MessageId.OPF_062, this.pageMapReferenceLocation, new Object[0]);
                }
                if ((idref = e.getAttribute("toc")) != null) {
                    if (this.itemBuilders.containsKey(idref.trim())) {
                        OPFItem.Builder toc = this.itemBuilders.get(idref.trim());
                        toc.ncx();
                    } else {
                        this.report.message(MessageId.OPF_049, EPUBLocation.create(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber()), idref);
                        this.report.info(null, FeatureEnum.HAS_NCX, "false");
                    }
                } else {
                    this.report.info(null, FeatureEnum.HAS_NCX, "false");
                }
            } else if (name.equals("itemref")) {
                String idref = e.getAttribute("idref");
                if (idref != null) {
                    if (this.itemBuilders.containsKey(idref.trim())) {
                        this.spineIDs.add(idref.trim());
                        OPFItem.Builder item = this.itemBuilders.get(idref.trim());
                        if (item != null) {
                            item.inSpine(this.spineItemCounter++);
                            String linear = e.getAttribute("linear");
                            if (linear != null && "no".equals(linear.trim())) {
                                item.nonlinear();
                            }
                        }
                    } else {
                        this.report.message(MessageId.OPF_049, EPUBLocation.create(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber()), idref);
                    }
                }
            } else if ((name.equals("dc-metadata") || name.equals("x-metadata")) && !this.opf12PackageFile) {
                this.report.message(MessageId.OPF_049, EPUBLocation.create(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber()), name);
            }
        } else if (ns.equals("http://purl.org/dc/elements/1.1/")) {
            String role;
            String name = e.getName();
            if (name.equals("identifier")) {
                String idAttr = e.getAttribute("id");
                if (idAttr != null && !idAttr.equals("") && idAttr.equals(this.uniqueIdent)) {
                    this.uniqueIdentExists = true;
                }
            } else if (name.equals("creator") && (role = e.getAttributeNS("http://www.idpf.org/2007/opf", "role")) != null && !role.equals("") && !OPFHandler.isValidRole(role)) {
                this.report.message(MessageId.OPF_052, EPUBLocation.create(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber()), role);
            }
        }
    }

    public String getIdentId() {
        return this.uniqueIdent;
    }

    @Override
    public void endElement() {
        XMLElement e = this.parser.getCurrentElement();
        String ns = e.getNamespace();
        if (ns == null || ns.equals("") || ns.equals("http://openebook.org/namespaces/oeb-package/1.0/") || ns.equals("http://www.idpf.org/2007/opf")) {
            String name = e.getName();
            if ("meta".equals(name)) {
                String attr = e.getAttribute("property");
                if ("dcterms:modified".equals(attr)) {
                    String val = (String)e.getPrivateData();
                    this.report.info(null, FeatureEnum.MODIFIED_DATE, val);
                }
            } else if ("package".equals(name)) {
                this.buildItems();
                if (this.pageMapId != null && !this.getItemById(this.pageMapId).isPresent()) {
                    this.report.message(MessageId.OPF_063, this.pageMapReferenceLocation, this.pageMapId);
                }
            }
        } else if (e.getNamespace().equals("http://purl.org/dc/elements/1.1/")) {
            String name = e.getName();
            if (name.equals("identifier")) {
                String idval;
                String idAttr = e.getAttribute("id");
                if (idAttr != null && !idAttr.equals("") && idAttr.trim().equals(this.uniqueIdent) && (idval = (String)e.getPrivateData()) != null) {
                    this.report.info(null, FeatureEnum.UNIQUE_IDENT, idval.trim());
                    this.uid = idval.trim();
                    String opfSchemeAttr = e.getAttributeNS("http://www.idpf.org/2007/opf", "scheme");
                    if (this.uid.startsWith("urn:uuid:") || opfSchemeAttr != null && opfSchemeAttr.toLowerCase().equals("uuid")) {
                        try {
                            UUID.fromString(this.uid.replaceAll("urn:uuid:", ""));
                        }
                        catch (Throwable t) {
                            this.report.message(MessageId.OPF_085, EPUBLocation.create(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber()), this.uid);
                        }
                    }
                }
            } else if (name.equals("date")) {
                String dateval = (String)e.getPrivateData();
                boolean valid = true;
                String detail = null;
                if (dateval == null || "".equals(dateval)) {
                    valid = false;
                    detail = "zero-length string";
                } else {
                    DateParser dateParser = new DateParser();
                    try {
                        Date date = dateParser.parse(dateval.trim());
                        String year = new SimpleDateFormat("yyyy").format(date);
                        if (year.length() > 4) {
                            throw new InvalidDateException(year);
                        }
                        this.report.info(null, FeatureEnum.DC_DATE, dateval);
                    }
                    catch (InvalidDateException d) {
                        valid = false;
                        detail = d.getMessage();
                    }
                }
                if (!valid) {
                    if (this.context.version == EPUBVersion.VERSION_3) {
                        this.report.message(MessageId.OPF_053, EPUBLocation.create(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber()), dateval == null ? "" : dateval, detail);
                    } else {
                        this.report.message(MessageId.OPF_054, EPUBLocation.create(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber()), dateval == null ? "" : dateval, detail);
                    }
                }
            } else if (name.equals("title") || name.equals("language")) {
                String value;
                if ("language".equals(name)) {
                    value = (String)e.getPrivateData();
                    if (value != null) {
                        this.report.info(null, FeatureEnum.DC_LANGUAGE, value.trim());
                    }
                } else if ("title".equals(name) && (value = (String)e.getPrivateData()) != null) {
                    this.report.info(null, FeatureEnum.DC_TITLE, value.trim());
                }
                if (this.context.version == EPUBVersion.VERSION_2 && ((value = (String)e.getPrivateData()) == null || value.trim().length() < 1)) {
                    this.report.message(MessageId.OPF_055, EPUBLocation.create(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber()), name);
                }
            } else {
                Optional<String> value = Optional.fromNullable(Strings.emptyToNull(Strings.nullToEmpty((String)e.getPrivateData()).trim()));
                if (this.context.version == EPUBVersion.VERSION_2 && !value.isPresent()) {
                    this.report.message(MessageId.OPF_072, EPUBLocation.create(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber()), "dc:" + name);
                } else if (value.isPresent()) {
                    if (name.equals("creator")) {
                        this.report.info(null, FeatureEnum.DC_CREATOR, value.get());
                    } else if (name.equals("contributor")) {
                        this.report.info(null, FeatureEnum.DC_CONTRIBUTOR, value.get());
                    } else if (name.equals("publisher")) {
                        this.report.info(null, FeatureEnum.DC_PUBLISHER, value.get());
                    } else if (name.equals("rights")) {
                        this.report.info(null, FeatureEnum.DC_RIGHTS, value.get());
                    } else if (name.equals("subject")) {
                        this.report.info(null, FeatureEnum.DC_SUBJECT, value.get());
                    } else if (name.equals("description")) {
                        this.report.info(null, FeatureEnum.DC_DESCRIPTION, value.get());
                    }
                }
            }
        }
    }

    @Override
    public void ignorableWhitespace(char[] chars, int arg1, int arg2) {
    }

    @Override
    public void characters(char[] chars, int start, int len) {
        boolean keepValue;
        XMLElement e = this.parser.getCurrentElement();
        String name = e.getName();
        String ns = e.getNamespace();
        boolean bl = keepValue = "http://www.idpf.org/2007/opf".equals(ns) && "meta".equals(name) || "http://purl.org/dc/elements/1.1/".equals(ns);
        if (keepValue) {
            String val = (String)e.getPrivateData();
            String text = new String(chars, start, len);
            val = val == null ? text : val + text;
            e.setPrivateData(val);
        }
    }

    @Override
    public void processingInstruction(String arg0, String arg1) {
    }

    private void buildItems() {
        Preconditions.checkState(this.items == null);
        this.items = OPFItems.build(this.itemBuilders.values(), this.spineIDs);
        for (OPFItem item : this.items.getItems()) {
            this.reportItem(item);
        }
    }

    protected void reportItem(OPFItem item) {
        if (item.isInSpine()) {
            this.report.info(item.getPath(), FeatureEnum.IS_SPINEITEM, "true");
            this.report.info(item.getPath(), FeatureEnum.IS_LINEAR, String.valueOf(item.isLinear()));
        }
        if (item.isNcx()) {
            this.report.info(item.getPath(), FeatureEnum.HAS_NCX, "true");
            if (!item.getMimeType().equals("application/x-dtbncx+xml")) {
                this.report.message(MessageId.OPF_050, EPUBLocation.create(this.path, item.getLineNumber(), item.getColumnNumber()), new Object[0]);
            }
        }
    }

    static {
        String[] list = new String[]{"acp", "act", "adp", "aft", "anl", "anm", "ann", "ant", "app", "aqt", "arc", "ard", "arr", "art", "asg", "asn", "att", "auc", "aud", "aui", "aus", "aut", "bdd", "bjd", "bkd", "bkp", "bnd", "bpd", "bsl", "ccp", "chr", "clb", "cli", "cll", "clr", "clt", "cmm", "cmp", "cmt", "cng", "cnd", "cns", "coe", "col", "com", "cos", "cot", "cov", "cpc", "cpe", "cph", "cpl", "cpt", "cre", "crp", "crr", "csl", "csp", "cst", "ctb", "cte", "ctg", "ctr", "cts", "ctt", "cur", "cwt", "dfd", "dfe", "dft", "dgg", "dis", "dln", "dnc", "dnr", "dpc", "dpt", "drm", "drt", "dsr", "dst", "dtc", "dte", "dtm", "dto", "dub", "edt", "egr", "elg", "elt", "eng", "etr", "exp", "fac", "fld", "flm", "fmo", "fpy", "fnd", "frg", "gis", "grt", "hnr", "hst", "ill", "ilu", "ins", "inv", "itr", "ive", "ivr", "lbr", "lbt", "ldr", "led", "lee", "lel", "len", "let", "lgd", "lie", "lil", "lit", "lsa", "lse", "lso", "ltg", "lyr", "mcp", "mfr", "mdc", "mod", "mon", "mrk", "msd", "mte", "mus", "nrt", "opn", "org", "orm", "oth", "own", "pat", "pbd", "pbl", "pdr", "pfr", "pht", "plt", "pma", "pmn", "pop", "ppm", "ppt", "prc", "prd", "prf", "prg", "prm", "pro", "prt", "pta", "pte", "ptf", "pth", "ptt", "rbr", "rce", "rcp", "red", "ren", "res", "rev", "rps", "rpt", "rpy", "rse", "rsg", "rsp", "rst", "rth", "rtm", "sad", "sce", "scl", "scr", "sds", "sec", "sgn", "sht", "sng", "spk", "spn", "spy", "srv", "std", "stl", "stm", "stn", "str", "tcd", "tch", "ths", "trc", "trl", "tyd", "tyg", "vdg", "voc", "wam", "wdc", "wde", "wit"};
        Collections.addAll(validRoles, list);
    }
}

