/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import classNames from 'classnames';
import PropTypes from 'prop-types';
import React from 'react';
import { EuiFlyoutBody } from '@elastic/eui';
/**
 * The InspectorView component should be the top most element in every implemented
 * inspector view. It makes sure, that the appropriate stylings are applied to the
 * view.
 */
var InspectorView = function (_a) {
    var useFlex = _a.useFlex, children = _a.children;
    var classes = classNames({
        'kbnInspectorView--flex': Boolean(useFlex),
    });
    return React.createElement(EuiFlyoutBody, { className: classes }, children);
};
InspectorView.propTypes = {
    /**
     * Set to true if the element should have display: flex set.
     */
    useFlex: PropTypes.bool,
};
export { InspectorView };
