/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.util;

import java.io.UTFDataFormatException;
import java.util.HashMap;
import org.jd.core.v1.api.loader.Loader;
import org.jd.core.v1.model.classfile.constant.ConstantClass;
import org.jd.core.v1.model.javasyntax.type.InnerObjectType;
import org.jd.core.v1.model.javasyntax.type.ObjectType;
import org.jd.core.v1.service.deserializer.classfile.ClassFileFormatException;
import org.jd.core.v1.service.deserializer.classfile.ClassFileReader;

public class ObjectTypeMaker {
    protected HashMap<String, ObjectType> objectTypeCache = new HashMap(1024);
    protected HashMap<String, String[]> hierarchy = new HashMap(1024);
    protected Loader loader;
    private Object[] constants = new Object[1000];
    private Function checkInnerTypeName = (reader, typeName, innerTypeName) -> {
        int count = reader.readUnsignedShort();
        for (int i = 0; i < count; ++i) {
            int innerTypeIndex = reader.readUnsignedShort();
            reader.skip(6);
            ConstantClass cc = (ConstantClass)this.constants[innerTypeIndex];
            String innerInternalTypeName = (String)this.constants[cc.getNameIndex()];
            if (!innerTypeName.equals(innerInternalTypeName)) continue;
            return typeName;
        }
        return null;
    };
    private Function searchOuterTypeName = (reader, typeName, innerTypeName) -> {
        int count = reader.readUnsignedShort();
        for (int i = 0; i < count; ++i) {
            int innerTypeIndex = reader.readUnsignedShort();
            int outerTypeIndex = reader.readUnsignedShort();
            reader.skip(4);
            ConstantClass cc = (ConstantClass)this.constants[innerTypeIndex];
            innerTypeName = (String)this.constants[cc.getNameIndex()];
            if (!innerTypeName.equals(typeName)) continue;
            if (outerTypeIndex == 0) {
                int lastDollar = typeName.lastIndexOf(36);
                if (lastDollar != -1) {
                    String outerTypeName = typeName.substring(0, lastDollar);
                    return this.loadTypeAndApplyFunction(outerTypeName, typeName, this.checkInnerTypeName);
                }
                return null;
            }
            cc = (ConstantClass)this.constants[outerTypeIndex];
            return (String)this.constants[cc.getNameIndex()];
        }
        return null;
    };

    public ObjectTypeMaker(Loader loader) {
        this.loader = loader;
        this.objectTypeCache.put("java/lang/Class", ObjectType.TYPE_CLASS);
        this.objectTypeCache.put("java/lang/Object", ObjectType.TYPE_OBJECT);
        this.objectTypeCache.put("java/lang/String", ObjectType.TYPE_STRING);
    }

    public ObjectType make(String descriptor) {
        try {
            if (descriptor.charAt(0) == '[') {
                ObjectType ot = this.objectTypeCache.get(descriptor);
                if (ot == null) {
                    int dimension = 1;
                    while (descriptor.charAt(dimension) == '[') {
                        ++dimension;
                    }
                    if (descriptor.charAt(dimension) == 'L' && descriptor.endsWith(";")) {
                        ot = this.unsafeMake(descriptor.substring(dimension + 1, descriptor.length() - 1));
                        ot = new ObjectType(ot.getInternalName(), ot.getQualifiedName(), ot.getName(), dimension);
                        this.objectTypeCache.put(descriptor, ot);
                    }
                }
                return ot;
            }
            if (descriptor.charAt(0) == 'L' && descriptor.charAt(descriptor.length() - 1) == ';') {
                return this.unsafeMake(descriptor.substring(1, descriptor.length() - 1));
            }
            return this.unsafeMake(descriptor);
        }
        catch (Exception ignore) {
            return null;
        }
    }

    private ObjectType unsafeMake(String internalTypeName) throws Exception {
        assert (internalTypeName != null && !internalTypeName.endsWith(";"));
        ObjectType ot = this.objectTypeCache.get(internalTypeName);
        if (ot == null) {
            ot = this.loadFromLoader(internalTypeName);
            if (ot == null) {
                ot = this.loadFromClassLoader(internalTypeName);
            }
            if (ot == null) {
                ot = this.create(internalTypeName);
            }
        }
        return ot;
    }

    private ObjectType loadFromLoader(String internalTypeName) throws Exception {
        ObjectType ot = this.objectTypeCache.get(internalTypeName);
        if (ot == null && this.loader.canLoad(internalTypeName)) {
            String outerTypeName = this.getOuterTypeName(internalTypeName);
            if (outerTypeName == null) {
                int lastSlash = internalTypeName.lastIndexOf(47);
                String qualifiedName = internalTypeName.replace('/', '.');
                String name = qualifiedName.substring(lastSlash + 1);
                ot = new ObjectType(internalTypeName, qualifiedName, name);
            } else {
                ObjectType outerOT = this.loadFromLoader(outerTypeName);
                assert (outerOT != null);
                int index = internalTypeName.length() > outerTypeName.length() + 1 ? outerTypeName.length() : internalTypeName.lastIndexOf(36);
                String innerName = internalTypeName.substring(index + 1);
                if (Character.isDigit(innerName.charAt(0))) {
                    ot = new InnerObjectType(internalTypeName, null, ObjectTypeMaker.extractLocalClassName(innerName), outerOT);
                } else {
                    String qualifiedName = outerOT.getQualifiedName() + '.' + innerName;
                    ot = new InnerObjectType(internalTypeName, qualifiedName, innerName, outerOT);
                }
            }
            this.objectTypeCache.put(internalTypeName, ot);
        }
        return ot;
    }

    private ObjectType loadFromClassLoader(String internalTypeName) {
        ObjectType ot = this.objectTypeCache.get(internalTypeName);
        if (ot == null) {
            try {
                Class<?> clazz = this.getClass().getClassLoader().loadClass(internalTypeName.replace('/', '.'));
                String qualifiedName = clazz.getCanonicalName();
                String name = clazz.getSimpleName();
                if (clazz.isMemberClass()) {
                    String outerInternalTypeName = name.isEmpty() ? internalTypeName.substring(0, internalTypeName.lastIndexOf(36)) : internalTypeName.substring(0, internalTypeName.length() - name.length() - 1);
                    ObjectType outerSot = this.loadFromClassLoader(outerInternalTypeName);
                    ot = new InnerObjectType(internalTypeName, qualifiedName, name, outerSot);
                } else {
                    ot = new ObjectType(internalTypeName, qualifiedName, name);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            this.objectTypeCache.put(internalTypeName, ot);
        }
        return ot;
    }

    private ObjectType create(String internalTypeName) {
        ObjectType ot;
        int lastDollar;
        int lastSlash = internalTypeName.lastIndexOf(47);
        if (lastSlash < (lastDollar = internalTypeName.lastIndexOf(36))) {
            String outerTypeName = internalTypeName.substring(0, lastDollar);
            ObjectType outerSot = this.create(outerTypeName);
            String innerName = internalTypeName.substring(outerTypeName.length() + 1);
            if (Character.isDigit(innerName.charAt(0))) {
                ot = new InnerObjectType(internalTypeName, null, ObjectTypeMaker.extractLocalClassName(innerName), outerSot);
            } else {
                String qualifiedName = outerSot.getQualifiedName() + '.' + innerName;
                ot = new InnerObjectType(internalTypeName, qualifiedName, innerName, outerSot);
            }
        } else {
            String qualifiedName = internalTypeName.replace('/', '.');
            String name = qualifiedName.substring(lastSlash + 1);
            ot = new ObjectType(internalTypeName, qualifiedName, name);
        }
        this.objectTypeCache.put(internalTypeName, ot);
        return ot;
    }

    public boolean isAssignable(ObjectType parent, ObjectType child) {
        String childInternalName;
        if (parent == ObjectType.TYPE_UNDEFINED_OBJECT) {
            return true;
        }
        if (parent.getDimension() > 0) {
            return parent.getDimension() == child.getDimension() && parent.getInternalName().equals(child.getInternalName());
        }
        String parentInternalName = parent.getInternalName();
        if (parentInternalName.equals(childInternalName = child.getInternalName()) || parentInternalName.equals("java/lang/Object")) {
            return true;
        }
        return this.recursiveIsAssignable(parentInternalName, childInternalName);
    }

    private boolean recursiveIsAssignable(String parentInternalName, String childInternalName) {
        if (childInternalName.equals("java/lang/Object")) {
            return false;
        }
        String[] superClassAndInterfaceNames = this.hierarchy.get(childInternalName);
        if (superClassAndInterfaceNames == null) {
            try {
                if (!this.loader.canLoad(childInternalName)) {
                    Class<?> childClazz = this.getClass().getClassLoader().loadClass(childInternalName.replace('/', '.'));
                    Class<?> parentClazz = this.getClass().getClassLoader().loadClass(parentInternalName.replace('/', '.'));
                    return parentClazz.isAssignableFrom(childClazz);
                }
                this.loadFromLoader(childInternalName);
                superClassAndInterfaceNames = this.hierarchy.get(childInternalName);
            }
            catch (Exception ignore) {
                return false;
            }
        }
        if (superClassAndInterfaceNames != null) {
            for (String name : superClassAndInterfaceNames) {
                if (!parentInternalName.equals(name)) continue;
                return true;
            }
            for (String name : superClassAndInterfaceNames) {
                if (!this.recursiveIsAssignable(parentInternalName, name)) continue;
                return true;
            }
        }
        return false;
    }

    private String getOuterTypeName(String internalTypeName) throws Exception {
        return this.loadTypeAndApplyFunction(internalTypeName, null, this.searchOuterTypeName);
    }

    private String loadTypeAndApplyFunction(String typeName, String innerTypeName, Function function) throws Exception {
        int i;
        String superClassName;
        byte[] data = this.loader.load(typeName);
        if (data == null) {
            return null;
        }
        ClassFileReader reader = new ClassFileReader(data);
        int magic = reader.readInt();
        if (magic != -889275714) {
            throw new ClassFileFormatException("Invalid CLASS file");
        }
        reader.skip(4);
        Object[] constants = this.loadConstants(reader);
        reader.skip(4);
        int superClassIndex = reader.readUnsignedShort();
        if (superClassIndex == 0) {
            superClassName = null;
        } else {
            ConstantClass cc = (ConstantClass)constants[superClassIndex];
            superClassName = (String)constants[cc.getNameIndex()];
        }
        int count = reader.readUnsignedShort();
        String[] superClassAndInterfaceNames = new String[count + 1];
        superClassAndInterfaceNames[0] = superClassName;
        for (i = 1; i <= count; ++i) {
            int interfaceIndex = reader.readUnsignedShort();
            ConstantClass cc = (ConstantClass)constants[interfaceIndex];
            superClassAndInterfaceNames[i] = (String)constants[cc.getNameIndex()];
        }
        this.hierarchy.put(typeName, superClassAndInterfaceNames);
        count = reader.readUnsignedShort();
        for (i = 0; i < count; ++i) {
            reader.skip(6);
            ObjectTypeMaker.skipAttributes(reader);
        }
        count = reader.readUnsignedShort();
        for (i = 0; i < count; ++i) {
            reader.skip(6);
            ObjectTypeMaker.skipAttributes(reader);
        }
        count = reader.readUnsignedShort();
        for (i = 0; i < count; ++i) {
            int attributeNameIndex = reader.readUnsignedShort();
            int attributeLength = reader.readInt();
            String name = (String)constants[attributeNameIndex];
            if ("InnerClasses".equals(name)) {
                return function.apply(reader, typeName, innerTypeName);
            }
            reader.skip(attributeLength);
        }
        return null;
    }

    private Object[] loadConstants(ClassFileReader reader) throws UTFDataFormatException {
        int count = reader.readUnsignedShort();
        if (count == 0) {
            return null;
        }
        if (this.constants.length < count) {
            this.constants = new Object[count];
        }
        block8: for (int i = 1; i < count; ++i) {
            byte tag = reader.readByte();
            switch (tag) {
                case 1: {
                    this.constants[i] = reader.readUTF8();
                    continue block8;
                }
                case 7: {
                    this.constants[i] = new ConstantClass(reader.readUnsignedShort());
                    continue block8;
                }
                case 8: 
                case 16: 
                case 19: 
                case 20: {
                    reader.skip(2);
                    continue block8;
                }
                case 15: {
                    reader.skip(3);
                    continue block8;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 17: 
                case 18: {
                    reader.skip(4);
                    continue block8;
                }
                case 5: 
                case 6: {
                    reader.skip(8);
                    ++i;
                    continue block8;
                }
                default: {
                    throw new ClassFileFormatException("Invalid constant pool entry");
                }
            }
        }
        return this.constants;
    }

    private static void skipAttributes(ClassFileReader reader) {
        int count = reader.readUnsignedShort();
        for (int i = 0; i < count; ++i) {
            reader.skip(2);
            int attributeLength = reader.readInt();
            reader.skip(attributeLength);
        }
    }

    private static String extractLocalClassName(String name) {
        if (Character.isDigit(name.charAt(0))) {
            int i;
            int len = name.length();
            for (i = 0; i < len && Character.isDigit(name.charAt(i)); ++i) {
            }
            return i == len ? null : name.substring(i);
        }
        return name;
    }

    @FunctionalInterface
    private static interface Function {
        public String apply(ClassFileReader var1, String var2, String var3) throws Exception;
    }
}

