/*
 * Decompiled with CFR 0.152.
 */
package org.idpf.epubcheck.util.css;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.idpf.epubcheck.util.css.CssToken;

final class CssTokenList
extends ArrayList<CssToken> {
    private static final long serialVersionUID = 924068097174100851L;

    public CssTokenList() {
        this(2048);
    }

    private CssTokenList(int initSize) {
        super(initSize);
    }

    CssTokenIterator iterator(Predicate<CssToken> filter) {
        return new CssTokenIterator(filter, this);
    }

    static final class PrematureEOFException
    extends RuntimeException {
        private static final long serialVersionUID = 343701466381708884L;

        PrematureEOFException() {
        }
    }

    static final class Filters {
        static final Predicate<CssToken> FILTER_S_CMNT = new Predicate<CssToken>(){

            @Override
            public boolean apply(CssToken input) {
                return input.type != CssToken.Type.S && input.type != CssToken.Type.COMMENT;
            }
        };
        static final Predicate<CssToken> FILTER_S_CMNT_CDO_CDC = new Predicate<CssToken>(){

            @Override
            public boolean apply(CssToken input) {
                return input.type != CssToken.Type.S && input.type != CssToken.Type.COMMENT && input.type != CssToken.Type.CDO && input.type != CssToken.Type.CDC;
            }
        };
        static final Predicate<CssToken> FILTER_NONE = new Predicate<CssToken>(){

            @Override
            public boolean apply(CssToken input) {
                return true;
            }
        };

        Filters() {
        }
    }

    class CssTokenIterator {
        private final Predicate<CssToken> filter;
        final List<CssToken> list;
        int next;
        int lastRet = -1;
        CssToken last = null;

        CssTokenIterator(Predicate<CssToken> filter, List<CssToken> list) {
            this.filter = Preconditions.checkNotNull(filter);
            this.list = list;
        }

        CssToken next() {
            return this.next(this.filter);
        }

        CssToken next(Predicate<CssToken> filter) {
            int i;
            CssToken tk;
            do {
                if ((i = this.next) >= CssTokenList.this.size()) {
                    throw new NoSuchElementException();
                }
                this.next = i + 1;
            } while (!filter.apply(tk = (CssToken)CssTokenList.this.get(this.lastRet = i)));
            this.last = tk;
            return tk;
        }

        boolean hasNext() {
            return this.hasNext(this.filter);
        }

        boolean hasNext(Predicate<CssToken> filter) {
            int i = this.next;
            while (i != CssTokenList.this.size()) {
                if (filter.apply((CssToken)CssTokenList.this.get(i))) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public CssToken peek() {
            return this.peek(this.filter);
        }

        public CssToken peek(Predicate<CssToken> filter) {
            int _next = this.next;
            int _lastRet = this.lastRet;
            CssToken _last = this.last;
            if (this.hasNext(filter)) {
                CssToken tk = this.next(filter);
                this.next = _next;
                this.lastRet = _lastRet;
                this.last = _last;
                return tk;
            }
            throw new NoSuchElementException();
        }

        int index() {
            return this.lastRet;
        }

        Predicate<CssToken> filter() {
            return this.filter;
        }
    }
}

