/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.samples.signature;

import java.security.Key;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.signature.ObjectContainer;
import org.apache.xml.security.signature.SignatureProperties;
import org.apache.xml.security.signature.SignatureProperty;
import org.apache.xml.security.signature.XMLSignature;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SignaturePropertiesSample {
    public static void main(String[] stringArray) throws Exception {
        Init.init();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        XMLSignature xMLSignature = new XMLSignature(document, null, "http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        document.appendChild(xMLSignature.getElement());
        SignatureProperty signatureProperty = new SignatureProperty(document, "http://www.xmlsecurity.org/#target", "prop1");
        signatureProperty.getElement().appendChild(document.createTextNode("\n   some data for this property\n"));
        SignatureProperties signatureProperties = new SignatureProperties(document);
        signatureProperties.addSignatureProperty(signatureProperty);
        ObjectContainer objectContainer = new ObjectContainer(document);
        objectContainer.appendChild((Node)document.createTextNode("\n"));
        objectContainer.appendChild((Node)signatureProperties.getElement());
        objectContainer.appendChild((Node)document.createTextNode("\n"));
        xMLSignature.appendObject(objectContainer);
        xMLSignature.addDocument("#prop1");
        String string = "secret";
        xMLSignature.getKeyInfo().addKeyName("The UTF-8 octets of \"" + string + "\" are used for signing (" + string.length() + " octets)");
        xMLSignature.sign((Key)xMLSignature.createSecretKey(string.getBytes()));
        Canonicalizer canonicalizer = Canonicalizer.getInstance((String)"http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
        System.out.println("---------------------------------------");
        System.out.println(new String(canonicalizer.canonicalizeSubtree((Node)document)));
        System.out.println("---------------------------------------");
        System.out.println(new String(xMLSignature.getSignedInfo().item(0).getTransformsOutput().getBytes()));
        System.out.println("---------------------------------------");
    }
}

