/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.debug;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.tools.Diagnostic;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.debug.OffsetProvider;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public class ErrorNode
extends AbstractNode
implements OffsetProvider {
    private CompilationInfo info;
    private Diagnostic diag;

    public ErrorNode(CompilationInfo info, Diagnostic diag) {
        super(Children.LEAF);
        this.info = info;
        this.diag = diag;
        String ss = diag.getMessage(Locale.ENGLISH);
        this.setDisplayName(diag.getCode() + " " + (Object)((Object)diag.getKind()) + ": " + ss);
        this.setIconBaseWithExtension("org/netbeans/modules/java/debug/resources/element.png");
    }

    public static Node getTree(CompilationInfo info) {
        ArrayList result = new ArrayList();
        new FindChildrenErrorVisitor(info).scan(result);
        Children.Array c = new Children.Array();
        c.add(result.toArray(new Node[0]));
        return new AbstractNode((Children)c);
    }

    @Override
    public int getStart() {
        return (int)this.diag.getStartPosition();
    }

    @Override
    public int getEnd() {
        return (int)this.diag.getEndPosition();
    }

    @Override
    public int getPreferredPosition() {
        return (int)this.diag.getPosition();
    }

    private static class FindChildrenErrorVisitor {
        private CompilationInfo info;

        public FindChildrenErrorVisitor(CompilationInfo info) {
            this.info = info;
        }

        private void scan(List<Node> result) {
            for (Diagnostic diag : this.info.getDiagnostics()) {
                result.add((Node)new ErrorNode(this.info, diag));
            }
        }
    }
}

