/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.debugger;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.util.LinkedHashSet;
import java.util.Set;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class VerticalGridLayout
implements LayoutManager2 {
    private final int screenHeight;
    private final Set<Component> components = new LinkedHashSet<Component>();

    public VerticalGridLayout() {
        TopComponent activated = TopComponent.getRegistry().getActivated();
        if (activated != null) {
            Rectangle screenParams = Utilities.getUsableScreenBounds((GraphicsConfiguration)activated.getGraphicsConfiguration());
            this.screenHeight = (int)((double)screenParams.height * 0.5);
        } else {
            this.screenHeight = (int)((double)WindowManager.getDefault().getMainWindow().getSize().height * 0.5);
        }
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        this.components.add(comp);
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        this.components.add(comp);
    }

    @Override
    public void layoutContainer(Container parent) {
        int x = 0;
        int y = 0;
        int cellWidth = this.getMaxCellWidth();
        for (Component c : this.components) {
            if (!c.isVisible()) continue;
            Dimension d = c.getPreferredSize();
            if (y + d.height > parent.getHeight()) {
                x += cellWidth;
                y = 0;
            }
            c.setBounds(x + 1, y + 1, cellWidth, d.height);
            y += d.height;
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return new Dimension(0, 0);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return this.layoutSize(parent);
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return this.layoutSize(target);
    }

    private Dimension layoutSize(Container target) {
        int height;
        int itemsPerColumn;
        int cols = 1;
        int componentCount = this.components.size();
        if (componentCount > (itemsPerColumn = this.screenHeight / this.getMaxCellHeight())) {
            cols = componentCount / itemsPerColumn;
            if (componentCount % itemsPerColumn != 0) {
                ++cols;
            }
            height = itemsPerColumn * this.getMaxCellHeight();
        } else {
            height = this.getMenuItemsHeight();
        }
        return new Dimension(cols * this.getMaxCellWidth() + 2, height + 2);
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        this.components.remove(comp);
    }

    private int getMaxCellHeight() {
        int cellHeight = 0;
        for (Component c : this.components) {
            if (c.getPreferredSize().height <= cellHeight) continue;
            cellHeight = c.getPreferredSize().height;
        }
        return cellHeight;
    }

    private int getMaxCellWidth() {
        int cellWidth = 0;
        for (Component c : this.components) {
            if (c.getPreferredSize().width <= cellWidth) continue;
            cellWidth = c.getPreferredSize().width;
        }
        return cellWidth;
    }

    private int getMenuItemsHeight() {
        int height = 0;
        for (Component c : this.components) {
            height += c.getPreferredSize().height;
        }
        return height;
    }
}

