/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.loader;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.CharConversionException;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.core.api.multiview.MultiViews;
import org.netbeans.modules.db.api.sql.execute.SQLExecuteCookie;
import org.netbeans.modules.db.core.SQLCoreUILogger;
import org.netbeans.modules.db.dataview.api.DataView;
import org.netbeans.modules.db.dataview.api.DataViewPageContext;
import org.netbeans.modules.db.sql.execute.SQLExecuteHelper;
import org.netbeans.modules.db.sql.execute.SQLExecutionResult;
import org.netbeans.modules.db.sql.execute.SQLExecutionResults;
import org.netbeans.modules.db.sql.loader.SQLCloneableEditor;
import org.netbeans.modules.db.sql.loader.SQLDataObject;
import org.netbeans.modules.db.sql.loader.SQLExecutionLoggerImpl;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.lookup.Lookups;
import org.openide.windows.CloneableOpenSupport;
import org.openide.windows.CloneableTopComponent;
import org.openide.xml.XMLUtil;

public class SQLEditorSupport
extends DataEditorSupport
implements OpenCookie,
EditCookie,
EditorCookie.Observable,
PrintCookie,
SQLExecuteCookie,
CloseCookie {
    private static final Logger LOGGER = Logger.getLogger(SQLEditorSupport.class.getName());
    private static final boolean LOG = LOGGER.isLoggable(Level.FINE);
    static final String EDITOR_CONTAINER = "sqlEditorContainer";
    private final PropertyChangeSupport sqlPropChangeSupport = new PropertyChangeSupport(this);
    private final RequestProcessor rp = new RequestProcessor("SQLExecution", 1, true);
    private volatile DatabaseConnection dbconn;
    private volatile boolean executing;
    private SQLExecutionResults executionResults;
    private SQLExecutionLoggerImpl logger;
    private final Object loggerLock = new Object();
    private final SaveCookie saveCookie = new SaveCookie(){

        public void save() throws IOException {
            SQLEditorSupport.this.saveDocument();
        }
    };

    public SQLEditorSupport(SQLDataObject obj) {
        super((DataObject)obj, null, (CloneableEditorSupport.Env)new Environment(obj));
        this.setMIMEType("text/x-sql");
        obj.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SQLEditorSupport.this.updateTitles();
            }
        });
    }

    protected boolean notifyModified() {
        SQLDataObject obj;
        if (!super.notifyModified()) {
            return false;
        }
        if (!this.isConsole() && (obj = (SQLDataObject)this.getDataObject()).getLookup().lookup(SaveCookie.class) == null) {
            obj.addCookie((Node.Cookie)this.saveCookie);
            obj.setModified(true);
        }
        return true;
    }

    protected void initializeCloneableEditor(CloneableEditor editor) {
        super.initializeCloneableEditor(editor);
        ((SQLCloneableEditor)editor).initialize();
    }

    protected CloneableEditorSupport.Pane createPane() {
        Object pane = this.getDataObject().getPrimaryFile().toURL().toExternalForm().startsWith("nbfs://") ? new SQLCloneableEditor(Lookups.fixed((Object[])new Object[]{this, this.getDataObject()})) : (CloneableEditorSupport.Pane)MultiViews.createCloneableMultiView((String)"text/x-sql", (Serializable)this.getDataObject());
        return pane;
    }

    protected boolean asynchronousOpen() {
        return false;
    }

    protected void notifyUnmodified() {
        super.notifyUnmodified();
        SQLDataObject obj = (SQLDataObject)this.getDataObject();
        Node.Cookie cookie = (Node.Cookie)obj.getLookup().lookup(SaveCookie.class);
        if (cookie != null && cookie.equals(this.saveCookie)) {
            obj.removeCookie((Node.Cookie)this.saveCookie);
            obj.setModified(false);
        }
    }

    protected String messageToolTip() {
        if (this.isConsole()) {
            DatabaseConnection dc = this.getDatabaseConnection();
            if (dc != null) {
                try {
                    return String.format("<html>%s<br>%s<br>JDBC-URL: %s</html>", XMLUtil.toAttributeValue((String)this.getDataObject().getPrimaryFile().getName()), XMLUtil.toAttributeValue((String)dc.getDisplayName()), XMLUtil.toAttributeValue((String)dc.getDatabaseURL()));
                }
                catch (CharConversionException ex) {
                    LOGGER.log(Level.WARNING, "", ex);
                    return this.getDataObject().getPrimaryFile().getName();
                }
            }
            return this.getDataObject().getPrimaryFile().getName();
        }
        return super.messageToolTip();
    }

    protected String messageName() {
        if (!this.isValid()) {
            return "";
        }
        if (this.isConsole()) {
            if (this.getDatabaseConnection() != null) {
                String connectionName = this.getDatabaseConnection().getDisplayName();
                if (connectionName.length() > 25) {
                    connectionName = connectionName.substring(0, 25) + "\u2026";
                }
                return NbBundle.getMessage(SQLEditorSupport.class, (String)"LBL_ConsoleWithConnection", (Object)this.getDataObject().getName(), (Object)connectionName);
            }
            return NbBundle.getMessage(SQLEditorSupport.class, (String)"LBL_Console", (Object)this.getDataObject().getName());
        }
        return super.messageName();
    }

    protected String messageHtmlName() {
        if (!this.isValid()) {
            return "";
        }
        if (this.isConsole()) {
            String name = this.messageName();
            if (name != null && !name.startsWith("<html>")) {
                name = "<html>" + name;
            }
            return name;
        }
        return super.messageHtmlName();
    }

    protected void notifyClosed() {
        super.notifyClosed();
        this.closeExecutionResult();
        this.closeLogger();
        if (this.isConsole() && this.isValid()) {
            try {
                this.getDataObject().delete();
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
    }

    protected boolean canClose() {
        if (this.isConsole()) {
            return true;
        }
        return super.canClose();
    }

    boolean isConsole() {
        return ((SQLDataObject)this.getDataObject()).isConsole();
    }

    boolean isValid() {
        return this.getDataObject().isValid();
    }

    protected Component wrapEditorComponent(Component editor) {
        JPanel container = new JPanel(new BorderLayout());
        container.setName(EDITOR_CONTAINER);
        container.add(editor, "Center");
        return container;
    }

    public void open() {
        SQLCoreUILogger.logEditorOpened();
        super.open();
    }

    public void edit() {
        SQLCoreUILogger.logEditorOpened();
        super.edit();
    }

    void addSQLPropertyChangeListener(PropertyChangeListener listener) {
        this.sqlPropChangeSupport.addPropertyChangeListener(listener);
    }

    void removeSQLPropertyChangeListener(PropertyChangeListener listener) {
        this.sqlPropChangeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void setDatabaseConnection(DatabaseConnection dbconn) {
        DatabaseConnection oldCon = this.dbconn;
        this.dbconn = dbconn;
        this.sqlPropChangeSupport.firePropertyChange("databaseConnection", oldCon, dbconn);
        this.updateTitles();
    }

    @Override
    public DatabaseConnection getDatabaseConnection() {
        return this.dbconn;
    }

    @Override
    public void execute() {
        String sql;
        StyledDocument doc = this.getDocument();
        if (doc == null) {
            return;
        }
        try {
            sql = doc.getText(0, doc.getLength());
        }
        catch (BadLocationException e) {
            Logger.getLogger("global").log(Level.INFO, null, e);
            sql = "";
        }
        this.execute(sql, 0, sql.length(), null);
    }

    public void saveAs(FileObject folder, String fileName) throws IOException {
        String fn = FileUtil.getFileDisplayName((FileObject)folder) + File.separator + fileName;
        File existingFile = FileUtil.normalizeFile((File)new File(fn));
        if (existingFile.exists()) {
            NotifyDescriptor.Confirmation confirm = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(SQLEditorSupport.class, (String)"MSG_ConfirmReplace", (Object)fileName), NbBundle.getMessage(SQLEditorSupport.class, (String)"MSG_ConfirmReplaceFileTitle"), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)confirm);
            if (!confirm.getValue().equals(NotifyDescriptor.YES_OPTION)) {
                return;
            }
        }
        if (this.isConsole()) {
            this.saveDocument();
        }
        super.saveAs(folder, fileName);
    }

    void execute(String sql, int startOffset, int endOffset, SQLCloneableEditor editor) {
        DatabaseConnection conn = this.dbconn;
        if (conn == null) {
            return;
        }
        SQLExecutor executor = new SQLExecutor(this, conn, sql, startOffset, endOffset, editor);
        RequestProcessor.Task task = this.rp.create((Runnable)executor);
        executor.setTask(task);
        task.schedule(0);
        if (sql.toUpperCase().indexOf("CREATE") != -1 || sql.toUpperCase().indexOf("DROP") != -1) {
            task.addTaskListener(new TaskListener(){

                public void taskFinished(Task task) {
                    task.removeTaskListener((TaskListener)this);
                    SQLEditorSupport.this.refresh();
                }
            });
        }
    }

    boolean isExecuting() {
        return this.executing;
    }

    private void setExecuting(boolean executing) {
        boolean oldExecuting = this.executing;
        this.executing = executing;
        this.sqlPropChangeSupport.firePropertyChange("executing", oldExecuting, this.executing);
    }

    private void setResultsToEditors(final SQLExecutionResults results, final SQLCloneableEditor editor) {
        Mutex.EVENT.writeAccess(new Runnable(){

            @Override
            public void run() {
                ArrayList<Component> components = null;
                if (results != null) {
                    components = new ArrayList<Component>();
                    for (SQLExecutionResult result : results.getResults()) {
                        for (Component component : result.getDataView().createComponents()) {
                            components.add(component);
                        }
                    }
                }
                if (editor != null) {
                    editor.setResults(components);
                } else {
                    Enumeration editors = SQLEditorSupport.this.allEditors.getComponents();
                    while (editors.hasMoreElements()) {
                        CloneableTopComponent editor2 = (CloneableTopComponent)editors.nextElement();
                        SQLCloneableEditor ce = (SQLCloneableEditor)((Object)editor2.getLookup().lookup(SQLCloneableEditor.class));
                        if (ce == null) continue;
                        ce.setResults(components);
                    }
                }
            }
        });
    }

    private void setExecutionResults(SQLExecutionResults executionResults) {
        this.executionResults = executionResults;
    }

    private void closeExecutionResult() {
        this.setResultsToEditors(null, null);
        Runnable run = new Runnable(){

            @Override
            public void run() {
                if (SQLEditorSupport.this.executionResults != null) {
                    SQLEditorSupport.this.executionResults = null;
                }
            }
        };
        if (this.rp.isRequestProcessorThread()) {
            run.run();
        } else {
            this.rp.post(run);
        }
    }

    private void refresh() {
        if (this.dbconn == null) {
            return;
        }
        ConnectionManager.getDefault().refreshConnectionInExplorer(this.dbconn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SQLExecutionLoggerImpl createLogger() {
        Object object = this.loggerLock;
        synchronized (object) {
            this.closeLogger();
            String loggerDisplayName = this.isConsole() ? this.getDataObject().getName() : this.getDataObject().getNodeDelegate().getDisplayName();
            return new SQLExecutionLoggerImpl(loggerDisplayName, (LineCookie)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void closeLogger() {
        Object object = this.loggerLock;
        synchronized (object) {
            if (this.logger != null) {
                this.logger.close();
            }
        }
    }

    static final class Environment
    extends DataEditorSupport.Env {
        public static final long serialVersionUID = 7968926994844480435L;
        private transient boolean modified = false;
        private transient FileLock fileLock;

        public Environment(SQLDataObject obj) {
            super((DataObject)obj);
        }

        protected FileObject getFile() {
            return this.getDataObject().getPrimaryFile();
        }

        protected FileLock takeLock() throws IOException {
            MultiDataObject obj = (MultiDataObject)this.getDataObject();
            this.fileLock = obj.getPrimaryEntry().takeLock();
            return this.fileLock;
        }

        public void markModified() throws IOException {
            if (this.findSQLEditorSupport().isConsole()) {
                this.modified = true;
            } else {
                super.markModified();
            }
        }

        public void unmarkModified() {
            if (this.findSQLEditorSupport().isConsole()) {
                this.modified = false;
                if (this.fileLock != null && this.fileLock.isValid()) {
                    this.fileLock.releaseLock();
                }
            } else {
                super.unmarkModified();
            }
        }

        public boolean isModified() {
            if (this.findSQLEditorSupport().isConsole()) {
                return this.modified;
            }
            return super.isModified();
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return this.findSQLEditorSupport();
        }

        private SQLEditorSupport findSQLEditorSupport() {
            return (SQLEditorSupport)this.getDataObject().getLookup().lookup(SQLEditorSupport.class);
        }
    }

    private static final class SQLExecutor
    implements Runnable,
    Cancellable {
        private final SQLCloneableEditor editor;
        private final SQLEditorSupport parent;
        private final DatabaseConnection dbconn;
        private final String sql;
        private final int startOffset;
        private final int endOffset;
        private RequestProcessor.Task task;

        public SQLExecutor(SQLEditorSupport parent, DatabaseConnection dbconn, String sql, int startOffset, int endOffset, SQLCloneableEditor editor) {
            assert (parent != null);
            assert (dbconn != null);
            assert (sql != null);
            this.parent = parent;
            this.dbconn = dbconn;
            this.sql = sql;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.editor = editor;
        }

        public void setTask(RequestProcessor.Task task) {
            this.task = task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            assert (this.task != null) : "Should have called setTask()";
            this.parent.setExecuting(true);
            try {
                if (LOG) {
                    LOGGER.log(Level.FINE, "Started the SQL execution task");
                    LOGGER.log(Level.FINE, "Executing against " + this.dbconn);
                }
                Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<Void>(){

                    public Void run() {
                        ConnectionManager.getDefault().showConnectionDialog(SQLExecutor.this.dbconn);
                        return null;
                    }
                });
                Connection conn = this.dbconn.getJDBCConnection();
                if (LOG) {
                    LOGGER.log(Level.FINE, "SQL connection: " + conn);
                }
                if (conn == null) {
                    return;
                }
                try {
                    Mutex.EVENT.readAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                        public Void run() throws Exception {
                            SQLExecutor.this.parent.saveDocument();
                            return null;
                        }
                    });
                }
                catch (MutexException e) {
                    Exceptions.printStackTrace((Throwable)e.getException());
                    this.parent.setExecuting(false);
                    return;
                }
                ProgressHandle handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(SQLEditorSupport.class, (String)"LBL_ExecutingStatements"), (Cancellable)this);
                handle.start();
                try {
                    handle.switchToIndeterminate();
                    this.setStatusText("");
                    if (LOG) {
                        LOGGER.log(Level.FINE, "Closing the old execution result");
                    }
                    int pageSize = -1;
                    if (this.parent.executionResults != null && this.parent.executionResults.size() > 0) {
                        for (SQLExecutionResult res : this.parent.executionResults.getResults()) {
                            int ps = DataViewPageContext.getPageSize((DataView)res.getDataView());
                            pageSize = pageSize < ps ? ps : pageSize;
                        }
                    }
                    if (pageSize == -1) {
                        pageSize = DataViewPageContext.getStoredPageSize();
                    }
                    this.parent.closeExecutionResult();
                    SQLExecutionLoggerImpl logger = this.parent.createLogger();
                    SQLExecutionResults executionResults = SQLExecuteHelper.execute(this.sql, this.startOffset, this.endOffset, this.dbconn, logger, pageSize);
                    this.handleExecutionResults(executionResults, logger);
                }
                finally {
                    handle.finish();
                }
            }
            finally {
                this.parent.setExecuting(false);
            }
        }

        private void handleExecutionResults(SQLExecutionResults executionResults, SQLExecutionLoggerImpl logger) {
            if (executionResults == null) {
                this.setStatusText(NbBundle.getMessage(SQLEditorSupport.class, (String)"LBL_ExecutionCancelled"));
                return;
            }
            this.parent.setExecutionResults(executionResults);
            if (executionResults.size() <= 0) {
                this.setStatusText(NbBundle.getMessage(SQLEditorSupport.class, (String)"LBL_ExecutedSuccessfully"));
                return;
            }
            this.parent.setResultsToEditors(executionResults, this.editor);
            if (executionResults.hasExceptions()) {
                this.setStatusText(NbBundle.getMessage(SQLEditorSupport.class, (String)"LBL_ExecutionFinishedWithErrors"));
            } else {
                this.setStatusText(NbBundle.getMessage(SQLEditorSupport.class, (String)"LBL_ExecutedSuccessfully"));
            }
        }

        private void setStatusText(String statusText) {
            StatusDisplayer.getDefault().setStatusText(statusText);
        }

        public boolean cancel() {
            return this.task.cancel();
        }
    }
}

