/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api.builtin.stringvalidation;

import java.net.MalformedURLException;
import java.net.URL;
import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.builtin.stringvalidation.EmailAddressValidator;
import org.netbeans.validation.api.builtin.stringvalidation.StringValidator;
import org.netbeans.validation.api.builtin.stringvalidation.ValidHostNameOrIPValidator;
import org.openide.util.NbBundle;

class UrlValidator
extends StringValidator {
    UrlValidator() {
    }

    @Override
    public void validate(Problems problems, String compName, String model) {
        try {
            URL url = new URL(model);
            String host = url.getHost();
            if (!"".equals(host)) {
                new ValidHostNameOrIPValidator(true).validate(problems, compName, host);
                return;
            }
            String protocol = url.getProtocol();
            if ("mailto".equals(protocol)) {
                String emailAddress = url.toString().substring("mailto:".length());
                emailAddress = emailAddress == null ? "" : emailAddress;
                new EmailAddressValidator().validate(problems, compName, emailAddress);
                return;
            }
        }
        catch (MalformedURLException e) {
            String problem = NbBundle.getMessage(UrlValidator.class, (String)"URL_NOT_VALID", (Object)model);
            problems.add(problem);
        }
    }
}

