/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.editor;

import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.db.sql.lexer.LexerUtilities;
import org.netbeans.modules.db.sql.lexer.SQLLexer;
import org.netbeans.modules.db.sql.lexer.SQLTokenId;
import org.netbeans.spi.editor.bracesmatching.BracesMatcher;
import org.netbeans.spi.editor.bracesmatching.BracesMatcherFactory;
import org.netbeans.spi.editor.bracesmatching.MatcherContext;

public class SQLBracesMatcher
implements BracesMatcher {
    private MatcherContext context;

    public SQLBracesMatcher(MatcherContext context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] findOrigin() throws InterruptedException, BadLocationException {
        int[] ret = null;
        ((AbstractDocument)this.context.getDocument()).readLock();
        try {
            BaseDocument doc = (BaseDocument)this.context.getDocument();
            int offset = this.context.getSearchOffset();
            TokenSequence<SQLTokenId> ts = LexerUtilities.getTokenSequence((Document)doc, offset);
            if (ts != null) {
                Token token;
                ts.move(offset);
                if (ts.moveNext() && (token = ts.token()) != null) {
                    TokenId id = token.id();
                    if (id == SQLTokenId.LPAREN || id == SQLTokenId.RPAREN) {
                        ret = new int[]{ts.offset(), ts.offset() + token.length()};
                    } else if (id == SQLTokenId.IDENTIFIER || id == SQLTokenId.STRING) {
                        int startOffset = ts.offset();
                        int endOffset = ts.offset() + token.length() - 1;
                        char startChar = token.text().charAt(0);
                        char endChar = token.text().charAt(token.length() - 1);
                        if (offset == startOffset && SQLLexer.isEndIdentifierQuoteChar(startChar, endChar)) {
                            ret = new int[]{startOffset, startOffset + 1};
                        } else if (offset == endOffset && SQLLexer.isEndIdentifierQuoteChar(startChar, endChar)) {
                            ret = new int[]{endOffset, endOffset + 1};
                        } else if (startChar == '\'' && endChar == '\'') {
                            if (offset == startOffset) {
                                ret = new int[]{startOffset, startOffset + 1};
                            } else if (offset == endOffset) {
                                ret = new int[]{endOffset, endOffset + 1};
                            }
                        }
                    }
                }
            }
        }
        finally {
            ((AbstractDocument)this.context.getDocument()).readUnlock();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] findMatches() throws InterruptedException, BadLocationException {
        int[] ret = null;
        ((AbstractDocument)this.context.getDocument()).readLock();
        try {
            BaseDocument doc = (BaseDocument)this.context.getDocument();
            int offset = this.context.getSearchOffset();
            TokenSequence<SQLTokenId> ts = LexerUtilities.getTokenSequence((Document)doc, offset);
            if (ts != null) {
                Token token;
                ts.move(offset);
                if (ts.moveNext() && (token = ts.token()) != null) {
                    TokenId id = token.id();
                    if (id == SQLTokenId.LPAREN) {
                        OffsetRange r = LexerUtilities.findFwd(ts, SQLTokenId.LPAREN.ordinal(), SQLTokenId.RPAREN.ordinal());
                        ret = new int[]{r.getStart(), r.getEnd()};
                    } else if (id == SQLTokenId.RPAREN) {
                        OffsetRange r = LexerUtilities.findBwd(ts, SQLTokenId.LPAREN.ordinal(), SQLTokenId.RPAREN.ordinal());
                        ret = new int[]{r.getStart(), r.getEnd()};
                    } else if (id == SQLTokenId.IDENTIFIER || id == SQLTokenId.STRING) {
                        int startOffset = ts.offset();
                        int endOffset = ts.offset() + token.length() - 1;
                        char startChar = token.text().charAt(0);
                        char endChar = token.text().charAt(token.length() - 1);
                        if (offset == startOffset && SQLLexer.isEndIdentifierQuoteChar(startChar, endChar)) {
                            ret = new int[]{endOffset, endOffset + 1};
                        } else if (offset == endOffset && SQLLexer.isEndIdentifierQuoteChar(startChar, endChar)) {
                            ret = new int[]{startOffset, startOffset + 1};
                        } else if (startChar == '\'' && endChar == '\'') {
                            if (offset == startOffset) {
                                ret = new int[]{endOffset, endOffset + 1};
                            } else if (offset == endOffset) {
                                ret = new int[]{startOffset, startOffset + 1};
                            }
                        }
                    }
                }
            }
        }
        finally {
            ((AbstractDocument)this.context.getDocument()).readUnlock();
        }
        return ret;
    }

    public static class Factory
    implements BracesMatcherFactory {
        public SQLBracesMatcher createMatcher(MatcherContext context) {
            return new SQLBracesMatcher(context);
        }
    }
}

