/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.apisupport;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.validation.adapters.WizardDescriptorAdapter;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.archetype.Archetype;
import org.netbeans.modules.maven.api.archetype.ArchetypeWizards;
import org.netbeans.modules.maven.api.archetype.ProjectInfo;
import org.netbeans.modules.maven.apisupport.AddOSGiParamToNbmPluginConfiguration;
import org.netbeans.modules.maven.apisupport.Bundle;
import org.netbeans.modules.maven.apisupport.NBMNativeMWI;
import org.netbeans.modules.maven.apisupport.NbmWizardPanel;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Repository;
import org.netbeans.validation.api.ui.ValidationGroup;
import org.netbeans.validation.api.ui.ValidationItem;
import org.netbeans.validation.api.ui.ValidationUI;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class NbmWizardIterator
implements WizardDescriptor.BackgroundInstantiatingIterator<WizardDescriptor> {
    public static final String NBM_ARTIFACTID = "nbm_artifactId";
    static final Archetype NB_MODULE_ARCH = new Archetype();
    static final Archetype NB_APP_ARCH;
    public static final String SNAPSHOT_VERSION = "dev-SNAPSHOT";
    static final String OSGIDEPENDENCIES = "osgi.dependencies";
    static final String NB_VERSION = "nb.version";
    private int index;
    private WizardDescriptor.Panel<WizardDescriptor>[] panels;
    private WizardDescriptor wiz;
    private final Archetype archetype;
    private final String title;

    private NbmWizardIterator(Archetype archetype, String title) {
        this.archetype = archetype;
        this.title = title;
    }

    public static NbmWizardIterator createNbModuleIterator() {
        return new NbmWizardIterator(NB_MODULE_ARCH, Bundle.template_module());
    }

    public static NbmWizardIterator createNbAppIterator() {
        return new NbmWizardIterator(NB_APP_ARCH, Bundle.template_app());
    }

    private WizardDescriptor.Panel<WizardDescriptor>[] createPanels(ValidationGroup enabledVG, ValidationGroup errorMsgVG) {
        return new WizardDescriptor.Panel[]{ArchetypeWizards.basicWizardPanel((ValidationGroup)errorMsgVG, (boolean)false, (Archetype)this.archetype), new NbmWizardPanel(enabledVG, errorMsgVG, this.archetype)};
    }

    private String[] createSteps() {
        return new String[]{Bundle.LBL_CreateProjectStep2(), Bundle.LBL_CreateProjectStepNbm()};
    }

    public Set<FileObject> instantiate() throws IOException {
        Project prj;
        ProjectInfo vi = new ProjectInfo((String)this.wiz.getProperty("groupId"), (String)this.wiz.getProperty("artifactId"), (String)this.wiz.getProperty("version"), (String)this.wiz.getProperty("package"));
        ArchetypeWizards.logUsage((String)this.archetype.getGroupId(), (String)this.archetype.getArtifactId(), (String)this.archetype.getVersion());
        String nbm_artifactId = (String)this.wiz.getProperty(NBM_ARTIFACTID);
        File projFile = FileUtil.normalizeFile((File)((File)this.wiz.getProperty("projdir")));
        String version = (String)this.wiz.getProperty(NB_VERSION);
        assert (version != null);
        Map<String, String> additional = Collections.singletonMap("netbeansVersion", version);
        if (this.archetype == NB_MODULE_ARCH) {
            NBMNativeMWI.instantiate(vi, projFile, version, Boolean.TRUE.equals(this.wiz.getProperty(OSGIDEPENDENCIES)), null);
        } else {
            FileObject pom;
            FileObject prjDir;
            ModelOperation<POMModel> osgi;
            ArchetypeWizards.createFromArchetype((File)projFile, (ProjectInfo)vi, (Archetype)this.archetype, additional, (boolean)true);
            ArrayList<ModelOperation<POMModel>> opers = new ArrayList<ModelOperation<POMModel>>();
            if (Boolean.TRUE.equals(this.wiz.getProperty(OSGIDEPENDENCIES)) && (osgi = NbmWizardIterator.addNbmPluginOsgiParameter(projFile)) != null) {
                opers.add(osgi);
            }
            if (SNAPSHOT_VERSION.equals(version)) {
                opers.add(NbmWizardIterator.addSnapshotRepo());
            }
            if (!opers.isEmpty() && (prjDir = FileUtil.toFileObject((File)projFile)) != null && (pom = prjDir.getFileObject("pom.xml")) != null && (prj = ProjectManager.getDefault().findProject(prjDir)) != null) {
                Utilities.performPOMModelOperations((FileObject)pom, opers);
            }
            if (nbm_artifactId != null && projFile.exists()) {
                Project p = ProjectManager.getDefault().findProject(FileUtil.toFileObject((File)projFile));
                MavenProject mp = ((NbMavenProject)p.getLookup().lookup(NbMavenProject.class)).loadAlternateMavenProject(EmbedderFactory.getProjectEmbedder(), Collections.emptyList(), null);
                ProjectInfo nbm = new ProjectInfo(vi.groupId, nbm_artifactId, vi.version, vi.packageName);
                File nbm_folder = FileUtil.normalizeFile((File)new File(projFile, nbm_artifactId));
                NBMNativeMWI.instantiate(nbm, nbm_folder, version, Boolean.TRUE.equals(this.wiz.getProperty(OSGIDEPENDENCIES)), mp);
                if (this.archetype == NB_APP_ARCH) {
                    File appDir = new File(projFile, "application");
                    NbmWizardIterator.addModuleToApplication(appDir, new ProjectInfo("${project.groupId}", nbm.artifactId, "${project.version}", nbm.packageName), null);
                }
            }
        }
        Set projects = ArchetypeWizards.openProjects((File)projFile, (File)new File(projFile, "application"));
        for (FileObject project : projects) {
            NbMavenProject mprj;
            prj = ProjectManager.getDefault().findProject(project);
            if (prj != null && (mprj = (NbMavenProject)prj.getLookup().lookup(NbMavenProject.class)) != null) continue;
        }
        return projects;
    }

    public void initialize(WizardDescriptor wiz) {
        this.index = 0;
        ValidationGroup enabledVG = ValidationGroup.create((ValidationUI[])new ValidationUI[]{new WizardDescriptorAdapter(wiz, WizardDescriptorAdapter.Type.VALID)});
        ValidationGroup errorMsgVG = ValidationGroup.create((ValidationUI[])new ValidationUI[]{new WizardDescriptorAdapter(wiz, WizardDescriptorAdapter.Type.MESSAGE)});
        enabledVG.addItem((ValidationItem)errorMsgVG, false);
        this.panels = this.createPanels(enabledVG, errorMsgVG);
        this.wiz = wiz;
        wiz.putProperty("NewProjectWizard_Title", (Object)this.title);
        String[] steps = this.createSteps();
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    public void uninitialize(WizardDescriptor wiz) {
        this.panels = null;
    }

    public String name() {
        return Bundle.NameFormat(this.index + 1, this.panels.length);
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener l) {
    }

    public final void removeChangeListener(ChangeListener l) {
    }

    private static ModelOperation<POMModel> addNbmPluginOsgiParameter(File projFile) throws IOException {
        FileObject pom;
        FileObject prjDir = FileUtil.toFileObject((File)projFile);
        if (prjDir != null && (pom = prjDir.getFileObject("pom.xml")) != null) {
            Project prj = ProjectManager.getDefault().findProject(prjDir);
            if (prj == null) {
                return null;
            }
            NbMavenProject mav = (NbMavenProject)prj.getLookup().lookup(NbMavenProject.class);
            return new AddOSGiParamToNbmPluginConfiguration(true, mav.getMavenProject());
        }
        return null;
    }

    private static ModelOperation<POMModel> addSnapshotRepo() throws IOException {
        return new ModelOperation<POMModel>(){

            public void performOperation(POMModel model) {
                Repository repo = model.getFactory().createRepository();
                repo.setId("apache.snapshots");
                repo.setName("Apache Development Snapshot Repository");
                repo.setUrl("https://repository.apache.org/content/repositories/snapshots/");
                model.getProject().addRepository(repo);
            }
        };
    }

    private static void addModuleToApplication(File file, ProjectInfo nbm, Object object) {
        FileObject appPrjFO = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        if (appPrjFO == null) {
            return;
        }
        ArrayList<ModelOperation> operations = new ArrayList<ModelOperation>();
        operations.add(ArchetypeWizards.addDependencyOperation((ProjectInfo)nbm, null));
        Utilities.performPOMModelOperations((FileObject)appPrjFO.getFileObject("pom.xml"), operations);
    }

    static {
        NB_MODULE_ARCH.setGroupId("org.apache.netbeans.archetypes");
        NB_MODULE_ARCH.setVersion("1.16");
        NB_MODULE_ARCH.setArtifactId("nbm-archetype");
        NB_APP_ARCH = new Archetype();
        NB_APP_ARCH.setGroupId("org.apache.netbeans.archetypes");
        NB_APP_ARCH.setVersion("1.21");
        NB_APP_ARCH.setArtifactId("netbeans-platform-app-archetype");
    }
}

