/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import javax.swing.Icon;
import org.openide.util.CachedHiDPIIcon;
import org.openide.util.Parameters;

final class FilteredIcon
extends CachedHiDPIIcon {
    private final RGBImageFilter filter;
    private final Icon delegate;

    private FilteredIcon(RGBImageFilter filter, Icon delegate) {
        super(delegate.getIconWidth(), delegate.getIconHeight());
        Parameters.notNull((CharSequence)"filter", (Object)filter);
        Parameters.notNull((CharSequence)"delegate", (Object)delegate);
        this.filter = filter;
        this.delegate = delegate;
    }

    public static Icon create(RGBImageFilter filter, Icon delegate) {
        return new FilteredIcon(filter, delegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Image createImage(Component c, GraphicsConfiguration graphicsConfiguration, int deviceWidth, int deviceHeight, double scale) {
        BufferedImage img = graphicsConfiguration.createCompatibleImage(deviceWidth, deviceHeight, 3);
        Graphics2D imgG = img.createGraphics();
        try {
            imgG.clip(new Rectangle(0, 0, img.getWidth(), img.getHeight()));
            imgG.scale(scale, scale);
            this.delegate.paintIcon(c, imgG, 0, 0);
        }
        finally {
            imgG.dispose();
        }
        return Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(img.getSource(), this.filter));
    }
}

