/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.regions.variables;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.nodes.DeclareVariablesAttr;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.CodeVar;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.args.SSAVar;
import jadx.core.dex.nodes.IBlock;
import jadx.core.dex.nodes.IContainer;
import jadx.core.dex.nodes.IRegion;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.regions.loops.LoopRegion;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.regions.DepthRegionTraversal;
import jadx.core.dex.visitors.regions.variables.CollectUsageRegionVisitor;
import jadx.core.dex.visitors.regions.variables.UsePlace;
import jadx.core.dex.visitors.regions.variables.VarUsage;
import jadx.core.utils.RegionUtils;
import jadx.core.utils.Utils;
import jadx.core.utils.exceptions.JadxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessVariables
extends AbstractVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessVariables.class);

    @Override
    public void visit(MethodNode mth) throws JadxException {
        if (mth.isNoCode() || mth.getSVars().isEmpty()) {
            return;
        }
        List<CodeVar> codeVars = this.collectCodeVars(mth);
        if (codeVars.isEmpty()) {
            return;
        }
        this.checkCodeVars(mth, codeVars);
        CollectUsageRegionVisitor usageCollector = new CollectUsageRegionVisitor();
        DepthRegionTraversal.traverse(mth, usageCollector);
        Map<SSAVar, VarUsage> ssaUsageMap = usageCollector.getUsageMap();
        if (ssaUsageMap.isEmpty()) {
            return;
        }
        Map<CodeVar, List<VarUsage>> codeVarUsage = this.mergeUsageMaps(codeVars, ssaUsageMap);
        for (Map.Entry<CodeVar, List<VarUsage>> entry : codeVarUsage.entrySet()) {
            this.declareVar(mth, entry.getKey(), entry.getValue());
        }
    }

    private void checkCodeVars(MethodNode mth, List<CodeVar> codeVars) {
        int unknownTypesCount = 0;
        for (CodeVar codeVar : codeVars) {
            codeVar.getSsaVars().stream().filter(ssaVar -> ssaVar.contains(AFlag.IMMUTABLE_TYPE)).forEach(ssaVar -> {
                ArgType ssaType = ssaVar.getAssign().getInitType();
                if (ssaType.isTypeKnown() && !ssaType.equals(codeVar.getType())) {
                    mth.addWarn("Incorrect type for immutable var: ssa=" + ssaType + ", code=" + codeVar.getType() + ", for " + ssaVar.getDetailedVarInfo(mth));
                }
            });
            if (codeVar.getType() != null) continue;
            codeVar.setType(ArgType.UNKNOWN);
            ++unknownTypesCount;
        }
        if (unknownTypesCount != 0) {
            mth.addWarn("Unknown variable types count: " + unknownTypesCount);
        }
    }

    private void declareVar(MethodNode mth, CodeVar codeVar, List<VarUsage> usageList) {
        if (codeVar.isDeclared()) {
            return;
        }
        VarUsage mergedUsage = new VarUsage(null);
        for (VarUsage varUsage : usageList) {
            mergedUsage.getAssigns().addAll(varUsage.getAssigns());
            mergedUsage.getUses().addAll(varUsage.getUses());
        }
        if (mergedUsage.getAssigns().isEmpty() && mergedUsage.getUses().isEmpty()) {
            return;
        }
        if (this.checkDeclareAtAssign(usageList, mergedUsage)) {
            return;
        }
        ProcessVariables.declareVarInRegion(mth.getRegion(), codeVar);
    }

    private List<CodeVar> collectCodeVars(MethodNode mth) {
        List list;
        CodeVar codeVar;
        LinkedHashMap<CodeVar, List> codeVars = new LinkedHashMap<CodeVar, List>();
        for (SSAVar sSAVar : mth.getSVars()) {
            if (sSAVar.getCodeVar().isThis()) continue;
            codeVar = sSAVar.getCodeVar();
            list = codeVars.computeIfAbsent(codeVar, k -> new ArrayList());
            list.add(sSAVar);
        }
        for (Map.Entry entry : codeVars.entrySet()) {
            codeVar = (CodeVar)entry.getKey();
            list = (List)entry.getValue();
            for (SSAVar ssaVar : list) {
                CodeVar localCodeVar = ssaVar.getCodeVar();
                codeVar.mergeFlagsFrom(localCodeVar);
            }
            if (list.size() > 1) {
                for (SSAVar ssaVar : list) {
                    ssaVar.setCodeVar(codeVar);
                }
            }
            codeVar.setSsaVars(list);
        }
        return new ArrayList<CodeVar>(codeVars.keySet());
    }

    private Map<CodeVar, List<VarUsage>> mergeUsageMaps(List<CodeVar> codeVars, Map<SSAVar, VarUsage> ssaUsageMap) {
        LinkedHashMap<CodeVar, List<VarUsage>> codeVarUsage = new LinkedHashMap<CodeVar, List<VarUsage>>(codeVars.size());
        for (CodeVar codeVar : codeVars) {
            ArrayList<VarUsage> list = new ArrayList<VarUsage>();
            for (SSAVar ssaVar : codeVar.getSsaVars()) {
                VarUsage usage = ssaUsageMap.get(ssaVar);
                if (usage == null) continue;
                list.add(usage);
            }
            codeVarUsage.put(codeVar, Utils.lockList(list));
        }
        return codeVarUsage;
    }

    private boolean checkDeclareAtAssign(List<VarUsage> list, VarUsage mergedUsage) {
        if (mergedUsage.getAssigns().isEmpty()) {
            return false;
        }
        for (VarUsage u : list) {
            for (UsePlace assign : u.getAssigns()) {
                if (!ProcessVariables.canDeclareAt(mergedUsage, assign)) continue;
                return ProcessVariables.checkDeclareAtAssign(u.getVar());
            }
        }
        return false;
    }

    private static boolean canDeclareAt(VarUsage usage, UsePlace usePlace) {
        IRegion region = usePlace.getRegion();
        if (region instanceof LoopRegion) {
            for (UsePlace use : usage.getAssigns()) {
                if (RegionUtils.isRegionContainsRegion(region, use.getRegion())) continue;
                return false;
            }
        }
        if (region.contains(AFlag.ELSE_IF_CHAIN)) {
            return false;
        }
        return ProcessVariables.isAllUseAfter(usePlace, usage.getAssigns()) && ProcessVariables.isAllUseAfter(usePlace, usage.getUses());
    }

    private static boolean isAllUseAfter(UsePlace checkPlace, List<UsePlace> usePlaces) {
        IRegion region = checkPlace.getRegion();
        IBlock block = checkPlace.getBlock();
        HashSet<UsePlace> toCheck = new HashSet<UsePlace>(usePlaces);
        boolean blockFound = false;
        for (IContainer subBlock : region.getSubBlocks()) {
            if (!blockFound && subBlock == block) {
                blockFound = true;
            }
            if (!blockFound) continue;
            toCheck.removeIf(usePlace -> ProcessVariables.isContainerContainsUsePlace(subBlock, usePlace));
            if (!toCheck.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private static boolean isContainerContainsUsePlace(IContainer subBlock, UsePlace usePlace) {
        if (subBlock == usePlace.getBlock()) {
            return true;
        }
        if (subBlock instanceof IRegion) {
            return RegionUtils.isRegionContainsRegion(subBlock, usePlace.getRegion());
        }
        return false;
    }

    private static boolean checkDeclareAtAssign(SSAVar var) {
        RegisterArg arg = var.getAssign();
        InsnNode parentInsn = arg.getParentInsn();
        if (parentInsn == null) {
            return false;
        }
        if (!arg.equals(parentInsn.getResult())) {
            return false;
        }
        parentInsn.add(AFlag.DECLARE_VAR);
        return true;
    }

    private static void declareVarInRegion(IContainer region, CodeVar var) {
        if (var.isDeclared()) {
            LOG.warn("Try to declare already declared variable: {}", (Object)var);
            return;
        }
        DeclareVariablesAttr dv = region.get(AType.DECLARE_VARIABLES);
        if (dv == null) {
            dv = new DeclareVariablesAttr();
            region.addAttr(dv);
        }
        dv.addVar(var);
        var.setDeclared(true);
    }
}

