/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.debuginfo;

import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.nodes.DexNode;
import jadx.core.utils.InsnUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LocalVar {
    private static final Logger LOG = LoggerFactory.getLogger(LocalVar.class);
    private final int regNum;
    private final String name;
    private final ArgType type;
    private boolean isEnd;
    private int startAddr;
    private int endAddr;

    public LocalVar(DexNode dex, int rn, int nameId, int typeId, int signId) {
        this(rn, dex.getString(nameId), dex.getType(typeId), dex.getString(signId));
    }

    public LocalVar(int regNum, String name, ArgType type) {
        this(regNum, name, type, null);
    }

    public LocalVar(int regNum, String name, ArgType type, String sign) {
        this.regNum = regNum;
        this.name = name;
        if (sign != null) {
            try {
                ArgType gType = ArgType.generic(sign);
                if (this.checkSignature(type, gType)) {
                    type = gType;
                }
            }
            catch (Exception e) {
                LOG.error("Can't parse signature for local variable: {}", (Object)sign, (Object)e);
            }
        }
        this.type = type;
    }

    private boolean checkSignature(ArgType type, ArgType gType) {
        boolean apply;
        ArgType el = gType.getArrayRootElement();
        if (el.isGeneric()) {
            if (!type.getArrayRootElement().getObject().equals(el.getObject())) {
                LOG.warn("Generic type in debug info not equals: {} != {}", (Object)type, (Object)gType);
            }
            apply = true;
        } else {
            apply = el.isGenericType();
        }
        return apply;
    }

    public void start(int addr) {
        this.isEnd = false;
        this.startAddr = addr;
    }

    public boolean end(int addr) {
        if (this.isEnd) {
            return false;
        }
        this.isEnd = true;
        this.endAddr = addr;
        return true;
    }

    public int getRegNum() {
        return this.regNum;
    }

    public String getName() {
        return this.name;
    }

    public ArgType getType() {
        return this.type;
    }

    public boolean isEnd() {
        return this.isEnd;
    }

    public int getStartAddr() {
        return this.startAddr;
    }

    public int getEndAddr() {
        return this.endAddr;
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return InsnUtils.formatOffset(this.startAddr) + '-' + (this.isEnd ? InsnUtils.formatOffset(this.endAddr) : "     ") + ": r" + this.regNum + " '" + this.name + "' " + this.type;
    }
}

